/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.util;

import com.jinfonet.dataservice.util.Int2KeyHashtableNode;
import com.jinfonet.dataservice.util.IntVector;
import java.util.Vector;

public class Int2KeyHashtable {
    private transient int SEDU;
    private int add;
    private float addElement;
    private transient Int2KeyHashtableNode[] append;

    public Int2KeyHashtable(int n) {
        this(n, 0.618f);
    }

    public Int2KeyHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.addElement = f;
        this.append = new Int2KeyHashtableNode[n];
        this.add = (int)((float)n * f);
    }

    public Int2KeyHashtable() {
        this(103, 0.618f);
    }

    public int size() {
        return this.SEDU;
    }

    public boolean isEmpty() {
        return this.SEDU == 0;
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.append.length; ++i) {
            Int2KeyHashtableNode int2KeyHashtableNode = this.append[i];
            while (int2KeyHashtableNode != null) {
                if (int2KeyHashtableNode.value.equals(object)) {
                    return true;
                }
                int2KeyHashtableNode = int2KeyHashtableNode.next;
            }
        }
        return false;
    }

    public synchronized Vector getKeys(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Vector<IntVector> vector = new Vector<IntVector>(5);
        for (int i = 0; i < this.append.length; ++i) {
            Int2KeyHashtableNode int2KeyHashtableNode = this.append[i];
            while (int2KeyHashtableNode != null) {
                if (int2KeyHashtableNode.value.equals(object)) {
                    IntVector intVector = new IntVector(2);
                    intVector.addElement(int2KeyHashtableNode.key1);
                    intVector.addElement(int2KeyHashtableNode.key2);
                    vector.add(intVector);
                }
                int2KeyHashtableNode = int2KeyHashtableNode.next;
            }
        }
        return vector;
    }

    public synchronized boolean containsKey(int n, int n2) {
        int n3 = this.SEDU(n, n2);
        Int2KeyHashtableNode int2KeyHashtableNode = this.append[n3];
        while (int2KeyHashtableNode != null) {
            if (int2KeyHashtableNode.key1 == n && int2KeyHashtableNode.key2 == n2) {
                return true;
            }
            int2KeyHashtableNode = int2KeyHashtableNode.next;
        }
        return false;
    }

    public synchronized Object get(int n, int n2) {
        int n3 = this.SEDU(n, n2);
        Int2KeyHashtableNode int2KeyHashtableNode = this.append[n3];
        while (int2KeyHashtableNode != null) {
            if (int2KeyHashtableNode.key1 == n && int2KeyHashtableNode.key2 == n2) {
                return int2KeyHashtableNode.value;
            }
            int2KeyHashtableNode = int2KeyHashtableNode.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.append.length;
        Int2KeyHashtableNode[] int2KeyHashtableNodeArray = this.append;
        int n2 = n * 2 + 1;
        Int2KeyHashtableNode[] int2KeyHashtableNodeArray2 = new Int2KeyHashtableNode[n2];
        this.add = (int)((float)n2 * this.addElement);
        this.append = int2KeyHashtableNodeArray2;
        for (int i = 0; i < n; ++i) {
            Int2KeyHashtableNode int2KeyHashtableNode = int2KeyHashtableNodeArray[i];
            while (int2KeyHashtableNode != null) {
                Int2KeyHashtableNode int2KeyHashtableNode2 = int2KeyHashtableNode;
                int2KeyHashtableNode = int2KeyHashtableNode.next;
                int n3 = (int2KeyHashtableNode2.key1 & int2KeyHashtableNode2.key2 & Integer.MAX_VALUE) % n2;
                int2KeyHashtableNode2.next = int2KeyHashtableNodeArray2[n3];
                int2KeyHashtableNodeArray2[n3] = int2KeyHashtableNode2;
            }
        }
    }

    public synchronized Object put(int n, int n2, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n3 = this.SEDU(n, n2);
        Int2KeyHashtableNode int2KeyHashtableNode = this.append[n3];
        while (int2KeyHashtableNode != null) {
            if (int2KeyHashtableNode.key1 == n && int2KeyHashtableNode.key2 == n2) {
                Object object2 = int2KeyHashtableNode.value;
                int2KeyHashtableNode.value = object;
                return object2;
            }
            int2KeyHashtableNode = int2KeyHashtableNode.next;
        }
        if (this.SEDU >= this.add) {
            this.rehash();
            return this.put(n, n2, object);
        }
        int2KeyHashtableNode = new Int2KeyHashtableNode();
        int2KeyHashtableNode.key1 = n;
        int2KeyHashtableNode.key2 = n2;
        int2KeyHashtableNode.value = object;
        int2KeyHashtableNode.next = this.append[n3];
        this.append[n3] = int2KeyHashtableNode;
        ++this.SEDU;
        return null;
    }

    public synchronized Object remove(int n, int n2) {
        int n3 = this.SEDU(n, n2);
        Int2KeyHashtableNode int2KeyHashtableNode = this.append[n3];
        Int2KeyHashtableNode int2KeyHashtableNode2 = null;
        while (int2KeyHashtableNode != null) {
            if (int2KeyHashtableNode.key1 == n && int2KeyHashtableNode.key2 == n2) {
                if (int2KeyHashtableNode2 != null) {
                    int2KeyHashtableNode2.next = int2KeyHashtableNode.next;
                } else {
                    this.append[n3] = int2KeyHashtableNode.next;
                }
                --this.SEDU;
                return int2KeyHashtableNode.value;
            }
            int2KeyHashtableNode2 = int2KeyHashtableNode;
            int2KeyHashtableNode = int2KeyHashtableNode.next;
        }
        return null;
    }

    private synchronized int SEDU(int n, int n2) {
        return (n & n2 & Integer.MAX_VALUE) % this.append.length;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.append.length; ++i) {
            this.append[i] = null;
        }
        this.SEDU = 0;
    }

    public synchronized Object clone() {
        Int2KeyHashtable int2KeyHashtable = new Int2KeyHashtable(this.append.length, this.addElement);
        for (int i = 0; i < this.append.length; ++i) {
            int2KeyHashtable.append[i] = this.append[i] != null ? (Int2KeyHashtableNode)this.append[i].clone() : null;
        }
        return int2KeyHashtable;
    }

    public synchronized IntVector keys1() {
        IntVector intVector = null;
        if (this.SEDU != 0) {
            intVector = new IntVector();
            for (int i = 0; i < this.append.length; ++i) {
                Int2KeyHashtableNode int2KeyHashtableNode = this.append[i];
                if (int2KeyHashtableNode == null) continue;
                do {
                    intVector.addElement(int2KeyHashtableNode.key1);
                } while ((int2KeyHashtableNode = int2KeyHashtableNode.next) != null);
            }
        }
        return intVector;
    }

    public synchronized IntVector keys2() {
        IntVector intVector = null;
        if (this.SEDU != 0) {
            intVector = new IntVector();
            for (int i = 0; i < this.append.length; ++i) {
                Int2KeyHashtableNode int2KeyHashtableNode = this.append[i];
                if (int2KeyHashtableNode == null) continue;
                do {
                    intVector.addElement(int2KeyHashtableNode.key2);
                } while ((int2KeyHashtableNode = int2KeyHashtableNode.next) != null);
            }
        }
        return intVector;
    }

    public synchronized Vector elements() {
        Vector<Object> vector = null;
        if (this.SEDU != 0) {
            vector = new Vector<Object>();
            for (int i = 0; i < this.append.length; ++i) {
                Int2KeyHashtableNode int2KeyHashtableNode = this.append[i];
                if (int2KeyHashtableNode == null) continue;
                do {
                    vector.addElement(int2KeyHashtableNode.value);
                } while ((int2KeyHashtableNode = int2KeyHashtableNode.next) != null);
            }
        }
        return vector;
    }

    public synchronized IntVector getSamekeys(int n, int n2) {
        IntVector intVector = new IntVector();
        IntVector intVector2 = null;
        IntVector intVector3 = null;
        switch (n2) {
            case 1: {
                intVector2 = this.keys2();
                intVector3 = this.keys1();
                for (int i = 0; i < intVector3.size(); ++i) {
                    if (intVector3.elementAt(i) != n) continue;
                    intVector.addElement(intVector2.elementAt(i));
                }
                return intVector;
            }
            case 2: {
                intVector3 = this.keys1();
                intVector2 = this.keys2();
                for (int i = 0; i < intVector2.size(); ++i) {
                    if (intVector2.elementAt(i) != n) continue;
                    intVector.addElement(intVector3.elementAt(i));
                }
                return intVector;
            }
        }
        return intVector;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.SEDU != 0) {
            stringBuffer.append("[");
            for (int i = 0; i < this.append.length; ++i) {
                Int2KeyHashtableNode int2KeyHashtableNode = this.append[i];
                if (int2KeyHashtableNode == null) continue;
                do {
                    stringBuffer.append("[").append(int2KeyHashtableNode.key1).append("&").append(int2KeyHashtableNode.key2).append(",").append(int2KeyHashtableNode.value == this ? super.toString() : int2KeyHashtableNode.value).append("],");
                } while ((int2KeyHashtableNode = int2KeyHashtableNode.next) != null);
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

