/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.util;

import com.jinfonet.dataservice.util.IntVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class IntHashtable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IntHashtableEntry[] table;
    private int count;
    public int threshold;
    private float loadFactor;

    public IntHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new IntHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public IntHashtable(int n) {
        this(n, 0.75f);
    }

    public IntHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = intHashtableEntryArray.length;
        while (n2-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n2];
            while (intHashtableEntry != null) {
                if (intHashtableEntry.value == n) {
                    return true;
                }
                intHashtableEntry = intHashtableEntry.next;
            }
        }
        return false;
    }

    public IntVector keys() {
        IntVector intVector = new IntVector();
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        for (int i = 0; i < intHashtableEntryArray.length; ++i) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[i];
            while (intHashtableEntry != null) {
                intVector.addElement(intHashtableEntry.key);
                intHashtableEntry = intHashtableEntry.next;
            }
        }
        return intVector;
    }

    public boolean containsKey(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                return true;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        return false;
    }

    public int get(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                return intHashtableEntry.value;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        return 0;
    }

    protected void rehash() {
        int n = this.table.length;
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        IntHashtableEntry[] intHashtableEntryArray2 = new IntHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = intHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
            while (intHashtableEntry != null) {
                IntHashtableEntry intHashtableEntry2 = intHashtableEntry;
                intHashtableEntry = intHashtableEntry.next;
                int n4 = (intHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                intHashtableEntry2.next = intHashtableEntryArray2[n4];
                intHashtableEntryArray2[n4] = intHashtableEntry2;
            }
        }
    }

    public int put(int n, int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = n;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n3 && intHashtableEntry.key == n) {
                int n5 = intHashtableEntry.value;
                intHashtableEntry.value = n2;
                return n5;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n, n2);
        }
        intHashtableEntry = new IntHashtableEntry();
        intHashtableEntry.hash = n3;
        intHashtableEntry.key = n;
        intHashtableEntry.value = n2;
        intHashtableEntry.next = intHashtableEntryArray[n4];
        intHashtableEntryArray[n4] = intHashtableEntry;
        ++this.count;
        return 0;
    }

    public int remove(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        IntHashtableEntry intHashtableEntry2 = null;
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                if (intHashtableEntry2 != null) {
                    intHashtableEntry2.next = intHashtableEntry.next;
                } else {
                    intHashtableEntryArray[n3] = intHashtableEntry.next;
                }
                --this.count;
                return intHashtableEntry.value;
            }
            intHashtableEntry2 = intHashtableEntry;
            intHashtableEntry = intHashtableEntry.next;
        }
        return 0;
    }

    public void clear() {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n = intHashtableEntryArray.length;
        while (--n >= 0) {
            intHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public int[] toOrderedKeys() {
        int[] nArray = new int[this.count];
        int n = 0;
        int n2 = this.table.length;
        IntHashtableEntry intHashtableEntry = null;
        while (true) {
            if (intHashtableEntry == null) {
                while (n2-- > 0 && (intHashtableEntry = this.table[n2]) == null) {
                }
            }
            if (intHashtableEntry == null) break;
            IntHashtableEntry intHashtableEntry2 = intHashtableEntry;
            intHashtableEntry = intHashtableEntry2.next;
            nArray[n++] = intHashtableEntry2.key;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public int getOneKey() {
        if (this.count == 0) {
            return 0;
        }
        int n = this.table.length;
        IntHashtableEntry intHashtableEntry = null;
        while (n-- > 0 && (intHashtableEntry = this.table[n]) == null) {
        }
        if (intHashtableEntry == null) {
            return 0;
        }
        return intHashtableEntry.key;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.count);
        objectOutputStream.writeInt(this.threshold);
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.table.length);
        for (int i = 0; i < this.table.length; ++i) {
            IntHashtableEntry intHashtableEntry = this.table[i];
            while (intHashtableEntry != null) {
                objectOutputStream.writeInt(intHashtableEntry.key);
                objectOutputStream.writeInt(intHashtableEntry.value);
                intHashtableEntry = intHashtableEntry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.count = 0;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.threshold = objectInputStream.readInt();
        this.loadFactor = objectInputStream.readFloat();
        this.table = new IntHashtableEntry[objectInputStream.readInt()];
        for (int i = 0; i < n; ++i) {
            this.put(objectInputStream.readInt(), objectInputStream.readInt());
        }
    }

    class IntHashtableEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int hash;
        int key;
        int value;
        IntHashtableEntry next;

        IntHashtableEntry() {
        }
    }
}

