/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.util;

import java.io.IOException;
import java.net.URL;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class IntrinsicXmlSchema {
    private static final String SEDU = "resource/XMLSchema.xsd";
    private static final String currentThread = "resource/XMLSchema.dtd";
    private static final String getClass = "resource/datatypes.dtd";
    private static final String getClassLoader = "resource/xml.xsd";

    public static XmlSchema getIntrinsicXmlSchema() {
        ClassLoader classLoader = IntrinsicXmlSchema.class.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        URL uRL = classLoader.getResource(SEDU);
        String string = uRL.toString();
        XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
        xmlSchemaCollection.setBaseUri(string);
        xmlSchemaCollection.setSchemaResolver(new URIResolver(){

            public InputSource resolveEntity(String string, String string2, String string3) {
                InputSource inputSource = new InputSource(string2);
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                inputSource.setByteStream(classLoader.getResourceAsStream(IntrinsicXmlSchema.getClassLoader));
                return inputSource;
            }
        });
        Document document = null;
        document = IntrinsicXmlSchema.SEDU(new InputSource(uRL.toString()));
        Element element = document.getDocumentElement();
        return xmlSchemaCollection.read(element, string);
    }

    private static Document SEDU(InputSource inputSource) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                InputSource inputSource = new InputSource(string2);
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                String string3 = "";
                if (string2.endsWith("XMLSchema.dtd")) {
                    string3 = IntrinsicXmlSchema.currentThread;
                } else if (string2.endsWith("datatypes.dtd")) {
                    string3 = IntrinsicXmlSchema.getClass;
                }
                inputSource.setByteStream(classLoader.getResourceAsStream(string3));
                return inputSource;
            }
        });
        try {
            dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
            dOMParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        Document document = null;
        try {
            dOMParser.parse(inputSource);
            document = dOMParser.getDocument();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return document;
    }
}

