/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.util;

import com.jinfonet.api.datatypes.Array;
import com.jinfonet.api.datatypes.Date;
import com.jinfonet.api.datatypes.Time;
import com.jinfonet.api.datatypes.Timestamp;
import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.relational.ITuple;
import com.jinfonet.dataservice.util.BaseHasher;
import com.jinfonet.dataservice.util.ColumnInfo;
import java.math.BigDecimal;
import jet.dataengine.api.DSException;

public class TupleHasher
extends BaseHasher {
    private ColumnInfo[] I;

    public TupleHasher(JRelationMetaData jRelationMetaData, String[] stringArray, int n, int n2) throws DSException {
        super(n, n2);
        int n3;
        int n4;
        String[] stringArray2 = null;
        if (stringArray == null || stringArray.length == 0) {
            n4 = jRelationMetaData.getColumnCount();
            stringArray2 = new String[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                stringArray2[n3] = jRelationMetaData.getAttribute(n3 + 1).getAliasName();
            }
        } else {
            stringArray2 = stringArray;
        }
        this.I = new ColumnInfo[stringArray2.length];
        for (n4 = 0; n4 < stringArray2.length; ++n4) {
            n3 = jRelationMetaData.findColumn(stringArray2[n4]);
            int n5 = jRelationMetaData.getColumnType(n3);
            boolean bl = jRelationMetaData.isCaseSensitive(n3);
            this.I[n4] = new ColumnInfo(n3, n5, bl);
        }
    }

    public int hash(ITuple iTuple) throws DSException {
        int n = this.multiplierNonZeroOddNumber;
        block15: for (ColumnInfo columnInfo : this.I) {
            int n2 = columnInfo.index;
            n *= this.initialNonZeroOddNumber;
            if (iTuple.isNull(n2)) continue;
            switch (columnInfo.type) {
                case -6: {
                    n += iTuple.getByte(n2);
                    continue block15;
                }
                case 4: {
                    n += iTuple.getInt(n2);
                    continue block15;
                }
                case 5: {
                    n += iTuple.getShort(n2);
                    continue block15;
                }
                case -5: {
                    long l = iTuple.getLong(n2);
                    n += this.hashLong(l);
                    continue block15;
                }
                case 6: {
                    float f = iTuple.getFloat(n2);
                    n += Float.floatToIntBits(f);
                    continue block15;
                }
                case 8: {
                    double d = iTuple.getDouble(n2);
                    long l = Double.doubleToLongBits(d);
                    n += this.hashLong(l);
                    continue block15;
                }
                case 91: {
                    Date date = iTuple.getDate(n2);
                    n += this.hashLong(date.getTime());
                    continue block15;
                }
                case 92: {
                    Time time2 = iTuple.getTime(n2);
                    n += this.hashLong(time2.getTime());
                    continue block15;
                }
                case 93: {
                    Timestamp timestamp = iTuple.getTimeStamp(n2);
                    n += this.hashLong(timestamp.getTime()) + timestamp.getNanos();
                    continue block15;
                }
                case -7: {
                    boolean bl = iTuple.getBoolean(n2);
                    n += bl ? 1 : 0;
                    continue block15;
                }
                case 12: 
                case 2005: {
                    String string = iTuple.getString(n2);
                    n += string.hashCode();
                    continue block15;
                }
                case 3: {
                    BigDecimal bigDecimal = iTuple.getBigDecimal(n2);
                    n += bigDecimal.hashCode();
                    continue block15;
                }
                case 2003: {
                    Array array = iTuple.getArray(n2);
                    n += this.hashArray(array);
                    continue block15;
                }
                default: {
                    throw new IllegalArgumentException("unsupported data type: " + Types.getDataTypeName(columnInfo.type));
                }
            }
        }
        return n;
    }
}

