/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dom.css.impl;

import com.jinfonet.dom.css.JCSSCharsetRule;
import com.jinfonet.dom.css.JCSSStyleSheet;
import com.jinfonet.dom.css.impl.JDOMException;
import com.jinfonet.dom.css.impl.JLitConvertKit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;

public class JCSSCharsetRuleImpl
implements JCSSCharsetRule {
    private static final long serialVersionUID = 0x100100L;
    CSSStyleSheet parentStyleSheet = null;
    CSSRule parentRule = null;
    String encoding = null;

    public JCSSCharsetRuleImpl(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule, String string) {
        this.parentStyleSheet = JLitConvertKit.cvStyleSheet(cSSStyleSheet);
        this.parentRule = JLitConvertKit.cvCSSRule(cSSRule);
        this.encoding = string;
    }

    public JCSSCharsetRuleImpl() {
    }

    @Override
    public short getType() {
        return 2;
    }

    @Override
    public String getCssText() {
        return "@charset \"" + this.getEncoding() + "\";";
    }

    @Override
    public void setCssText(String string) throws DOMException {
        if (this.parentStyleSheet != null && ((JCSSStyleSheet)this.parentStyleSheet).isReadOnly()) {
            throw new JDOMException(7, 2);
        }
        String string2 = string.toLowerCase();
        int n = string2.indexOf("@charset");
        if (n >= 0) {
            int n2 = string2.indexOf("\"", n + 1);
            int n3 = string2.indexOf("\"", n2 + 1);
            int n4 = string2.indexOf(";", n2 + 1);
            if (n2 > 0 && n3 > n2 && n4 > n3) {
                this.setEncoding(string.substring(n2 + 1, n3));
                return;
            }
        }
        throw new JDOMException(12, 0);
    }

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return this.parentStyleSheet;
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public CSSCharsetRule duplate() {
        return new JCSSCharsetRuleImpl(this.parentStyleSheet, this.parentRule, this.encoding);
    }

    @Override
    public void resetParent(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule) {
        this.parentStyleSheet = JLitConvertKit.cvStyleSheet(cSSStyleSheet);
        this.parentRule = JLitConvertKit.cvCSSRule(cSSRule);
    }

    public String toString() {
        return this.getCssText();
    }
}

