/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dom.css.impl;

import com.jinfonet.css.sac.impl.parser.JCSSDOMParser;
import com.jinfonet.dom.css.JCSSImportRule;
import com.jinfonet.dom.css.JCSSStyleSheet;
import com.jinfonet.dom.css.JMediaList;
import com.jinfonet.dom.css.impl.JDOMException;
import com.jinfonet.dom.css.impl.JLitConvertKit;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class JCSSImportRuleImpl
implements JCSSImportRule {
    private static final long serialVersionUID = 0x100100L;
    CSSStyleSheet parentStyleSheet = null;
    CSSRule parentRule = null;
    String href = null;
    MediaList media = null;

    public JCSSImportRuleImpl(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule, String string, MediaList mediaList) {
        this.parentStyleSheet = JLitConvertKit.cvStyleSheet(cSSStyleSheet);
        this.parentRule = JLitConvertKit.cvCSSRule(cSSRule);
        this.href = string;
        this.media = JLitConvertKit.cvMediaList(mediaList);
    }

    public JCSSImportRuleImpl() {
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@import url(").append(this.getHref()).append(")");
        if (this.getMedia().getLength() > 0) {
            stringBuffer.append(" ").append(this.getMedia().toString());
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    @Override
    public void setCssText(String string) throws DOMException {
        if (this.parentStyleSheet != null && ((JCSSStyleSheet)this.parentStyleSheet).isReadOnly()) {
            throw new JDOMException(7, 2);
        }
        try {
            InputSource inputSource = new InputSource((Reader)new StringReader(string));
            JCSSDOMParser jCSSDOMParser = JCSSDOMParser.newInstance();
            CSSRule cSSRule = jCSSDOMParser.parseRule(inputSource);
            if (cSSRule == null || cSSRule.getType() != 3) {
                throw new JDOMException(13, 6);
            }
            this.href = ((JCSSImportRuleImpl)cSSRule).href;
            this.media = ((JCSSImportRuleImpl)cSSRule).media;
        }
        catch (CSSException cSSException) {
            throw new JDOMException(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new JDOMException(12, 0, iOException.getMessage());
        }
    }

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return this.parentStyleSheet;
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public MediaList getMedia() {
        return this.media;
    }

    @Override
    public CSSStyleSheet getStyleSheet() {
        JCSSDOMParser jCSSDOMParser = JCSSDOMParser.newInstance();
        try {
            Reader reader = this.getImportIO();
            return jCSSDOMParser.parseStyleSheet(new InputSource(reader));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Reader getImportIO() throws Exception {
        if (this.href.indexOf("://") >= 0) {
            URL uRL = new URL(this.href);
            return new InputStreamReader(uRL.openStream());
        }
        return new FileReader(this.href);
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public void resetParent(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule) {
        this.parentStyleSheet = JLitConvertKit.cvStyleSheet(cSSStyleSheet);
        this.parentRule = JLitConvertKit.cvCSSRule(cSSRule);
    }

    @Override
    public CSSImportRule duplate() {
        return new JCSSImportRuleImpl(this.parentStyleSheet, this.parentRule, this.href, ((JMediaList)this.media).duplate());
    }
}

