/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.image.encoder.gif;

import com.jinfonet.image.encoder.ImageFrame;
import com.jinfonet.image.encoder.gif.SubFrame;
import com.jinfonet.util.LZWTools;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import jet.util.IntKeyHashtable;
import jet.util.IntVector;

public class GIFEncoder {
    private static final String J = "GIF";
    private static final String SEDU = "89a";
    private static final byte addElement = 44;
    private static final byte bitsPerPixel = 33;
    private static final byte clear = -7;
    private static final byte compressDataForGIF89 = 1;
    private static final byte containsKey = -1;
    private static final byte delay = -2;
    private static final byte elementAt = 59;
    private static final int equals = 0;
    private static final int getAlpha = 1;
    private static final int getBlue = 2;
    private static final int getBlues = 3;
    private static final int getGreen = 8;

    private GIFEncoder() {
    }

    public static void encode(DataOutput dataOutput, Vector vector) throws IOException {
        Object object;
        int n;
        GIFEncoder.J(dataOutput);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        ColorModel colorModel = null;
        for (n = 0; n < vector.size(); ++n) {
            object = (ImageFrame)vector.elementAt(n);
            n2 = Math.max(((ImageFrame)object).x + ((ImageFrame)object).width, n2);
            n3 = Math.max(((ImageFrame)object).y + ((ImageFrame)object).height, n3);
            if (bl) {
                if (colorModel == null) {
                    colorModel = ((ImageFrame)object).model;
                } else {
                    bl = colorModel.equals(((ImageFrame)object).model);
                }
            }
            n4 = Math.max(((ImageFrame)object).model.getPixelSize(), n4);
        }
        boolean bl2 = n4 <= 8;
        n4 = GIFEncoder.delay(n4);
        GIFEncoder.SEDU(dataOutput, n2, n3, n4, (bl &= bl2) ? n4 : 0, 0, 0, bl, false);
        for (n = 0; n < vector.size(); ++n) {
            object = GIFEncoder.elementAt((ImageFrame)vector.elementAt(n), bl);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                SubFrame subFrame = (SubFrame)((Vector)object).elementAt(i);
                if (n == 0 && i == 0 && bl) {
                    GIFEncoder.addElement(dataOutput, subFrame.bitsPerPixel, (byte[])subFrame.lctDescriptor[0], (byte[])subFrame.lctDescriptor[1], (byte[])subFrame.lctDescriptor[2]);
                }
                int n5 = (Integer)subFrame.lctDescriptor[3];
                if (subFrame.delay > 0L || n5 != -1) {
                    GIFEncoder.bitsPerPixel(dataOutput, 0, (int)((subFrame.delay + 99L) / 100L), n5, false);
                }
                GIFEncoder.clear(dataOutput, subFrame.x, subFrame.y, subFrame.width, subFrame.height, subFrame.bitsPerPixel, !bl, false, false);
                if (!bl) {
                    GIFEncoder.addElement(dataOutput, subFrame.bitsPerPixel, (byte[])subFrame.lctDescriptor[0], (byte[])subFrame.lctDescriptor[1], (byte[])subFrame.lctDescriptor[2]);
                }
                dataOutput.write(subFrame.bitsPerPixel);
                byte[] byArray = LZWTools.compressDataForGIF89(subFrame.pixels, subFrame.bitsPerPixel);
                for (int j = 0; j < byArray.length; j += 255) {
                    int n6 = Math.min(255, byArray.length - j);
                    dataOutput.write(n6);
                    dataOutput.write(byArray, j, n6);
                }
                dataOutput.write(0);
            }
        }
        GIFEncoder.compressDataForGIF89(dataOutput);
    }

    private static void J(DataOutput dataOutput) throws IOException {
        dataOutput.writeBytes("GIF89a");
    }

    private static void SEDU(DataOutput dataOutput, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) throws IOException {
        GIFEncoder.containsKey(dataOutput, n);
        GIFEncoder.containsKey(dataOutput, n2);
        dataOutput.writeByte((bl ? 128 : 0) | n3 - 1 << 4 | (bl2 ? 8 : 0) | (bl ? n4 - 1 : 0));
        dataOutput.writeByte(n5);
        dataOutput.writeByte(n6);
    }

    private static void addElement(DataOutput dataOutput, int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        for (int i = 0; i < 1 << n; ++i) {
            if (byArray.length > i) {
                dataOutput.writeByte(byArray[i]);
                dataOutput.writeByte(byArray2[i]);
                dataOutput.writeByte(byArray3[i]);
                continue;
            }
            dataOutput.writeByte(0);
            dataOutput.writeByte(0);
            dataOutput.writeByte(0);
        }
    }

    private static void bitsPerPixel(DataOutput dataOutput, int n, int n2, int n3, boolean bl) throws IOException {
        dataOutput.writeByte(33);
        dataOutput.writeByte(-7);
        dataOutput.writeByte(4);
        dataOutput.writeByte(n << 2 | (bl ? 2 : 0) | (n3 != -1 ? 1 : 0));
        GIFEncoder.containsKey(dataOutput, n2);
        dataOutput.writeByte(0xFF & (n3 != -1 ? n3 : 0));
        dataOutput.writeByte(0);
    }

    private static void clear(DataOutput dataOutput, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) throws IOException {
        dataOutput.writeByte(44);
        GIFEncoder.containsKey(dataOutput, n);
        GIFEncoder.containsKey(dataOutput, n2);
        GIFEncoder.containsKey(dataOutput, n3);
        GIFEncoder.containsKey(dataOutput, n4);
        dataOutput.writeByte((bl ? 128 : 0) | (bl2 ? 64 : 0) | (bl3 ? 32 : 0) | (bl ? n5 - 1 : 0));
    }

    private static void compressDataForGIF89(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(59);
    }

    private static void containsKey(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeByte(0xFF & n);
        dataOutput.writeByte(0xFF & n >> 8);
    }

    private static int delay(int n) {
        return Math.min(Math.max(n, 2), 8);
    }

    private static Vector elementAt(ImageFrame imageFrame, boolean bl) {
        Vector<SubFrame> vector = new Vector<SubFrame>();
        if (bl) {
            SubFrame subFrame = new SubFrame();
            subFrame.x = imageFrame.x;
            subFrame.y = imageFrame.y;
            subFrame.width = imageFrame.width;
            subFrame.height = imageFrame.height;
            subFrame.delay = imageFrame.delay;
            subFrame.bitsPerPixel = GIFEncoder.delay(imageFrame.model.getPixelSize());
            subFrame.lctDescriptor = new Object[4];
            subFrame.pixels = GIFEncoder.equals(imageFrame.model, imageFrame.pixels, imageFrame.width, subFrame.lctDescriptor, 0);
            vector.addElement(subFrame);
        } else {
            int n = 0;
            int n2 = 0;
            n2 = imageFrame.pixels instanceof byte[] ? ((byte[])imageFrame.pixels).length : ((int[])imageFrame.pixels).length;
            while (n < n2) {
                SubFrame subFrame = new SubFrame();
                subFrame.x = imageFrame.x + n % imageFrame.width;
                subFrame.y = imageFrame.y + n / imageFrame.width;
                subFrame.lctDescriptor = new Object[4];
                subFrame.pixels = GIFEncoder.equals(imageFrame.model, imageFrame.pixels, imageFrame.width, subFrame.lctDescriptor, n);
                while (1 << subFrame.bitsPerPixel < ((byte[])subFrame.lctDescriptor[0]).length) {
                    ++subFrame.bitsPerPixel;
                }
                subFrame.height = (subFrame.pixels.length + imageFrame.width - 1) / imageFrame.width;
                subFrame.width = subFrame.pixels.length - (subFrame.height - 1) * imageFrame.width;
                if ((n += subFrame.pixels.length) == n2) {
                    subFrame.delay = imageFrame.delay;
                }
                vector.addElement(subFrame);
            }
        }
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] equals(ColorModel colorModel, Object object, int n, Object[] objectArray, int n2) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n3 = -1;
        if (colorModel.getPixelSize() <= 8 && colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n4 = indexColorModel.getMapSize();
            byArray = new byte[n4];
            byArray2 = new byte[n4];
            byArray3 = new byte[n4];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            n3 = indexColorModel.getTransparentPixel();
            if (n3 != -1 && indexColorModel.getAlpha(n3) != 0) {
                n3 = -1;
            }
            byArray4 = (byte[])object;
        } else {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11 = n2 % n;
            int n12 = n2 / n;
            int n13 = 0;
            int n14 = 0;
            n14 = n11 == 0 ? (object instanceof byte[] ? ((byte[])object).length - n2 : ((int[])object).length - n2) : n - n11;
            int n15 = 256;
            int n16 = -1;
            IntKeyHashtable intKeyHashtable = new IntKeyHashtable(n15);
            int n17 = n15;
            IntKeyHashtable intKeyHashtable2 = new IntKeyHashtable(n15);
            while (n13 < n14) {
                IntVector intVector;
                int n18 = object instanceof byte[] ? ((byte[])object)[n2 + n13] : ((int[])object)[n2 + n13];
                n10 = colorModel.getAlpha(n18);
                if (n10 != 0) {
                    n9 = colorModel.getRed(n18) * n10 / 255;
                    n6 = (0xFF & n9) << 16 | (0xFF & (n8 = colorModel.getGreen(n18) * n10 / 255)) << 8 | 0xFF & (n7 = colorModel.getBlue(n18) * n10 / 255);
                    if (!intKeyHashtable.containsKey(n6) && !intKeyHashtable2.containsKey(n6)) {
                        if (intKeyHashtable2.size() < n17) {
                            intKeyHashtable2.put(n6, intKeyHashtable);
                        } else {
                            if (intKeyHashtable.isEmpty()) {
                                IntVector intVector2 = intKeyHashtable2.keys();
                                for (n5 = 0; n5 < intVector2.size(); ++n5) {
                                    intKeyHashtable.put(intVector2.elementAt(n5), intKeyHashtable);
                                }
                            } else {
                                n13 -= (n2 + n13) % n;
                            }
                            intKeyHashtable2.clear();
                            break;
                        }
                    }
                } else if (n16 == -1) {
                    if (intKeyHashtable2.size() >= n17) break;
                    int n19 = colorModel.getRed(n18) * n10 / 255;
                    n8 = colorModel.getGreen(n18) * n10 / 255;
                    n7 = colorModel.getBlue(n18) * n10 / 255;
                    n16 = (0xFF & n19) << 16 | (0xFF & n8) << 8 | 0xFF & n7;
                    --n17;
                    --n15;
                }
                if ((n2 + ++n13) % n != 0 || (intVector = intKeyHashtable2.keys()) == null) continue;
                for (n8 = 0; n8 < intVector.size(); ++n8) {
                    intKeyHashtable.put(intVector.elementAt(n8), intKeyHashtable);
                }
                intKeyHashtable2.clear();
                n17 = n15 - intKeyHashtable.size();
            }
            IntVector intVector = intKeyHashtable.keys();
            byArray4 = new byte[n13];
            for (n10 = 0; n10 < n13; ++n10) {
                n9 = object instanceof byte[] ? ((byte[])object)[n2 + n10] : ((int[])object)[n2 + n10];
                n8 = colorModel.getAlpha(n9);
                if (n8 != 0) {
                    n7 = colorModel.getRed(n9) * n8 / 255;
                    n6 = colorModel.getGreen(n9) * n8 / 255;
                    int n20 = colorModel.getBlue(n9) * n8 / 255;
                    n5 = (0xFF & n7) << 16 | (0xFF & n6) << 8 | 0xFF & n20;
                    byArray4[n10] = (byte)intVector.indexOf(n5);
                    continue;
                }
                byArray4[n10] = (byte)intVector.size();
            }
            n10 = intVector.size() + (n16 != -1 ? 1 : 0);
            byArray = new byte[n10];
            byArray2 = new byte[n10];
            byArray3 = new byte[n10];
            for (n9 = 0; n9 < intVector.size(); ++n9) {
                n8 = intVector.elementAt(n9);
                byArray[n9] = (byte)((0xFF0000 & n8) >> 16);
                byArray2[n9] = (byte)((0xFF00 & n8) >> 8);
                byArray3[n9] = (byte)(0xFF & n8);
            }
            if (n16 != -1) {
                byArray[n10 - 1] = (byte)((0xFF0000 & n16) >> 16);
                byArray2[n10 - 1] = (byte)((0xFF00 & n16) >> 8);
                byArray3[n10 - 1] = (byte)(0xFF & n16);
            }
        }
        objectArray[0] = byArray;
        objectArray[1] = byArray2;
        objectArray[2] = byArray3;
        objectArray[3] = new Integer(n3);
        return byArray4;
    }
}

