/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc;

import com.jinfonet.jdbc.ColumnDesc;
import com.jinfonet.jdbc.UnsupportedException;
import com.jinfonet.jdbc.util.TypeTools;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;

public class JMetaData
implements ResultSetMetaData {
    ColumnDesc[] columns;
    Hashtable indexOfCol = new Hashtable();

    public JMetaData(ColumnDesc[] columnDescArray) {
        this.columns = columnDescArray;
        for (int i = 0; i < columnDescArray.length; ++i) {
            this.indexOfCol.put(columnDescArray[i].getColName(), new Integer(i));
        }
    }

    public int indexOfColumn(String string) {
        return (Integer)this.indexOfCol.get(string);
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return this.columns[n - 1].getCatalogName();
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        return TypeTools.mapTypeToClass(this.columns[n - 1].getSqlType()).getName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.length;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        return this.columns[n - 1].getPrecision();
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.columns[n - 1].getColName();
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.columns[n - 1].getColName();
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        return this.columns[n - 1].getSqlType();
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        return TypeTools.mapTypeToString(this.columns[n - 1].getSqlType());
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return this.columns[n - 1].getPrecision();
    }

    @Override
    public int getScale(int n) throws SQLException {
        return this.columns[n - 1].getScale();
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return this.columns[n - 1].getSchemaName();
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return this.columns[n - 1].getTableName();
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return this.columns[n - 1].isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        return this.columns[n - 1].isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return this.columns[n - 1].isCurrency();
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return this.columns[n - 1].isDefinitelyWritable();
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return this.columns[n - 1].isNullable();
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return this.columns[n - 1].isReadOnly();
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        return this.columns[n - 1].isSearchable();
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return this.columns[n - 1].isSigned();
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return this.columns[n - 1].isWritable();
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        throw new UnsupportedException();
    }

    public Object unwrap(Class clazz) throws SQLException {
        throw new UnsupportedException();
    }
}

