/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.join;

import com.jinfonet.jdbc.ColumnDesc;
import com.jinfonet.jdbc.join.JoinNode;
import com.jinfonet.jdbc.join.RelationResult;
import com.jinfonet.jdbc.join.Result;
import com.jinfonet.jdbc.join.TableNode;
import com.jinfonet.jdbc.join.TableResult;
import com.jinfonet.jdbc.util.IntCircle;
import java.util.Hashtable;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.log.JRLogger;
import jet.util.IntVector;

public class JoinEngine {
    private boolean B;
    private Hashtable D;
    private Result F;
    private Result I;
    private IntVector[] J = null;
    private static JRLogger S = JRLogger.getLogger(JoinEngine.class.getName());

    public JoinEngine(JoinNode joinNode, Result result, Result result2) {
        TableNode[] tableNodeArray = joinNode.getTableNode();
        this.B = joinNode.bOrder;
        result.setCmpColumn(tableNodeArray[0].columnDesc);
        boolean bl = result2.setCmpColumn(tableNodeArray[1].columnDesc);
        this.F = result;
        this.I = bl ? result2 : null;
        boolean bl2 = false;
        if (joinNode.isInnerJoin && bl && this.F.size() > this.I.size()) {
            this.D();
            bl2 = true;
        }
        if (tableNodeArray[0].getRefColumns() != null) {
            this.J = new IntVector[2];
            if (!bl2) {
                this.J[0] = this.B(result, tableNodeArray[0].getRefColumns());
                this.J[1] = this.B(result2, tableNodeArray[1].getRefColumns());
            } else if (result2 != null) {
                this.J[1] = this.B(result, tableNodeArray[0].getRefColumns());
                this.J[0] = this.B(result2, tableNodeArray[1].getRefColumns());
            } else {
                this.J[0] = this.B(result, tableNodeArray[0].getRefColumns());
                this.J[1] = this.B(result, tableNodeArray[1].getRefColumns());
            }
        }
    }

    private IntVector B(Result result, ColumnDesc[] columnDescArray) {
        int n = columnDescArray.length;
        IntVector intVector = new IntVector(n);
        for (int i = 0; i < n; ++i) {
            intVector.addElement(Result.getCmpColumn(result.columnDescs, columnDescArray[i]));
        }
        return intVector;
    }

    private void D() {
        Result result = this.I;
        this.I = this.F;
        this.F = result;
    }

    public RelationResult doJoin() {
        RelationResult relationResult = new RelationResult(this.F, this.I);
        if (this.F instanceof TableResult) {
            ((TableResult)this.F).initBuffer(true);
        }
        if (this.I != null && this.I instanceof TableResult) {
            ((TableResult)this.I).initBuffer(false);
        }
        if (this.I != null) {
            if (!this.B) {
                this.append(relationResult);
            } else {
                this.S(relationResult);
            }
        } else {
            this.F(relationResult);
        }
        relationResult.close();
        this.clear();
        return relationResult;
    }

    private void F(RelationResult relationResult) {
        while (this.F.next()) {
            DbValue dbValue;
            DbValue dbValue2 = this.F.getCmpCol();
            if (!this.compare(dbValue2, dbValue = this.F.getCmpCol2())) continue;
            DbValue[] dbValueArray = this.F.getCurRecord();
            if (this.J != null && !this.refCmpare(dbValueArray, null)) continue;
            relationResult.pushRecord(dbValueArray, null);
        }
    }

    private void I(RelationResult relationResult) {
        DbValue[] dbValueArray = this.F.getCurRecord();
        DbValue[] dbValueArray2 = this.I.getCurRecord();
        if (this.J == null || this.refCmpare(dbValueArray, dbValueArray2)) {
            relationResult.pushRecord(dbValueArray, dbValueArray2);
        }
    }

    private void J(Result result, int n) {
        result.setCurrent(n - 1);
    }

    private void S(RelationResult relationResult) {
        DbValue dbValue;
        DbValue dbValue2 = null;
        int n = -2;
        this.F.buffer.setNeedWaitFetch(true);
        this.I.next();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        boolean bl = false;
        while (bl || this.F.next()) {
            dbValue2 = this.F.getCmpCol();
            dbValue = this.I.getCmpCol();
            n = dbValue2.compareTo(dbValue);
            bl = false;
            switch (n) {
                case 1: {
                    if (!this.I.next()) {
                        return;
                    }
                    bl = true;
                    if (n3 <= -1 || this.addElement(n2, n3, dbValue = this.I.getCmpCol(), relationResult)) break;
                    n2 = -1;
                    n3 = -1;
                    break;
                }
                case -1: {
                    n2 = -1;
                    n3 = -1;
                    break;
                }
                case 0: {
                    this.I(relationResult);
                    n4 = this.F.getCursor();
                    if (n2 == -1) {
                        n2 = n4;
                    }
                    n3 = n4;
                }
            }
        }
        this.F.reStart();
        while (this.I.next() && n == 0) {
            dbValue = this.I.getCmpCol();
            this.addElement(n2, n3, dbValue, relationResult);
        }
    }

    private void SEDU(DbValue[] dbValueArray, DbValue[] dbValueArray2) {
        for (int i = 0; i < dbValueArray.length; ++i) {
            dbValueArray2[i] = (DbValue)dbValueArray[i].clone();
        }
    }

    private boolean addElement(int n, int n2, DbValue dbValue, RelationResult relationResult) {
        boolean bl = false;
        int n3 = this.F.curRecord.length;
        DbValue[] dbValueArray = new DbValue[n3];
        this.SEDU(this.F.curRecord, dbValueArray);
        for (int i = n; i <= n2; ++i) {
            this.J(this.F, i);
            DbValue dbValue2 = this.F.getCmpCol();
            int n4 = dbValue2.compareTo(dbValue);
            if (n4 != 0) break;
            this.I(relationResult);
            bl = true;
        }
        this.SEDU(dbValueArray, this.F.curRecord);
        return bl;
    }

    private void append(RelationResult relationResult) {
        this.D = new Hashtable();
        if (this.I.next()) {
            DbValue dbValue = this.I.getCmpCol();
            while (this.F.next()) {
                DbValue dbValue2 = this.F.getCmpCol();
                this.putIndex(dbValue2, this.F.getCursor());
                if (!this.compare(dbValue2, dbValue)) continue;
                this.I(relationResult);
            }
            this.F.reStart();
            while (this.I.next()) {
                dbValue = this.I.getCmpCol();
                IntVector intVector = this.findMatch(dbValue);
                if (intVector == null) continue;
                for (int i = 0; i < intVector.size(); ++i) {
                    int n = intVector.elementAt(i);
                    this.J(this.F, n);
                    this.I(relationResult);
                }
            }
        }
    }

    protected boolean refCmpare(DbValue[] dbValueArray, DbValue[] dbValueArray2) {
        IntVector intVector = this.J[0];
        IntVector intVector2 = this.J[1];
        boolean bl = true;
        for (int i = 0; i < intVector.size() && bl; ++i) {
            int n = intVector.elementAt(i);
            int n2 = intVector2.elementAt(i);
            bl = bl && this.compare(dbValueArray[n], dbValueArray2 == null ? dbValueArray[n2] : dbValueArray2[n2]);
        }
        return bl;
    }

    protected boolean compare(DbValue dbValue, DbValue dbValue2) {
        return dbValue.compareTo(dbValue2) == 0;
    }

    protected IntVector findMatch(DbValue dbValue) {
        IntVector intVector = (IntVector)this.D.get(this.bOrder(dbValue));
        return intVector;
    }

    protected void putIndex(DbValue dbValue, int n) {
        Object object = this.bOrder(dbValue);
        IntCircle intCircle = (IntCircle)this.D.get(object);
        if (intCircle == null) {
            intCircle = new IntCircle();
            intCircle.addElement(n);
        } else if (!intCircle.contains(n)) {
            intCircle.addElement(n);
        }
        this.D.put(object, intCircle);
    }

    private Object bOrder(DbValue dbValue) {
        Object object = null;
        switch (dbValue.getColDesc().getSqlType()) {
            case -6: {
                DbTinyInt dbTinyInt = (DbTinyInt)dbValue;
                object = new Integer(dbTinyInt.value);
                break;
            }
            case 5: {
                DbSmallInt dbSmallInt = (DbSmallInt)dbValue;
                object = new Integer(dbSmallInt.value);
                break;
            }
            case 4: {
                DbInteger dbInteger = (DbInteger)dbValue;
                object = new Integer(dbInteger.value);
                break;
            }
            case -5: {
                DbBigInt dbBigInt = (DbBigInt)dbValue;
                object = new Long(dbBigInt.value);
                break;
            }
            case 7: {
                DbReal dbReal = (DbReal)dbValue;
                object = new Float(dbReal.value);
                break;
            }
            case 2: 
            case 3: {
                DbDecimal dbDecimal = (DbDecimal)dbValue;
                object = dbDecimal.value;
                break;
            }
            case 6: 
            case 8: {
                DbDouble dbDouble = (DbDouble)dbValue;
                object = new Double(dbDouble.value);
                break;
            }
            case -7: {
                DbBit dbBit = (DbBit)dbValue;
                object = new Boolean(dbBit.value);
                break;
            }
            case 91: {
                DbDate dbDate = (DbDate)dbValue;
                object = new Long(dbDate.value);
                break;
            }
            case 92: {
                DbTime dbTime = (DbTime)dbValue;
                object = new Long(dbTime.value);
                break;
            }
            case 93: {
                DbTimestamp dbTimestamp = (DbTimestamp)dbValue;
                object = new Long(dbTimestamp.value);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                DbChar dbChar = (DbChar)dbValue;
                object = dbChar.value;
                break;
            }
            case -4: 
            case -2: {
                DbBinary dbBinary = (DbBinary)dbValue;
                object = dbBinary.value;
                break;
            }
        }
        return object;
    }

    protected void clear() {
        this.D = null;
        this.F.clear();
        if (this.I != null) {
            this.I.clear();
        }
    }

    public String toString() {
        return "Join " + this.F + " " + this.I;
    }

    private void buffer(String string) {
    }
}

