/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.join;

import com.jinfonet.jdbc.join.TableNode;
import jet.log.JRLogger;

public class JoinNode {
    TableNode node1;
    TableNode node2;
    boolean bOrder = false;
    boolean isInnerJoin = true;
    boolean bSwap = false;
    private static JRLogger I = JRLogger.getLogger(JoinNode.class.getName());

    public JoinNode(TableNode tableNode, TableNode tableNode2, boolean bl) {
        if (tableNode.table <= tableNode2.table) {
            this.node1 = tableNode;
            this.node2 = tableNode2;
        } else {
            this.node1 = tableNode2;
            this.node2 = tableNode;
        }
        this.bOrder = bl;
    }

    public TableNode[] getTableNode() {
        return new TableNode[]{this.node1, this.node2};
    }

    public int[] getJoinTable() {
        return new int[]{this.node1.table, this.node2.table};
    }

    public boolean equals(JoinNode joinNode) {
        return this.node1.equals(joinNode.node1) && this.node2.equals(joinNode.node2);
    }

    public boolean isSameTables(TableNode tableNode, TableNode tableNode2) {
        int[] nArray = this.getJoinTable();
        return nArray[0] == tableNode.table && nArray[1] == tableNode2.table || nArray[1] == tableNode.table && nArray[0] == tableNode2.table;
    }

    public void addRelation(TableNode tableNode, TableNode tableNode2) {
        boolean bl = true;
        bl = this.node1.addColumn(tableNode) ? this.node2.addColumn(tableNode2) : (bl = this.node1.addColumn(tableNode2)) && this.node2.addColumn(tableNode);
    }

    public int getRelatedTable(TableNode tableNode) {
        if (this.node1.table != tableNode.table) {
            return this.node1.table;
        }
        if (this.node2.table != tableNode.table) {
            return this.node2.table;
        }
        return -1;
    }

    public boolean isOrderJoin() {
        return this.bOrder;
    }

    public String toString() {
        return this.node1 + "=" + this.node2 + "_" + this.bOrder;
    }
}

