/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.join;

import com.jinfonet.jdbc.ColumnDesc;
import java.sql.SQLException;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.connect.DbRecordModel;
import jet.connect.DbValue;
import jet.connect.Groupable;
import jet.connect.Record;
import jet.log.JRLogger;
import jet.util.IntVector;

public abstract class Result {
    IntVector relatedTable;
    DbRecordModel model;
    DbBuffer buffer;
    ColumnDesc[] columnDescs;
    DbValue[] curRecord;
    String name;
    private int append = -1;
    private int ary = -1;
    int[] dbBufferInfo = null;
    private static JRLogger clear = JRLogger.getLogger(Result.class.getName());

    protected DbRecordModel createModel(ColumnDesc[] columnDescArray) {
        DbRecordModel dbRecordModel;
        int n = columnDescArray.length;
        DbColDesc[] dbColDescArray = new DbColDesc[n];
        for (int i = 0; i < n; ++i) {
            dbColDescArray[i] = columnDescArray[i].createDbColDesc();
        }
        this.model = dbRecordModel = new DbRecordModel(dbColDescArray, (Groupable)null);
        this.buffer = this.dbBufferInfo == null ? new DbBuffer(dbRecordModel) : new DbBuffer(this.dbBufferInfo[0] == 1, dbRecordModel, 0, this.dbBufferInfo[1], this.dbBufferInfo[2]);
        this.buffer.setNeedWaitFetch(false);
        this.curRecord = dbRecordModel.currentRecord.getValueArray();
        return dbRecordModel;
    }

    protected void setDbBufferInfo(int[] nArray) {
        this.dbBufferInfo = nArray;
    }

    protected ColumnDesc[] getColumnDescs() {
        return this.columnDescs;
    }

    protected void reStart() {
        boolean bl = this.buffer.restart();
    }

    protected int getCursor() {
        int n = this.buffer.getReadCursor();
        return n;
    }

    protected DbValue[] getCurRecord() {
        return this.curRecord;
    }

    protected void close() {
        this.buffer.finish();
    }

    protected void clear() {
        this.buffer.clearMem();
        this.model.clear();
        this.curRecord = null;
    }

    protected DbValue getCmpCol() {
        return this.getValue(this.append);
    }

    protected DbValue getCmpCol2() {
        return this.getValue(this.ary);
    }

    protected boolean setCmpColumn(ColumnDesc columnDesc) {
        int n = Result.getCmpColumn(this.columnDescs, columnDesc);
        if (this.append == -1) {
            this.append = n;
            return true;
        }
        this.ary = n;
        return false;
    }

    static int getCmpColumn(ColumnDesc[] columnDescArray, ColumnDesc columnDesc) {
        int n = -1;
        for (int i = 0; i < columnDescArray.length; ++i) {
            if (!columnDescArray[i].getTableName().equalsIgnoreCase(columnDesc.getTableName()) || !columnDescArray[i].getColName().equalsIgnoreCase(columnDesc.getColName())) continue;
            n = i;
            break;
        }
        return n;
    }

    protected boolean next() {
        try {
            Record record = this.model.currentRecord;
            this.buffer.nextRecord(record);
            this.curRecord = record.getValueArray();
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    protected DbValue getValue(int n) {
        return this.curRecord[n];
    }

    protected DbValue[] getRecord(int n) {
        this.setCurrent(n);
        return this.model.currentRecord.getValueArray();
    }

    protected void setCurrent(int n) {
        this.model.currentRecord.setRecordIndex(n);
        this.model.currentRecord.refresh(true);
    }

    protected IntVector getRelatedTable() {
        return this.relatedTable;
    }

    protected int size() {
        return this.buffer.countRecords();
    }

    public String toString() {
        String string = this.name + this.getRelatedTable() + " s:" + this.size() + " c:" + this.append;
        if (this.ary != -1) {
            string = string + " , " + this.ary;
        }
        return string;
    }

    protected String debugStatus() {
        return this.name + " " + this.getCursor() + JRLogger.ary(" CRecord", this.curRecord);
    }

    public boolean equals(Result result) {
        boolean bl = this.name.equals(result);
        if (bl) {
            bl = this.buffer != null && result.buffer != null ? this.buffer.equals(result.buffer) : this.buffer == null && result.buffer == null;
        }
        return bl;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String debugBuffer() {
        if (this.buffer != null) {
            return " Buffer Info  End: " + this.buffer.getCurrentEnd() + " cursor: " + this.buffer.getReadCursor() + " finished: " + this.buffer.finished();
        }
        return " NULL buffer";
    }
}

