/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.join;

import com.jinfonet.jdbc.ColumnDesc;
import com.jinfonet.jdbc.join.Result;
import com.jinfonet.jdbc.model.AbstractAccessingPath;
import com.jinfonet.jdbc.obj.JIterator;
import com.jinfonet.jdbc.util.DataTools;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import jet.connect.DbValue;
import jet.log.JRLogger;
import jet.util.IntVector;

public class TableResult
extends Result {
    private int SEDU;
    private JIterator addElement;
    private int addRecord;
    private int append = 0;
    private int clear;
    private Object o;
    private boolean close = false;
    private boolean createDbColDesc = false;
    private static JRLogger createModel = JRLogger.getLogger(TableResult.class.getName());

    public TableResult(ColumnDesc[] columnDescArray, int n, JIterator jIterator) {
        this.addRecord = n;
        this.addElement = jIterator;
        ColumnDesc columnDesc = columnDescArray[0];
        this.SEDU = columnDesc.getTableIndex();
        this.name = columnDesc.getTableName();
        this.columnDescs = columnDescArray;
        this.clear = columnDescArray.length;
        this.SEDU = this.SEDU;
        this.relatedTable = new IntVector(1);
        this.relatedTable.addElement(this.SEDU);
    }

    protected void initBuffer(boolean bl) {
        this.close = bl;
        if (bl) {
            this.model = this.createModel(this.columnDescs);
            this.createDbColDesc = false;
        } else {
            this.curRecord = new DbValue[this.clear];
            for (int i = 0; i < this.clear; ++i) {
                this.curRecord[i] = DbValue.makeDbValue(this.columnDescs[i].createDbColDesc());
            }
            this.createDbColDesc = true;
        }
    }

    protected void setCmpOptimize(boolean bl) {
        if (!this.close) {
            this.createDbColDesc = bl;
        }
    }

    @Override
    protected void clear() {
        if (this.close) {
            super.clear();
        }
    }

    @Override
    protected boolean next() {
        if (this.addElement != null) {
            if (this.append < this.addRecord) {
                this.o = this.addElement.next();
                ++this.append;
                if (!this.createDbColDesc) {
                    this.SEDU();
                    if (this.close) {
                        this.buffer.addRecord(this.model.currentRecord);
                    }
                }
                return true;
            }
            return false;
        }
        return super.next();
    }

    private void SEDU() {
        for (int i = 0; i < this.clear; ++i) {
            try {
                this.addElement(this.curRecord[i], i);
                continue;
            }
            catch (SQLException sQLException) {
                if (!createModel.isErrorEnabled()) continue;
                createModel.error("", sQLException);
            }
        }
    }

    @Override
    protected DbValue[] getCurRecord() {
        if (this.addElement != null && this.createDbColDesc) {
            this.SEDU();
        }
        return super.getCurRecord();
    }

    @Override
    protected DbValue getValue(int n) {
        DbValue dbValue = this.curRecord[n];
        if (this.addElement != null && this.createDbColDesc) {
            try {
                this.addElement(dbValue, n);
            }
            catch (SQLException sQLException) {
                if (createModel.isErrorEnabled()) {
                    createModel.error("", sQLException);
                }
            }
        } else {
            dbValue = super.getValue(n);
        }
        return dbValue;
    }

    private void addElement(DbValue dbValue, int n) throws SQLException {
        ColumnDesc columnDesc = this.columnDescs[n];
        try {
            AbstractAccessingPath abstractAccessingPath = columnDesc.getAccessingPath();
            Object[] objectArray = abstractAccessingPath.getDefaultValues();
            if (objectArray != null && objectArray[0] == null) {
                objectArray[0] = new Integer(columnDesc.getColumnIndex());
                abstractAccessingPath.setDefaultValues(objectArray);
            }
            Object object = abstractAccessingPath.deepExec(this.o);
            DataTools.setObject(dbValue, object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SQLException(noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException.getMessage());
        }
    }

    protected void setSize(int n) {
        this.addRecord = n;
    }

    @Override
    protected int getCursor() {
        if (this.addElement != null) {
            return this.append;
        }
        return super.getCursor();
    }

    @Override
    protected void close() {
        if (this.buffer != null) {
            this.buffer.finish();
        }
    }

    @Override
    protected void reStart() {
        if (this.addElement != null) {
            this.addElement = null;
            this.close();
            this.append = -1;
        } else {
            super.reStart();
        }
    }

    @Override
    protected int size() {
        return this.addRecord;
    }

    @Override
    public String toString() {
        return super.toString() + (this.close ? " Catched" : "");
    }

    @Override
    protected String debugStatus() {
        return super.debugStatus() + " " + (this.addElement != null ? "iter" : "");
    }

    protected int getTableIndex() {
        return this.SEDU;
    }
}

