/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.model;

import com.jinfonet.jdbc.model.ModelFileReader;
import com.jinfonet.jdbc.model.Table;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import jet.Env;
import jet.JResource;
import jet.ReportEnv;
import jet.xml.XMLTools;
import jet.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModelFileWriter {
    private OutputStream SEDU;
    private ObjectOutputStream append;
    private boolean appendChild = false;
    private Vector close;
    private String createDocument;

    public ModelFileWriter(String string, Vector vector) throws IOException {
        this.appendChild = true;
        this.createDocument = string;
        this.SEDU(new FileOutputStream(string), ModelFileWriter.isXMLFile(string));
        this.close = vector;
    }

    public static boolean isXMLFile(String string) {
        return string != null && string.endsWith(".xml");
    }

    public ModelFileWriter(OutputStream outputStream, Vector vector) throws IOException {
        this.SEDU(outputStream, ModelFileWriter.isXMLFile(this.createDocument));
        this.close = vector;
    }

    private void SEDU(OutputStream outputStream, boolean bl) throws IOException {
        this.SEDU = outputStream;
        if (!bl) {
            this.append = new ObjectOutputStream(outputStream);
        }
    }

    private void append() {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.setOutput(new PrintWriter(this.SEDU));
        Document document = XMLTools.createDocument();
        Element element = document.createElement("Tables");
        document.appendChild(element);
        for (int i = 0; i < this.close.size(); ++i) {
            element.appendChild(((Table)this.close.elementAt(i)).getXMLNode(document));
        }
        xMLWriter.writeNode(document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeTables() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (ModelFileWriter.isXMLFile(this.createDocument)) {
            if (!ReportEnv.getTextFile()) throw new IllegalAccessException(JResource.getMessage("XMLSAVE_RESTRICT"));
            this.append();
            return;
        } else {
            this.appendChild();
        }
    }

    private void appendChild() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.append.writeInt(65537);
        int n = this.close.size();
        this.append.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Table table = (Table)this.close.elementAt(i);
            table.write(this.append);
        }
        this.append.close();
        if (this.appendChild) {
            this.SEDU.close();
        }
    }

    public static String convertFile(String string) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        if (string.endsWith(".xml")) {
            string2 = Env.getXMLFileName(string, 7) + ".odf";
        } else if (string.endsWith(".odf")) {
            string2 = string2 + ".odf.xml";
        } else {
            System.err.println(string + " is invalid fileName!");
        }
        Vector vector = new ModelFileReader(string).readTables();
        if (vector.size() > 0) {
            new ModelFileWriter(string2, vector).writeTables();
            return string2;
        }
        return null;
    }
}

