/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.model;

import com.jinfonet.jdbc.model.AbstractAccessingPath;
import com.jinfonet.jdbc.model.Column;
import com.jinfonet.jdbc.model.DirectAccessingPath;
import com.jinfonet.jdbc.model.IndirectAccessingPath;
import com.jinfonet.jdbc.model.ModelObject;
import com.jinfonet.jdbc.model.RootAccessingPath;
import com.jinfonet.jdbc.model.XMLFormatException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Table
implements ModelObject {
    protected String tableName;
    protected String className;
    protected DirectAccessingPath direct;
    protected Vector indirects;
    protected Vector columns = new Vector();
    public static String tag = "Table";

    @Override
    public void write(ObjectOutput objectOutput) throws IOException {
        ModelObject modelObject;
        int n;
        objectOutput.writeUTF(this.tableName);
        objectOutput.writeUTF(this.className);
        boolean bl = this.direct != null;
        objectOutput.writeBoolean(bl);
        if (bl) {
            this.direct.write(objectOutput);
        }
        int n2 = this.indirects != null ? this.indirects.size() : 0;
        objectOutput.writeInt(n2);
        if (n2 != 0) {
            for (n = 0; n < this.indirects.size(); ++n) {
                modelObject = (AbstractAccessingPath)this.indirects.elementAt(n);
                ((AbstractAccessingPath)modelObject).write(objectOutput);
            }
        }
        n2 = this.columns.size();
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            modelObject = (Column)this.columns.elementAt(n);
            ((Column)modelObject).write(objectOutput);
        }
    }

    @Override
    public void read(ObjectInput objectInput, int n) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ModelObject modelObject;
        int n2;
        int n3;
        this.tableName = objectInput.readUTF();
        this.className = objectInput.readUTF();
        boolean bl = objectInput.readBoolean();
        if (bl) {
            this.direct = new DirectAccessingPath();
            this.direct.read(objectInput, n);
        }
        if ((n3 = objectInput.readInt()) != 0) {
            this.indirects = new Vector(n3);
            for (n2 = 0; n2 < this.indirects.size(); ++n2) {
                modelObject = new IndirectAccessingPath();
                ((IndirectAccessingPath)modelObject).read(objectInput, n);
                this.indirects.addElement(modelObject);
            }
        }
        if ((n3 = objectInput.readInt()) != 0) {
            this.columns = new Vector(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                modelObject = this.newColumnForRead();
                ((Column)modelObject).read(objectInput, n);
                this.addColumn((Column)modelObject);
            }
        }
    }

    protected Column newColumnForRead() {
        return new Column();
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setDirectAccessingPath(DirectAccessingPath directAccessingPath) {
        this.direct = directAccessingPath;
    }

    public DirectAccessingPath getDirectAccessingPath() {
        return this.direct;
    }

    public void addIndirect(IndirectAccessingPath indirectAccessingPath) {
        if (this.indirects == null) {
            this.indirects = new Vector();
        }
        this.indirects.addElement(indirectAccessingPath);
    }

    public Vector getIndirects() {
        return this.indirects;
    }

    public void addColumn(Column column) {
        this.columns.addElement(column);
        column.setParent(this);
    }

    public void removeColumn(Column column) {
        this.columns.removeElement(column);
        column.setParent(null);
    }

    public void removeColumnAt(int n) {
        this.removeColumn((Column)this.columns.elementAt(n));
    }

    public Vector getColumns() {
        return this.columns;
    }

    public Vector getTableParameters() {
        int n;
        Vector vector = new Vector();
        if (this.direct != null) {
            this.direct.getParameterDescs(vector);
        }
        int n2 = n = this.indirects != null ? this.indirects.size() : 0;
        if (n != 0) {
            System.out.println("Unsupported operation");
            for (int i = 0; i < n; ++i) {
            }
        }
        return vector;
    }

    public void setTableParameters(Vector vector) {
        int n;
        vector = (Vector)vector.clone();
        if (this.direct != null) {
            this.direct.setParameters(vector);
        }
        int n2 = n = this.indirects != null ? this.indirects.size() : 0;
        if (n != 0) {
            System.out.println("Unsupported operation");
            for (int i = 0; i < n; ++i) {
            }
        }
    }

    @Override
    public Element getXMLNode(Document document) {
        ModelObject modelObject;
        int n;
        Element element = document.createElement(tag);
        element.setAttribute("TableName", this.tableName);
        element.setAttribute("ClassName", this.className);
        if (this.direct != null) {
            element.appendChild(this.direct.getXMLNode(document));
        }
        if (this.indirects != null) {
            for (n = 0; n < this.indirects.size(); ++n) {
                modelObject = (IndirectAccessingPath)this.indirects.elementAt(n);
                element.appendChild(((IndirectAccessingPath)modelObject).getXMLNode(document));
            }
        }
        for (n = 0; n < this.columns.size(); ++n) {
            modelObject = (Column)this.columns.elementAt(n);
            element.appendChild(((Column)modelObject).getXMLNode(document));
        }
        return element;
    }

    @Override
    public void setXMLNode(Element element) {
        Element element2 = Table.getElement(element, tag);
        if (element2 != null) {
            ModelObject modelObject;
            int n;
            NamedNodeMap namedNodeMap = element.getAttributes();
            this.tableName = Table.getAttribute(namedNodeMap, "TableName");
            this.className = Table.getAttribute(namedNodeMap, "ClassName");
            NodeList nodeList = element.getElementsByTagName("DirectAccessPath");
            if (nodeList.getLength() > 0) {
                this.direct = new DirectAccessingPath();
                this.direct.setXMLNode((Element)nodeList.item(0));
            }
            nodeList = element.getElementsByTagName("IndirectAccessPath");
            this.indirects = new Vector(nodeList.getLength());
            for (n = 0; n < nodeList.getLength(); ++n) {
                modelObject = new IndirectAccessingPath();
                ((IndirectAccessingPath)modelObject).setXMLNode((Element)nodeList.item(n));
                this.indirects.addElement(modelObject);
            }
            nodeList = element.getElementsByTagName("Column");
            this.columns = new Vector(nodeList.getLength());
            for (n = 0; n < nodeList.getLength(); ++n) {
                modelObject = this.newColumnForRead();
                ((Column)modelObject).setXMLNode((Element)nodeList.item(n));
                this.columns.addElement(modelObject);
            }
        }
    }

    static AbstractAccessingPath getPath(Element element) {
        AbstractAccessingPath abstractAccessingPath = null;
        NodeList nodeList = element.getElementsByTagName("AbstractAccessPath");
        if (nodeList.getLength() > 0) {
            abstractAccessingPath = new AbstractAccessingPath();
        } else {
            nodeList = element.getElementsByTagName("RootAccessPath");
            if (nodeList.getLength() > 0) {
                abstractAccessingPath = new RootAccessingPath();
            } else {
                nodeList = element.getElementsByTagName("DirectAccessPath");
                if (nodeList.getLength() > 0) {
                    abstractAccessingPath = new DirectAccessingPath();
                } else {
                    nodeList = element.getElementsByTagName("IndirectAccessPath");
                    if (nodeList.getLength() > 0) {
                        abstractAccessingPath = new IndirectAccessingPath();
                    }
                }
            }
        }
        if (abstractAccessingPath != null) {
            Element element2 = (Element)nodeList.item(0);
            abstractAccessingPath.setXMLNode(element2);
            AbstractAccessingPath abstractAccessingPath2 = Table.getPath(element2);
            if (abstractAccessingPath2 != null) {
                abstractAccessingPath.setNextPath(abstractAccessingPath2);
            }
        }
        return abstractAccessingPath;
    }

    static Element getElement(Element element, String string) {
        if (element.getNodeName().equals(string)) {
            return element;
        }
        throw new XMLFormatException(string + " Element is expected!");
    }

    static String getAttribute(NamedNodeMap namedNodeMap, String string) {
        return Table.getAttribute(namedNodeMap, string, false);
    }

    static String getAttribute(NamedNodeMap namedNodeMap, String string, boolean bl) {
        Node node = namedNodeMap.getNamedItem(string);
        Object var4_4 = null;
        if (node != null) {
            return node.getNodeValue();
        }
        if (!bl) {
            throw new XMLFormatException(string + " Attribute is Expected");
        }
        return null;
    }
}

