/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.txt;

import com.jinfonet.jdbc.txt.RecordResult;
import com.jinfonet.jdbc.txt.StringTokenizer;
import com.jinfonet.jdbc.txt.TableResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import jet.log.JRLogger;

public class TextReader {
    String fileName;
    String dateFormat;
    String delimiter;
    String quote;
    boolean ignoreFirstLine;
    SimpleDateFormat format;
    private static JRLogger SEDU = JRLogger.getLogger(TextReader.class.getName());

    TextReader(String string, String string2, String string3, String string4, boolean bl) {
        this.fileName = string;
        this.dateFormat = string2;
        this.delimiter = string3;
        this.quote = string4;
        this.ignoreFirstLine = bl;
        this.format = new SimpleDateFormat(string2);
    }

    public static TableResult read(String string, String string2, String string3, String string4, boolean bl) throws IOException {
        return new TextReader(string, string2, string3, string4, bl).SEDU();
    }

    private TableResult SEDU() throws IOException {
        String string;
        if (SEDU.isDebugEnabled()) {
            SEDU.debug("ReadText\n" + new File(this.fileName).getCanonicalPath());
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileName));
        Vector<RecordResult> vector = new Vector<RecordResult>();
        TableResult tableResult = new TableResult(vector, this.format);
        if (this.ignoreFirstLine) {
            bufferedReader.readLine();
        }
        while ((string = bufferedReader.readLine()) != null) {
            if (string.trim().length() == 0) continue;
            Object[] objectArray = this.parseLine(string);
            vector.addElement(new RecordResult(objectArray, tableResult));
        }
        bufferedReader.close();
        return tableResult;
    }

    Object[] parseLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.delimiter, true);
        Vector<String> vector = new Vector<String>();
        String string2 = "";
        String string3 = null;
        String string4 = "";
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (string2.equals(this.delimiter)) {
                if (string4.equals(this.delimiter)) {
                    string3 = null;
                    vector.add(string3);
                }
                if (!stringTokenizer.hasMoreTokens()) {
                    vector.add(null);
                }
            } else {
                string3 = string2;
                if (string3.startsWith(this.quote)) {
                    while (!string3.endsWith(this.quote)) {
                        string3 = string3 + stringTokenizer.nextToken();
                    }
                    string3 = string3.substring(this.quote.length(), string3.length() - this.quote.length());
                }
                vector.add(string3);
            }
            string4 = string2;
            ++n;
        }
        return vector.toArray();
    }
}

