/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.util;

import com.jinfonet.jdbc.util.DataType;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbNumber;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;

public class DataTools
implements DataType {
    public static final Object convertToObject(DbValue dbValue) {
        throw new RuntimeException("Not Support!");
    }

    public static final Object convertToObject(DbValue dbValue, int n) {
        throw new RuntimeException("Not Support!");
    }

    public static final void setObject(DbValue dbValue, Object object) {
        if (object == null) {
            dbValue.setNull();
        } else {
            switch (dbValue.getSqlType()) {
                case -1: 
                case 1: 
                case 12: {
                    ((DbChar)dbValue).set(object.toString());
                    break;
                }
                case 2: 
                case 3: {
                    ((DbDecimal)dbValue).set((BigDecimal)object);
                    break;
                }
                case -7: {
                    ((DbBit)dbValue).set((Boolean)object);
                    break;
                }
                case -6: {
                    ((DbTinyInt)dbValue).set((Byte)object);
                    break;
                }
                case 5: {
                    ((DbSmallInt)dbValue).set((Short)object);
                    break;
                }
                case 4: {
                    ((DbInteger)dbValue).set((Integer)object);
                    break;
                }
                case -5: {
                    ((DbBigInt)dbValue).set((Long)object);
                    break;
                }
                case 6: 
                case 7: {
                    if (dbValue instanceof DbReal) {
                        ((DbReal)dbValue).set(((Float)object).floatValue());
                        break;
                    }
                    if (!(dbValue instanceof DbDouble)) break;
                    ((DbDouble)dbValue).set(((Float)object).floatValue());
                    break;
                }
                case 8: {
                    ((DbDouble)dbValue).set((Double)object);
                    break;
                }
                case -4: {
                    ((DbBinary)dbValue).set((byte[])object);
                    break;
                }
                case 91: {
                    ((DbDate)dbValue).setDate((Date)object);
                    break;
                }
                case 92: {
                    ((DbTime)dbValue).setTime((Time)object);
                    break;
                }
                case 93: {
                    ((DbTimestamp)dbValue).set((Timestamp)object);
                }
            }
        }
    }

    public static final Object getParamValue(Class clazz, String string) throws InstantiationException, IllegalAccessException {
        Object object = null;
        if (clazz == Integer.TYPE) {
            object = new Integer(string);
        } else if (clazz == Short.TYPE) {
            object = new Short(string);
        } else if (clazz == Float.TYPE) {
            object = new Float(string);
        } else if (clazz == Long.TYPE) {
            object = new Long(string);
        } else if (clazz == Byte.TYPE) {
            object = new Byte(string);
        } else if (clazz == Boolean.TYPE) {
            object = new Boolean(string);
        } else if (clazz == Double.TYPE) {
            object = new Double(string);
        } else if (clazz == String.class) {
            object = string;
        } else {
            try {
                Class[] classArray = new Class[]{String.class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new String[]{string};
                object = constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                object = clazz.newInstance();
            }
        }
        return object;
    }

    public static final Object getParamValue(Class clazz, DbValue dbValue) throws InstantiationException, IllegalAccessException {
        Object object = null;
        if (clazz == Integer.TYPE) {
            object = new Integer(((DbNumber)dbValue).intValue());
        } else if (clazz == Short.TYPE) {
            object = new Short(((DbNumber)dbValue).shortValue());
        } else if (clazz == Float.TYPE) {
            object = new Float(((DbNumber)dbValue).floatValue());
        } else if (clazz == Long.TYPE) {
            object = new Long(((DbNumber)dbValue).longValue());
        } else if (clazz == Byte.TYPE) {
            object = new Byte(((DbNumber)dbValue).byteValue());
        } else if (clazz == Boolean.TYPE) {
            object = new Boolean(((DbBit)dbValue).get());
        } else if (clazz == Double.TYPE) {
            object = new Double(((DbNumber)dbValue).doubleValue());
        } else if (clazz == String.class) {
            object = ((DbChar)dbValue).get();
        } else if (clazz == java.util.Date.class) {
            object = ((DbDateTime)dbValue).toUtilDate();
        } else if (clazz == Date.class) {
            object = ((DbDateTime)dbValue).toSqlDate();
        } else {
            try {
                Class[] classArray = new Class[]{String.class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new String[]{dbValue.toString()};
                object = constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                object = clazz.newInstance();
            }
        }
        return object;
    }
}

