/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.util;

import com.jinfonet.jdbc.util.DupIntHashNode;
import com.jinfonet.jdbc.util.IntCircle;
import java.util.Vector;
import jet.util.IntVector;

public class DupIntHashtable {
    private transient DupIntHashNode[] SEDU;
    private transient int addElement;
    private int append;
    private float clone;

    public DupIntHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.clone = f;
        this.SEDU = new DupIntHashNode[n];
        this.append = (int)((float)n * f);
    }

    public DupIntHashtable(int n) {
        this(n, 0.618f);
    }

    public DupIntHashtable() {
        this(103, 0.618f);
    }

    public int size() {
        return this.addElement;
    }

    public boolean isEmpty() {
        return this.addElement == 0;
    }

    public synchronized boolean contains(int n) {
        for (int i = 0; i < this.SEDU.length; ++i) {
            DupIntHashNode dupIntHashNode = this.SEDU[i];
            while (dupIntHashNode != null) {
                if (dupIntHashNode.value.contains(n)) {
                    return true;
                }
                dupIntHashNode = dupIntHashNode.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        DupIntHashNode dupIntHashNode = this.SEDU[n2];
        while (dupIntHashNode != null) {
            if (dupIntHashNode.key == n) {
                return true;
            }
            dupIntHashNode = dupIntHashNode.next;
        }
        return false;
    }

    public synchronized int get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        DupIntHashNode dupIntHashNode = this.SEDU[n2];
        while (dupIntHashNode != null) {
            if (dupIntHashNode.key == n) {
                return dupIntHashNode.value.next();
            }
            dupIntHashNode = dupIntHashNode.next;
        }
        return -1;
    }

    public synchronized int getFirst(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        DupIntHashNode dupIntHashNode = this.SEDU[n2];
        while (dupIntHashNode != null) {
            if (dupIntHashNode.key == n) {
                return dupIntHashNode.value.first();
            }
            dupIntHashNode = dupIntHashNode.next;
        }
        return -1;
    }

    public synchronized IntCircle getAll(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        DupIntHashNode dupIntHashNode = this.SEDU[n2];
        while (dupIntHashNode != null) {
            if (dupIntHashNode.key == n) {
                return dupIntHashNode.value;
            }
            dupIntHashNode = dupIntHashNode.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.SEDU.length;
        DupIntHashNode[] dupIntHashNodeArray = this.SEDU;
        int n2 = n * 2 + 1;
        DupIntHashNode[] dupIntHashNodeArray2 = new DupIntHashNode[n2];
        this.append = (int)((float)n2 * this.clone);
        this.SEDU = dupIntHashNodeArray2;
        for (int i = 0; i < n; ++i) {
            DupIntHashNode dupIntHashNode = dupIntHashNodeArray[i];
            while (dupIntHashNode != null) {
                DupIntHashNode dupIntHashNode2 = dupIntHashNode;
                dupIntHashNode = dupIntHashNode.next;
                int n3 = (dupIntHashNode2.key & Integer.MAX_VALUE) % n2;
                dupIntHashNode2.next = dupIntHashNodeArray2[n3];
                dupIntHashNodeArray2[n3] = dupIntHashNode2;
            }
        }
    }

    public synchronized IntCircle put(int n, int n2) {
        int n3 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        DupIntHashNode dupIntHashNode = this.SEDU[n3];
        while (dupIntHashNode != null) {
            if (dupIntHashNode.key == n) {
                IntCircle intCircle = dupIntHashNode.value;
                if (!intCircle.contains(n2)) {
                    intCircle.addElement(n2);
                }
                return intCircle;
            }
            dupIntHashNode = dupIntHashNode.next;
        }
        if (this.addElement >= this.append) {
            this.rehash();
            return this.put(n, n2);
        }
        dupIntHashNode = new DupIntHashNode();
        dupIntHashNode.key = n;
        IntCircle intCircle = new IntCircle();
        intCircle.addElement(n2);
        dupIntHashNode.value = intCircle;
        dupIntHashNode.next = this.SEDU[n3];
        this.SEDU[n3] = dupIntHashNode;
        ++this.addElement;
        return null;
    }

    public synchronized IntCircle remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        DupIntHashNode dupIntHashNode = this.SEDU[n2];
        DupIntHashNode dupIntHashNode2 = null;
        while (dupIntHashNode != null) {
            if (dupIntHashNode.key == n) {
                if (dupIntHashNode2 != null) {
                    dupIntHashNode2.next = dupIntHashNode.next;
                } else {
                    this.SEDU[n2] = dupIntHashNode.next;
                }
                --this.addElement;
                return dupIntHashNode.value;
            }
            dupIntHashNode2 = dupIntHashNode;
            dupIntHashNode = dupIntHashNode.next;
        }
        return null;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.SEDU.length; ++i) {
            this.SEDU[i] = null;
        }
        this.addElement = 0;
    }

    public synchronized Object clone() {
        DupIntHashtable dupIntHashtable = new DupIntHashtable(this.SEDU.length, this.clone);
        for (int i = 0; i < this.SEDU.length; ++i) {
            dupIntHashtable.SEDU[i] = this.SEDU[i] != null ? (DupIntHashNode)this.SEDU[i].clone() : null;
        }
        return dupIntHashtable;
    }

    public synchronized IntVector keys() {
        IntVector intVector = null;
        if (this.addElement != 0) {
            intVector = new IntVector();
            for (int i = 0; i < this.SEDU.length; ++i) {
                DupIntHashNode dupIntHashNode = this.SEDU[i];
                if (dupIntHashNode == null) continue;
                do {
                    intVector.addElement(dupIntHashNode.key);
                } while ((dupIntHashNode = dupIntHashNode.next) != null);
            }
        }
        return intVector;
    }

    public synchronized Vector elements() {
        Vector<IntCircle> vector = null;
        if (this.addElement != 0) {
            vector = new Vector<IntCircle>();
            for (int i = 0; i < this.SEDU.length; ++i) {
                DupIntHashNode dupIntHashNode = this.SEDU[i];
                if (dupIntHashNode == null) continue;
                do {
                    vector.addElement(dupIntHashNode.value);
                } while ((dupIntHashNode = dupIntHashNode.next) != null);
            }
        }
        return vector;
    }

    public synchronized IntCircle getKeys(int n) {
        int n2;
        IntCircle intCircle = new IntCircle();
        for (n2 = 0; n2 < this.SEDU.length; ++n2) {
            DupIntHashNode dupIntHashNode = this.SEDU[n2];
            while (dupIntHashNode != null) {
                if (dupIntHashNode.value.contains(n)) {
                    intCircle.addElement(dupIntHashNode.key);
                }
                dupIntHashNode = dupIntHashNode.next;
            }
        }
        n2 = intCircle.size();
        if (n2 > 0) {
            return intCircle;
        }
        return null;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.addElement != 0) {
            stringBuffer.append("[");
            for (int i = 0; i < this.SEDU.length; ++i) {
                DupIntHashNode dupIntHashNode = this.SEDU[i];
                if (dupIntHashNode == null) continue;
                do {
                    stringBuffer.append("[").append(dupIntHashNode.key).append(",").append(dupIntHashNode.value).append("],");
                } while ((dupIntHashNode = dupIntHashNode.next) != null);
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void reStartValue() {
        for (int i = 0; i < this.SEDU.length; ++i) {
            DupIntHashNode dupIntHashNode = this.SEDU[i];
            while (dupIntHashNode != null) {
                dupIntHashNode.value.reStart();
                dupIntHashNode = dupIntHashNode.next;
            }
        }
    }
}

