/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.util;

import com.jinfonet.jdbc.util.IntCircle;
import com.jinfonet.jdbc.util.IntHashNode;
import jet.util.IntVector;

public class IntHashtable {
    private transient IntHashNode[] SEDU;
    private transient int addElement;
    private int append;
    private float clone;

    public IntHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.clone = f;
        this.SEDU = new IntHashNode[n];
        this.append = (int)((float)n * f);
    }

    public IntHashtable(int n) {
        this(n, 0.618f);
    }

    public IntHashtable() {
        this(103, 0.618f);
    }

    public int size() {
        return this.addElement;
    }

    public boolean isEmpty() {
        return this.addElement == 0;
    }

    public synchronized int getKey(int n) {
        for (int i = 0; i < this.SEDU.length; ++i) {
            IntHashNode intHashNode = this.SEDU[i];
            while (intHashNode != null) {
                if (intHashNode.value == n) {
                    return intHashNode.key;
                }
                intHashNode = intHashNode.next;
            }
        }
        return -1;
    }

    public synchronized IntCircle getKeys(int n) {
        IntCircle intCircle = new IntCircle(2);
        block0: for (int i = 0; i < this.SEDU.length; ++i) {
            IntHashNode intHashNode = this.SEDU[i];
            while (intHashNode != null) {
                if (intHashNode.value == n) {
                    intCircle.addElement(intHashNode.key);
                    continue block0;
                }
                intHashNode = intHashNode.next;
            }
        }
        if (intCircle.size() > 0) {
            return intCircle;
        }
        return null;
    }

    public synchronized boolean contains(int n) {
        for (int i = 0; i < this.SEDU.length; ++i) {
            IntHashNode intHashNode = this.SEDU[i];
            while (intHashNode != null) {
                if (intHashNode.value == n) {
                    return true;
                }
                intHashNode = intHashNode.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        IntHashNode intHashNode = this.SEDU[n2];
        while (intHashNode != null) {
            if (intHashNode.key == n) {
                return true;
            }
            intHashNode = intHashNode.next;
        }
        return false;
    }

    public synchronized int get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        IntHashNode intHashNode = this.SEDU[n2];
        while (intHashNode != null) {
            if (intHashNode.key == n) {
                return intHashNode.value;
            }
            intHashNode = intHashNode.next;
        }
        return -1;
    }

    protected void rehash() {
        int n = this.SEDU.length;
        IntHashNode[] intHashNodeArray = this.SEDU;
        int n2 = n * 2 + 1;
        IntHashNode[] intHashNodeArray2 = new IntHashNode[n2];
        this.append = (int)((float)n2 * this.clone);
        this.SEDU = intHashNodeArray2;
        for (int i = 0; i < n; ++i) {
            IntHashNode intHashNode = intHashNodeArray[i];
            while (intHashNode != null) {
                IntHashNode intHashNode2 = intHashNode;
                intHashNode = intHashNode.next;
                int n3 = (intHashNode2.key & Integer.MAX_VALUE) % n2;
                intHashNode2.next = intHashNodeArray2[n3];
                intHashNodeArray2[n3] = intHashNode2;
            }
        }
    }

    public synchronized int put(int n, int n2) {
        int n3 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        IntHashNode intHashNode = this.SEDU[n3];
        while (intHashNode != null) {
            if (intHashNode.key == n) {
                int n4 = intHashNode.value;
                intHashNode.value = n2;
                return n4;
            }
            intHashNode = intHashNode.next;
        }
        if (this.addElement >= this.append) {
            this.rehash();
            return this.put(n, n2);
        }
        intHashNode = new IntHashNode();
        intHashNode.key = n;
        intHashNode.value = n2;
        intHashNode.next = this.SEDU[n3];
        this.SEDU[n3] = intHashNode;
        ++this.addElement;
        return -1;
    }

    public synchronized int remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.SEDU.length;
        IntHashNode intHashNode = this.SEDU[n2];
        IntHashNode intHashNode2 = null;
        while (intHashNode != null) {
            if (intHashNode.key == n) {
                if (intHashNode2 != null) {
                    intHashNode2.next = intHashNode.next;
                } else {
                    this.SEDU[n2] = intHashNode.next;
                }
                --this.addElement;
                return intHashNode.value;
            }
            intHashNode2 = intHashNode;
            intHashNode = intHashNode.next;
        }
        return -1;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.SEDU.length; ++i) {
            this.SEDU[i] = null;
        }
        this.addElement = 0;
    }

    public synchronized Object clone() {
        IntHashtable intHashtable = new IntHashtable(this.SEDU.length, this.clone);
        for (int i = 0; i < this.SEDU.length; ++i) {
            intHashtable.SEDU[i] = this.SEDU[i] != null ? (IntHashNode)this.SEDU[i].clone() : null;
        }
        return intHashtable;
    }

    public synchronized IntVector keys() {
        IntVector intVector = null;
        if (this.addElement != 0) {
            intVector = new IntVector();
            for (int i = 0; i < this.SEDU.length; ++i) {
                IntHashNode intHashNode = this.SEDU[i];
                if (intHashNode == null) continue;
                do {
                    intVector.addElement(intHashNode.key);
                } while ((intHashNode = intHashNode.next) != null);
            }
        }
        return intVector;
    }

    public synchronized IntVector elements() {
        IntVector intVector = null;
        if (this.addElement != 0) {
            intVector = new IntVector();
            for (int i = 0; i < this.SEDU.length; ++i) {
                IntHashNode intHashNode = this.SEDU[i];
                if (intHashNode == null) continue;
                do {
                    intVector.addElement(intHashNode.value);
                } while ((intHashNode = intHashNode.next) != null);
            }
        }
        return intVector;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.addElement != 0) {
            stringBuffer.append("[");
            for (int i = 0; i < this.SEDU.length; ++i) {
                IntHashNode intHashNode = this.SEDU[i];
                if (intHashNode == null) continue;
                do {
                    stringBuffer.append("[").append(intHashNode.key).append(",").append(intHashNode.value).append("],");
                } while ((intHashNode = intHashNode.next) != null);
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

