/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class TypeTools {
    private static final int SEDU = 255;
    private static final int TYPE = 10;

    public static final int mapClassToSQLType(Class clazz) {
        String string = TypeTools.getParamType(clazz);
        int n = 0;
        n = string.equals("java.lang.String") ? 12 : (string.equals("java.math.BigDecimal") ? 2 : (string.equals("java.lang.Boolean") ? -7 : (string.equals("java.lang.Short") ? 5 : (string.equals("java.lang.Integer") ? 4 : (string.equals("java.lang.Long") ? -5 : (string.equals("java.lang.Float") ? 7 : (string.equals("java.lang.Double") ? 8 : (string.equals("java.lang.Byte") ? -6 : (string.equals("boolean") ? -7 : (string.equals("byte") ? -6 : (string.equals("short") ? 5 : (string.equals("int") ? 4 : (string.equals("long") ? -5 : (string.equals("float") ? 7 : (string.equals("double") ? 8 : (string.equals("byte[]") ? -4 : (string.equals("java.sql.Date") ? 91 : (string.equals("java.sql.Time") ? 92 : (string.equals("java.sql.Timestamp") ? 93 : 1111)))))))))))))))))));
        return n;
    }

    public static final String getParamType(Class clazz) {
        String string = clazz.getName();
        int n = 0;
        while (clazz != null && clazz.isArray()) {
            clazz = clazz.getComponentType();
            string = clazz.getName();
            ++n;
        }
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                string = string + "[]";
            }
        }
        return string;
    }

    public static final Class mapTypeToClass(int n) throws SQLException {
        Class<Object> clazz = Object.class;
        switch (n) {
            case 2: 
            case 3: {
                clazz = BigDecimal.class;
                break;
            }
            case -7: {
                clazz = Boolean.TYPE;
                break;
            }
            case -6: {
                clazz = Byte.TYPE;
                break;
            }
            case 5: {
                clazz = Short.TYPE;
                break;
            }
            case 4: {
                clazz = Integer.TYPE;
                break;
            }
            case -5: {
                clazz = Long.TYPE;
                break;
            }
            case 6: 
            case 7: {
                clazz = Float.TYPE;
                break;
            }
            case 8: {
                clazz = Double.TYPE;
                break;
            }
            case -4: 
            case 1: 
            case 12: {
                clazz = String.class;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 92: {
                clazz = Time.class;
                break;
            }
            case 93: {
                clazz = Timestamp.class;
            }
        }
        return clazz;
    }

    public static final String mapTypeToString(int n) {
        String string = "Unknow";
        switch (n) {
            case 1: 
            case 12: {
                string = "String";
                break;
            }
            case 2: 
            case 3: {
                string = "Decimal";
                break;
            }
            case -7: {
                string = "Boolean";
                break;
            }
            case -6: {
                string = "Byte";
                break;
            }
            case 5: {
                string = "Short";
                break;
            }
            case 4: {
                string = "Integer";
                break;
            }
            case -5: {
                string = "Long";
                break;
            }
            case 6: 
            case 7: {
                string = "Float";
                break;
            }
            case 8: {
                string = "Double";
                break;
            }
            case -4: {
                string = "LongVarChar";
                break;
            }
            case 91: {
                string = "Date";
                break;
            }
            case 92: {
                string = "Time";
                break;
            }
            case 93: {
                string = "Timestamp";
            }
        }
        return string;
    }

    public static final int mapTypeToInt(String string) {
        int n = string.equalsIgnoreCase("String") ? 12 : (string.equalsIgnoreCase("Decimal") ? 3 : (string.equalsIgnoreCase("Boolean") ? -7 : (string.equalsIgnoreCase("Byte") ? -6 : (string.equalsIgnoreCase("Short") ? 5 : (string.equalsIgnoreCase("Integer") ? 4 : (string.equalsIgnoreCase("Long") ? -5 : (string.equalsIgnoreCase("Float") ? 6 : (string.equalsIgnoreCase("Double") ? 8 : (string.equalsIgnoreCase("LongVarChar") ? -4 : (string.equalsIgnoreCase("Date") ? 91 : (string.equalsIgnoreCase("Time") ? 92 : (string.equalsIgnoreCase("Timestamp") ? 93 : 12))))))))))));
        return n;
    }

    public static final int defaultPrecision(int n) {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 12: {
                n2 = 255;
                break;
            }
            case 2: 
            case 3: {
                n2 = 10;
                break;
            }
            case -7: {
                break;
            }
            case -6: {
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            case -5: {
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case -4: {
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                break;
            }
        }
        return n2;
    }

    public static final int defaultScale(int n) {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                n2 = 5;
                break;
            }
            case -7: {
                break;
            }
            case -6: {
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            case -5: {
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case -4: {
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                break;
            }
        }
        return n2;
    }

    public static final Class getClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        int n = string.indexOf("[");
        if (n == -1) {
            clazz = TypeTools.SEDU(string);
        } else {
            String string2 = string.substring(0, n);
            int n2 = 1;
            String string3 = string.substring(n + 1);
            while ((n = string3.indexOf("[")) != -1) {
                ++n2;
                string3 = string3.substring(n + 1);
            }
            clazz = Array.newInstance(TypeTools.SEDU(string2), n2).getClass();
        }
        return clazz;
    }

    private static final Class SEDU(String string) throws ClassNotFoundException {
        Class<Comparable<Integer>> clazz = null;
        clazz = string.equals("int") ? Integer.TYPE : (string.equals("short") ? Short.TYPE : (string.equals("float") ? Float.TYPE : (string.equals("long") ? Long.TYPE : (string.equals("byte") ? Byte.TYPE : (string.equals("boolean") ? Boolean.TYPE : (string.equals("double") ? Double.TYPE : Class.forName(string)))))));
        return clazz;
    }
}

