/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.xml;

import com.jinfonet.jdbc.xml.Rule;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import jet.log.JRLogger;

class Column
extends Rule {
    int type;
    int iTotalRow = 0;
    Format format;
    String path = "";
    Object dataBuffer = null;
    private static JRLogger SEDU = JRLogger.getLogger(Column.class.getName());

    Column(String string, String string2) {
        this.element = string;
        this.type = Integer.parseInt(string2);
    }

    String getName() {
        return this.element;
    }

    String getPath() {
        return this.path;
    }

    void setPath(String string) {
        this.path = string;
    }

    void setFormat(String string) {
        if (this.type == 91 || this.type == 92 || this.type == 93) {
            this.format = new SimpleDateFormat(string);
        } else if (this.type == 5 || this.type == 4 || this.type == -5 || this.type == 6 || this.type == 7 || this.type == 8 || this.type == 2 || this.type == 3) {
            this.format = new DecimalFormat(string);
        }
    }

    Object setValue(Vector vector) {
        this.iTotalRow = vector.size();
        if (this.iTotalRow > 0) {
            this.dataBuffer = this.SEDU(this.iTotalRow);
            for (int i = 0; i < this.iTotalRow; ++i) {
                try {
                    this.append((String)vector.elementAt(i), i);
                    continue;
                }
                catch (ParseException parseException) {
                    if (!SEDU.isErrorEnabled()) continue;
                    SEDU.error("XML Data Parse Error to Column " + this.element, parseException);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!SEDU.isErrorEnabled()) continue;
                    SEDU.error("XML Data Parse Error to Column " + this.element, numberFormatException);
                }
            }
        }
        return this.dataBuffer;
    }

    private Object SEDU(int n) {
        switch (this.type) {
            case -7: {
                return new boolean[n];
            }
            case -6: {
                return new byte[n];
            }
            case 5: {
                return new short[n];
            }
            case 4: {
                return new int[n];
            }
            case -5: {
                return new long[n];
            }
            case 6: 
            case 7: {
                return new float[n];
            }
            case 8: {
                return new double[n];
            }
            case 2: 
            case 3: {
                return new BigDecimal[n];
            }
            case 91: {
                return new java.sql.Date[n];
            }
            case 92: {
                return new Time[n];
            }
            case 93: {
                return new Timestamp[n];
            }
            case -1: 
            case 1: 
            case 12: {
                return new String[n];
            }
        }
        return null;
    }

    private void append(String string, int n) throws ParseException, NumberFormatException {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        switch (this.type) {
            case -7: {
                ((boolean[])this.dataBuffer)[n] = new Boolean(string);
                break;
            }
            case -6: {
                ((byte[])this.dataBuffer)[n] = Byte.parseByte(string);
                break;
            }
            case 5: {
                ((short[])this.dataBuffer)[n] = this.format == null ? Short.parseShort(string) : ((Number)this.format.parseObject(string)).shortValue();
                break;
            }
            case 4: {
                ((int[])this.dataBuffer)[n] = this.format == null ? Integer.parseInt(string) : ((Number)this.format.parseObject(string)).intValue();
                break;
            }
            case -5: {
                ((long[])this.dataBuffer)[n] = this.format == null ? Long.parseLong(string) : ((Number)this.format.parseObject(string)).longValue();
                break;
            }
            case 6: 
            case 7: {
                ((float[])this.dataBuffer)[n] = (this.format == null ? (Number)Float.valueOf(string) : (Number)((Number)this.format.parseObject(string))).floatValue();
                break;
            }
            case 8: {
                ((double[])this.dataBuffer)[n] = (this.format == null ? (Number)Double.valueOf(string) : (Number)((Number)this.format.parseObject(string))).doubleValue();
                break;
            }
            case 2: 
            case 3: {
                ((BigDecimal[])this.dataBuffer)[n] = this.format == null ? new BigDecimal(string) : new BigDecimal(((Number)this.format.parseObject(string)).doubleValue());
                break;
            }
            case 91: {
                Date date = this.format == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.format).parse(string);
                ((java.sql.Date[])this.dataBuffer)[n] = new java.sql.Date(date.getTime());
                break;
            }
            case 92: {
                Date date = this.format == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.format).parse(string);
                ((Time[])this.dataBuffer)[n] = new Time(date.getTime());
                break;
            }
            case 93: {
                Date date = this.format == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.format).parse(string);
                ((Timestamp[])this.dataBuffer)[n] = new Timestamp(date.getTime());
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                ((String[])this.dataBuffer)[n] = string;
            }
        }
    }

    public String toString() {
        String string = this.element + ", " + this.path + " [ ";
        block14: for (int i = 0; i < this.iTotalRow; ++i) {
            switch (this.type) {
                case -7: {
                    string = string + ((boolean[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case -6: {
                    string = string + ((byte[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case 5: {
                    string = string + ((short[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case 4: {
                    string = string + ((int[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case -5: {
                    string = string + ((long[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case 6: 
                case 7: {
                    string = string + ((float[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case 8: {
                    string = string + ((double[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case 2: 
                case 3: {
                    string = string + ((BigDecimal[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case 91: {
                    string = string + ((java.sql.Date[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case 92: {
                    string = string + ((Time[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case 93: {
                    string = string + ((Timestamp[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                case -1: 
                case 1: 
                case 12: {
                    string = string + ((String[])this.dataBuffer)[i] + "; ";
                    continue block14;
                }
                default: {
                    string = string + ";";
                }
            }
        }
        string = string + " ]";
        return string;
    }
}

