/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.jdbc.xml;

import com.jinfonet.jdbc.SQLCollection;
import com.jinfonet.jdbc.obj.JCollection;
import com.jinfonet.jdbc.xml.Column;
import com.jinfonet.jdbc.xml.Record;
import com.jinfonet.jdbc.xml.XMLTree;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.log.JRLogger;

public class XMLReader {
    public static final String RECORD = "record";
    public static final String COLUMN = "column";
    public static final String FORMAT = "format";
    public static final String ROOT = "root";
    public static final String PATH = "path";
    private static final int SEDU = 0;
    private static final int add = 1;
    private static final int addElement = 2;
    private static final int append = 3;
    private static final int debug = 4;
    private static final int endsWith = 5;
    private static final int equals = 6;
    private static final int getColumn = 7;
    private static final int getColumnSize = 8;
    private static final int getLogger = 9;
    String uri;
    Record recRule;
    int iRows = 0;
    private static boolean getName = false;
    private static JRLogger getPath = JRLogger.getLogger(XMLReader.class.getName());

    public static JCollection readXML(String string, String string2) {
        if (getPath.isDebugEnabled()) {
            getPath.debug("Ruler of xml \n " + string2);
            getPath.debug("URI of xml \n " + string);
            if (getName) {
                getPath.debug("Convert Xml \n Old version of the xml ruler");
            }
        }
        XMLReader xMLReader = new XMLReader(string, string2);
        if (getPath.isDebugEnabled()) {
            getPath.debug(xMLReader.recRule.toString());
        }
        Object[] objectArray = xMLReader.getResultSet();
        return new SQLCollection(xMLReader.iRows, objectArray);
    }

    public XMLReader(String string, String string2) {
        this.uri = string;
        this.recRule = this.getRecordRule(string2);
    }

    Record getRecordRule(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        Record record = string2.equals(RECORD) ? new Record(stringTokenizer.nextToken()) : null;
        Column column = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("\"") && !string3.endsWith("\"")) {
                String string4;
                do {
                    string4 = stringTokenizer.nextToken();
                    string3 = string3 + " " + string4;
                } while (string4.length() > 0 && !string4.endsWith("\""));
                string3 = string3.trim();
                string3 = string3.substring(1, string3.length() - 1);
            }
            if (string2.equals(COLUMN)) {
                String string5 = stringTokenizer.nextToken();
                if (getName) {
                    string5 = this.add(string5);
                }
                column = new Column(string3, string5);
                record.add(column);
                continue;
            }
            if (string2.equals(FORMAT)) {
                column.setFormat(string3);
                continue;
            }
            if (string2.equals(PATH)) {
                column.setPath(string3);
                continue;
            }
            if (!string2.equals(ROOT)) continue;
            record.setRoot(string3);
        }
        return record;
    }

    Object[] getResultSet() {
        int n = this.recRule.getColumnSize();
        Object[] objectArray = new Object[n];
        XMLTree xMLTree = new XMLTree(this.uri);
        Vector vector = this.SEDU();
        Vector[] vectorArray = xMLTree.getXMLValue(this.recRule.getRoot(), this.SEDU());
        if (vectorArray == null) {
            objectArray = null;
        } else {
            for (int i = 0; i < n; ++i) {
                Column column = this.recRule.getColumn(i);
                Vector vector2 = vectorArray[i];
                objectArray[i] = column.setValue(vector2);
                if (vector2.size() <= this.iRows) continue;
                this.iRows = vector2.size();
            }
        }
        return objectArray;
    }

    private Vector SEDU() {
        int n = this.recRule.getColumnSize();
        Vector<String> vector = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            Column column = this.recRule.getColumn(i);
            String string = column.getPath();
            if (string.length() < 1) {
                string = column.getName();
            }
            vector.addElement(string);
        }
        return vector;
    }

    private String add(String string) {
        int n = Integer.parseInt(string);
        switch (n) {
            case 0: {
                n = -7;
                break;
            }
            case 1: {
                n = -6;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = -5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 8;
                break;
            }
            case 7: {
                n = 3;
                break;
            }
            case 8: {
                n = 93;
                break;
            }
            case 9: {
                n = 1;
            }
        }
        return n + "";
    }

    public static void setVersion(int n) {
        getName = n == 65536;
    }
}

