/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.reg;

import com.jinfonet.reg.RegisterException;
import com.jinfonet.reg.util.QueryString;
import com.jinfonet.reg.util.RegAlgorithm;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jet.ReportEnv;
import jet.util.Base64;
import jet.util.KeyChecker;
import jet.util.rpRW;

public final class RegisterAPI {
    private static final String BuildNumber = "mscpxw32dr.dll";
    private static final String FILE_PATH = "liblnm1.0.1.dev1.4.2.os";
    private static final String SEDU = "/usr/lib";
    private static final String[] addQuery = new String[]{"JReport Designer", "JReport Enterprise Server", "JReport Designer Bean", "JReport Designer Bean for Novell", "JReport Runtime", "JReport Server Engine", "JReport Designer API", "JReport Server Designer API", "JReport Team Designer"};
    private static final int[] append = new int[]{16, 96, 80, 0, 64, 97, 17, 98, 101};
    private static int buildLicense = 60;
    private static String check;
    private static String checkISV;
    private static String close;
    private String currentTimeMillis;
    private String decode;
    private String delete;
    private String dot3;
    private String encode;
    private String endsWith;
    private String equalsIgnoreCase;
    private String exists;
    private int get = -1;
    private int getAllByName = -1;
    private String getExtNum;
    private String getHostName = null;
    private long getISV = -1L;
    private long getInputStream = -1L;
    private static final String getLocalHost = "http";
    private static final String getMacNum = "www.jinfonet.com";
    private static final String getPaJrKey = "8080";
    private static final String getPrdID = "servlets/jregister";
    private static final String getProperties = "support@jinfonet.com";
    private static final int getProperty = 1;
    private static PrintStream getRegCode;
    private static final String hasMoreElements = "JRProd";

    public RegisterAPI() {
        this.BuildNumber();
    }

    public void setCompany(String string) {
        this.currentTimeMillis = string;
    }

    public String getCompany() {
        return this.currentTimeMillis;
    }

    public void setFirstName(String string) {
        this.decode = string;
    }

    public String getFirstName() {
        return this.decode;
    }

    public void setLastName(String string) {
        this.delete = string;
    }

    public String getLastName() {
        return this.delete;
    }

    public void setEmail(String string) {
        this.dot3 = string;
    }

    public String getEmail() {
        return this.dot3;
    }

    public void setPhone(String string) {
        this.encode = string;
    }

    public String getPhone() {
        return this.encode;
    }

    public void setISV(String string) {
        this.endsWith = string;
    }

    public String getISV() {
        return this.endsWith;
    }

    public void setExtNum(int n) {
        this.getAllByName = n;
    }

    public int getExtNum() {
        return this.getAllByName;
    }

    public void setUserID(String string) {
        checkISV = string;
    }

    public String getUserID() {
        return checkISV;
    }

    public void setMacNum(int n) {
        this.get = n;
    }

    public int getMacNum() throws FileNotFoundException, IOException {
        if (this.get == -1) {
            this.append();
        }
        return this.get;
    }

    public boolean setPrdName(String string) {
        if (RegisterAPI.getPrdID(string) != -1) {
            this.exists = string;
            return true;
        }
        return false;
    }

    public String getPrdName() {
        return this.exists;
    }

    public void setInstallRoot(String string) {
        check = string;
        RegisterAPI.delete();
    }

    public String getInstallRoot() {
        return check;
    }

    public boolean setGracePeriod(int n) {
        if (n <= 0 || n > 60) {
            return false;
        }
        buildLicense = n;
        return true;
    }

    public int getGracePeriod() {
        return buildLicense;
    }

    public String doRegister() {
        String string = null;
        String string2 = "http://www.jinfonet.com:8080/servlets/jregister/config";
        try {
            string = this.equalsIgnoreCase(string2);
            RegisterAPI.log("Try to register, 1st: " + string);
            if (this.getRegCode(string) == null) {
                throw new RegisterException(1013);
            }
        }
        catch (RegisterException registerException) {
            RegisterAPI.log(registerException);
            try {
                String[] stringArray = this.getHost();
                string2 = "http://" + stringArray[0] + ":" + stringArray[1] + "/" + getPrdID + "/" + "config";
                string = this.equalsIgnoreCase(string2);
                RegisterAPI.log("Try to register, 2nd: " + string);
                if (string == null) {
                    string = "No response! Please contact support@jinfonet.com for assistance!";
                }
            }
            catch (RegisterException registerException2) {
                RegisterAPI.log(registerException2);
            }
        }
        return string;
    }

    public String getRegCode(String string) {
        String string2;
        int n;
        String string3 = null;
        if (string != null && string.startsWith("REGISTERCODE:") && (n = (string2 = string.substring("REGISTERCODE:".length()).trim()).indexOf("ER56T78")) != -1) {
            string3 = string2.substring(0, n);
        }
        return string3;
    }

    public void writeRegCode(String string) throws IOException {
        RegisterAPI.dot3(RegisterAPI.endsWith(check), "regCode", string);
    }

    public static void writePrdKey(String string, String string2, String string3) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("uid", string2);
        hashtable.put(rpRW.getPaJrKey(), string3);
        rpRW.write(RegisterAPI.endsWith(string), hashtable);
        check = string;
        RegisterAPI.close(string);
    }

    public boolean isValidKey() throws FileNotFoundException {
        String string = RegisterAPI.endsWith(check);
        if (!new File(string).exists()) {
            throw new FileNotFoundException("Cannot find the data file '" + string + "'!");
        }
        boolean bl = KeyChecker.check(string);
        if (bl) {
            checkISV = KeyChecker.userID;
        }
        return bl;
    }

    public boolean isMasterKey() throws FileNotFoundException {
        boolean bl = false;
        if (this.isValidKey()) {
            bl = KeyChecker.isRegisterRequired();
        }
        return bl;
    }

    public boolean isFirstTry() throws FileNotFoundException, IOException {
        if (this.getInputStream == -1L) {
            this.append();
        }
        return System.currentTimeMillis() - this.getInputStream < 60000L;
    }

    public int getLeftDays() throws FileNotFoundException, IOException {
        if (this.getISV == -1L) {
            this.append();
        }
        String string = this.FILE_PATH();
        int n = -1;
        if (string == null || string.length() == 0) {
            n = buildLicense - (int)((System.currentTimeMillis() - this.getISV) / 86400000L);
            if (n <= 0) {
                n = -1;
            }
        } else {
            int n2 = RegAlgorithm.getExtNum(string);
            if (n2 == 0) {
                n = 0;
            } else {
                n = buildLicense * (n2 + 1) - (int)((System.currentTimeMillis() - this.getISV) / 86400000L);
                if (n <= 0) {
                    n = -1;
                }
            }
        }
        return n;
    }

    public boolean isRegistrationValid() throws FileNotFoundException, IOException {
        String string = this.FILE_PATH();
        return this.isRegCodeValid(string);
    }

    public boolean isRegCodeValid(String string) throws FileNotFoundException, IOException {
        if (RegAlgorithm.getMacNum(string) != this.getMacNum()) {
            return false;
        }
        return RegAlgorithm.checkISV(string, this.getISV());
    }

    public static final String[] getPrdList() {
        return addQuery;
    }

    public static final String getPrdName(int n) {
        if (n >= 0 && n < 8) {
            return addQuery[n];
        }
        return null;
    }

    public static final int getPrdID(String string) {
        for (int i = 0; i < addQuery.length; ++i) {
            if (!string.trim().equalsIgnoreCase(addQuery[i])) continue;
            return i;
        }
        return -1;
    }

    public static void setLogFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        getRegCode = new PrintStream(new FileOutputStream(file));
    }

    public static void log(String string) {
        if (getRegCode != null) {
            getRegCode.println(string);
        }
    }

    public static void log(Throwable throwable) {
        if (getRegCode != null) {
            throwable.printStackTrace(getRegCode);
        }
    }

    private final void BuildNumber() {
        String string = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            for (int i = 0; i < inetAddressArray.length; ++i) {
                string = string + inetAddressArray[i].toString() + ";";
            }
        }
        catch (UnknownHostException unknownHostException) {
            RegisterAPI.log(new UnknownHostException(""));
        }
        this.equalsIgnoreCase = string;
    }

    private String FILE_PATH() throws FileNotFoundException, IOException {
        if (this.getHostName == null) {
            this.append();
        }
        return this.getHostName;
    }

    private String SEDU(String string) {
        String string2 = null;
        byte[] byArray = null;
        try {
            byArray = Base64.encode(string);
            string2 = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray);
        }
        return string2;
    }

    private String addQuery(String string) {
        String string2 = null;
        byte[] byArray = null;
        try {
            byArray = Base64.decode(string);
            string2 = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray);
        }
        catch (IOException iOException) {
            RegisterAPI.log(new RegisterException(1004));
        }
        return string2;
    }

    private final void append() throws FileNotFoundException, IOException {
        Hashtable hashtable = null;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(RegisterAPI.endsWith(check)));
        hashtable = rpRW.read(dataInputStream);
        String string = (String)hashtable.get("regVer");
        int n = 0;
        n = string == null || string.trim().length() == 0 ? 0 : Integer.parseInt(string);
        this.getHostName = (String)hashtable.get("regCode");
        string = (String)hashtable.get("firstTry");
        this.getInputStream = string == null || string.trim().length() == 0 ? -1L : Long.parseLong(string);
        this.buildLicense();
        if (this.getInputStream == -1L) {
            this.checkISV();
        }
    }

    private final void buildLicense() {
        Hashtable hashtable = RegisterAPI.check(RegisterAPI.encode());
        String string = (String)hashtable.get("macNum");
        this.get = string == null || string.trim().length() == 0 ? -1 : (int)((Long.parseLong(string) & 0xFFFFL) * 10000L / 65535L);
        String string2 = RegisterAPI.decode();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            long l;
            String string3 = (String)enumeration.nextElement();
            if (string3.indexOf(string2) != 0 || (l = (string = (String)hashtable.get(RegisterAPI.currentTimeMillis())) == null || string.trim().length() == 0 ? -1L : Long.parseLong(string)) <= this.getISV) continue;
            this.getISV = l;
        }
    }

    private static final Hashtable check(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = rpRW.read(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            RegisterAPI.log(new RegisterException(1005));
        }
        catch (IOException iOException) {
            RegisterAPI.log(new RegisterException(1006));
        }
        return hashtable;
    }

    private final void checkISV() throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("regVer", "1");
        hashtable.put("regCode", this.getHostName == null ? "" : this.getHostName);
        this.getInputStream = System.currentTimeMillis();
        hashtable.put("firstTry", "" + this.getInputStream);
        rpRW.write(RegisterAPI.endsWith(check), hashtable);
    }

    private static final void close(String string) {
        if (!new File(RegisterAPI.encode()).exists()) {
            long l = System.currentTimeMillis();
            long l2 = (int)l;
            long l3 = (int)l >> 32;
            try {
                RegisterAPI.dot3(RegisterAPI.encode(), "macNum", "" + l3 * l2);
            }
            catch (IOException iOException) {
                RegisterAPI.log(new RegisterException(1007));
            }
        }
        try {
            String string2 = RegisterAPI.currentTimeMillis();
            Hashtable hashtable = RegisterAPI.check(RegisterAPI.encode());
            String string3 = (String)hashtable.get(string2);
            if (string3 == null) {
                long l = System.currentTimeMillis();
                RegisterAPI.dot3(RegisterAPI.encode(), string2, "" + l);
            }
        }
        catch (IOException iOException) {
            RegisterAPI.log(new RegisterException(1008));
        }
    }

    private static final String currentTimeMillis() {
        return RegisterAPI.decode() + "_" + ReportEnv.major + "." + ReportEnv.minor + "." + ReportEnv.dot3 + "_Build" + ReportEnv.BuildNumber + "_Help" + 800 + "_Release(" + ReportEnv.releaseDate + ")";
    }

    private static final String decode() {
        RegisterAPI.delete();
        long l = ReportEnv.buildLicense(checkISV, close);
        int n = (int)(l >> 52) & 0xFF;
        return "JRProd#" + RegisterAPI.exists(n);
    }

    private static final void delete() {
        if (checkISV == null || checkISV.length() == 0 || close == null || close.length() == 0) {
            try {
                Hashtable hashtable = rpRW.read(new FileInputStream(RegisterAPI.endsWith(check)));
                checkISV = (String)hashtable.get("uid");
                close = (String)hashtable.get(rpRW.getPaJrKey());
            }
            catch (Exception exception) {
                RegisterAPI.log(exception);
            }
        }
    }

    private static final void dot3(String string, String string2, String string3) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(string2, string3);
        rpRW.write(string, hashtable);
    }

    private static final String encode() {
        String string = null;
        Properties properties = System.getProperties();
        boolean bl = properties.getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1;
        String string2 = properties.getProperty("java.library.path");
        String string3 = properties.getProperty("path.separator");
        if (bl) {
            string2 = string2.toUpperCase();
            int n = -1;
            n = string2.indexOf("WINNT\\SYSTEM32") != -1 ? string2.indexOf("WINNT\\SYSTEM32") : (string2.indexOf("WINDOWS\\SYSTEM32") != -1 ? string2.indexOf("WINDOWS\\SYSTEM32") : (string2.indexOf("WINNT") != -1 ? string2.indexOf("WINNT") : (string2.indexOf("WINDOWS") != -1 ? string2.indexOf("WINDOWS") : 0)));
            int n2 = string2.lastIndexOf(string3, n) + 1;
            int n3 = string2.indexOf(string3, n);
            if (n3 == -1) {
                n3 = string2.length();
            }
            string = string2.substring(n2, n3) + File.separator + BuildNumber;
        } else if (new File(SEDU).exists()) {
            string = SEDU + File.separator + FILE_PATH;
        } else {
            int n = string2.indexOf(string3);
            string = string2.substring(0, n) + File.separator + FILE_PATH;
        }
        return string;
    }

    private static String endsWith(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string + rpRW.FILE_PATH;
    }

    private String equalsIgnoreCase(String string) throws RegisterException {
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            QueryString queryString = new QueryString();
            queryString.addQuery("COMPANY", this.currentTimeMillis);
            queryString.addQuery("FIRSTNAME", this.decode);
            queryString.addQuery("LASTNAME", this.delete);
            queryString.addQuery("EMAIL", this.dot3);
            queryString.addQuery("PHONE", this.encode);
            if (this.endsWith == null) {
                this.endsWith = "";
            }
            queryString.addQuery("ISVNAME", this.endsWith);
            if (checkISV == null) {
                checkISV = "";
            }
            queryString.addQuery("USERID", checkISV);
            queryString.addQuery("IPS", this.equalsIgnoreCase);
            queryString.addQuery("EXTTIMES", this.getAllByName + "");
            queryString.addQuery("MACHINECODE", this.get + "");
            if (this.exists == null) {
                this.exists = addQuery[0];
            }
            queryString.addQuery("PRODUCTID", RegisterAPI.getPrdID(this.exists) + 1 + "");
            queryString.addQuery("GRACEPERIOD", buildLicense + "");
            queryString.addQuery("ADDINFOS", RegisterAPI.get(check));
            String string3 = queryString.toString();
            if (string3.length() != 0) {
                string = string + "?" + string3;
            }
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            string2 = bufferedReader.readLine();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RegisterException(1001);
        }
        catch (IOException iOException) {
            throw new RegisterException(1002);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new RegisterException(1003);
                }
            }
        }
        return string2;
    }

    private String[] getHost() throws RegisterException {
        String[] stringArray = new String[2];
        String string = "http://www.jinfonet.com/reg/reghost.ini";
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(false);
            uRLConnection.setDoInput(true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("host")) {
                    stringArray[0] = string2.substring(string2.indexOf("=") + 1).trim();
                    continue;
                }
                if (!string2.startsWith("port")) continue;
                stringArray[1] = string2.substring(string2.indexOf("=") + 1).trim();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RegisterException(1009);
        }
        catch (IOException iOException) {
            throw new RegisterException(1010);
        }
        return stringArray;
    }

    private static final int exists(int n) {
        for (int i = 0; i < append.length; ++i) {
            if (n != append[i]) continue;
            return i;
        }
        return -1;
    }

    private static final String get(String string) {
        String string2;
        Enumeration enumeration;
        Serializable serializable;
        if (string == null) {
            return "";
        }
        Hashtable hashtable = null;
        try {
            hashtable = rpRW.read(new FileInputStream(RegisterAPI.encode()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            RegisterAPI.log(new RegisterException(1011));
        }
        catch (IOException iOException) {
            RegisterAPI.log(new RegisterException(1012));
        }
        try {
            serializable = rpRW.read(new FileInputStream(RegisterAPI.endsWith(string)));
            enumeration = ((Hashtable)serializable).keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                hashtable.put(string2, ((Hashtable)serializable).get(string2));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            RegisterAPI.log(fileNotFoundException);
        }
        catch (IOException iOException) {
            RegisterAPI.log(iOException);
        }
        serializable = new StringBuffer();
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            ((StringBuffer)serializable).append(string2.toString() + "=" + hashtable.get(string2).toString() + "\r\n");
        }
        return ((StringBuffer)serializable).toString();
    }

    static {
        getRegCode = null;
    }
}

