/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.report.convert;

import com.jinfonet.report.convert.Converter;
import com.jinfonet.report.convert.ConverterException;
import com.jinfonet.report.convert.RptConvertEnv;
import java.io.File;
import jet.Env;
import jet.controls.JetObject;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.lc.impl.JetLCObject;
import jet.lc.io.LCObjectIO;
import jet.report.JetRptObject;
import jet.report.JetRptReportPanel;
import jet.reportset.JetRptReportSet;
import jet.upgrade.JUpgradeException;
import jet.upgrade.UpgradeUtil;
import jet.upgrade.UpgradeVersion;

public class RptConverterImpl
implements Converter {
    @Override
    public boolean isNeedUpgrade(File file) throws ConverterException {
        int n;
        Object object;
        JetObject jetObject;
        block8: {
            jetObject = null;
            try {
                object = file.getAbsolutePath();
                n = Env.getFileType((String)object);
                if (n == 6 || n == 9 || n == 8 || n == 10) {
                    LoaderNoCache loaderNoCache = new LoaderNoCache((String)object);
                    jetObject = loaderNoCache.loadNoInit();
                    if (!(jetObject instanceof JetRptReportPanel || jetObject instanceof JetRptReportSet || jetObject instanceof JetLCObject)) {
                        throw new ConverterException(new Exception("The object in \"" + file + "\" is not Report,WebReport, VA or LC"));
                    }
                    break block8;
                }
                throw new ConverterException(new Exception(file + " is not supportted that only \".cls/.cls.xml/.rpt/.clx/.wls/.lc/.va\" can be converted"));
            }
            catch (ReadFailureException readFailureException) {
                throw new ConverterException(readFailureException);
            }
        }
        if (jetObject instanceof JetRptReportPanel) {
            return true;
        }
        if (jetObject instanceof JetRptReportSet) {
            UpgradeVersion upgradeVersion;
            object = (JetRptReportSet)jetObject;
            n = ((JetRptReportSet)object).major.intValue();
            int n2 = ((JetRptReportSet)object).BuildNumber.intValue();
            if (n <= 0 || n2 < 800) {
                n = 8;
                n2 = 800;
            }
            return (upgradeVersion = UpgradeVersion.createUVersion(n, ((JetRptReportSet)object).minor.intValue(), n2, ((JetRptReportSet)object).ServicePack.intValue())).compareTo(UpgradeVersion.MAXSUPPORT) < 0;
        }
        object = (JetLCObject)jetObject;
        n = ((JetLCObject)object).getLCStructureVersion();
        int n3 = ((JetLCObject)object).getLCComponentVersion();
        if (n > 1) {
            return false;
        }
        UpgradeVersion upgradeVersion = UpgradeVersion.createUVersion(Integer.MAX_VALUE, 0, n3, 0);
        return upgradeVersion.compareTo(UpgradeVersion.MAXSUPPORT) < 0;
    }

    public void doUpgrade(File file, File file2, RptConvertEnv rptConvertEnv) throws ConverterException {
        String string = file.getAbsolutePath();
        int n = Env.getFileType(string);
        if (n == 6 || n == 9 || n == 10) {
            String string2;
            LoaderNoCache loaderNoCache = new LoaderNoCache(string);
            loaderNoCache.setEditable(true);
            JetObject jetObject = null;
            try {
                jetObject = loaderNoCache.load();
            }
            catch (ReadFailureException readFailureException) {
                throw new ConverterException(readFailureException);
            }
            JetRptReportSet jetRptReportSet = null;
            if (jetObject instanceof JetRptReportPanel || jetObject instanceof JetRptReportSet) {
                try {
                    jetRptReportSet = (JetRptReportSet)UpgradeUtil.upgradeRpt((JetRptObject)jetObject, rptConvertEnv.getUniverse(), n, rptConvertEnv.getResourceStore());
                }
                catch (JUpgradeException jUpgradeException) {
                    throw new ConverterException(jUpgradeException);
                }
            } else {
                throw new ConverterException(new Exception("The object in \"" + file + "\" is not Report,WebReport or VA"));
            }
            if (file2 == null) {
                file2 = file;
            }
            if ((string2 = file2.getName().toLowerCase()).endsWith(".clx")) {
                jetRptReportSet.setBoundUniverse(rptConvertEnv.getUniverse());
            }
            try {
                LoaderNoCache.save(null, jetRptReportSet, jetRptReportSet.getInstName(), file2.getAbsolutePath());
            }
            catch (WriteFailureException writeFailureException) {
                throw new ConverterException(writeFailureException);
            }
        }
        if (n == 8) {
            JetLCObject jetLCObject = null;
            try {
                jetLCObject = (JetLCObject)LCObjectIO.loadLCObject(file, rptConvertEnv.getUniverse(), rptConvertEnv.getResourceStore());
            }
            catch (ReadFailureException readFailureException) {
                throw new ConverterException(readFailureException);
            }
            catch (JUpgradeException jUpgradeException) {
                throw new ConverterException(jUpgradeException);
            }
            if (file2 == null) {
                file2 = file;
            }
            try {
                LCObjectIO.saveLCObject(jetLCObject, rptConvertEnv.getUniverse(), file2, null);
            }
            catch (WriteFailureException writeFailureException) {
                throw new ConverterException(writeFailureException);
            }
        }
        throw new ConverterException(new Exception(file + " is not supportted that only \".cls/.cls.xml/.rpt/.clx/.wls/.lc/.va\" can be converted"));
    }
}

