/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.report.convert;

import com.jinfonet.report.convert.Converter;
import com.jinfonet.report.convert.ConverterException;
import com.jinfonet.report.convert.ConverterFactory;
import com.jinfonet.report.convert.FileFilterImpl;
import com.jinfonet.report.convert.FilenameFilterImpl;
import com.jinfonet.report.convert.RptConvertEnv;
import com.jinfonet.resstore.ResourceStore;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jet.ReportEnv;
import jet.jetc.ReadFailureException;
import jet.universe.JetUUniverse;
import jet.universe.exception.UniverseFileException;

public class SchemaConvert {
    static String HELP_MSG = "Convert report templates of previous versions to V8. \nUsage: rptconv \"-source=path\" [\"-target=path\"] [-r] [-s]\n-source\t\tSpecify the source path of the report(s) that are to be converted.\n-target\t\tSpecify the destination path for the converted report(s).\n-r\t\tReplace the source report with the converted version.\n-s\t\tSearch and convert the specified directory's contents, including all subdirectories.";
    static String CONVERT_PREFIX = "convert_";
    static String MSG_CATALOG_MISSING = "Can not find the catalog file, skip converting.";
    static String MSG_PATH_NOT_FOUND = "Can not find the specified path:";
    private static Logger INFO = null;

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        if (stringArray.length > 0) {
            INFO = Logger.getLogger(SchemaConvert.class.getName());
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("-")) continue;
                if (stringArray[i].equals("-r")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-s")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-?") || stringArray[i].equals("-help")) {
                    SchemaConvert.showHelpExit();
                    continue;
                }
                if (stringArray[i].startsWith("-source=")) {
                    string = stringArray[i].substring(8);
                    continue;
                }
                if (!stringArray[i].startsWith("-target=")) continue;
                string2 = stringArray[i].substring(8);
            }
            if (string != null) {
                Object object = new Object();
                ReportEnv.checkEnv(object, null, 0);
                new SchemaConvert().execute(string, string2, bl, bl2);
                return;
            }
            SchemaConvert.showHelpExit();
            return;
        }
        SchemaConvert.showHelpExit();
    }

    static void showHelpMsg() {
        System.out.print(HELP_MSG);
    }

    static void showHelpExit() {
        SchemaConvert.showHelpMsg();
    }

    void execute(String string, String string2, boolean bl, boolean bl2) {
        if (this.WARNING(string)) {
            this.INFO(string, string2, bl, bl2, false);
        } else {
            File file = new File(string);
            if (file.exists()) {
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    System.out.println("Invalid source path:\"" + string + "\".");
                    return;
                }
                if (file.isDirectory()) {
                    this.HELP_MSG(string, string2, bl, bl2, false);
                } else if (file.isFile()) {
                    this.CONVERT_PREFIX(string, string2, bl, false);
                }
            } else {
                System.out.println(MSG_PATH_NOT_FOUND + "\"" + string + "\".");
            }
        }
    }

    private void CONVERT_PREFIX(String string, String string2, boolean bl, boolean bl2) {
        int n = string.lastIndexOf(File.separator);
        String string3 = string.substring(0, n + 1);
        String string4 = this.getCatalogFile(string3);
        if (string4 == null) {
            System.out.println(string3 + " : " + MSG_CATALOG_MISSING);
            return;
        }
        string4 = string3 + this.getCatalogFile(string3);
        if (bl) {
            string2 = string;
        } else if (string2 == null || new File(string2).equals(new File(string))) {
            string2 = string3 + CONVERT_PREFIX + string.substring(string.lastIndexOf(File.separator) + 1);
        } else {
            File file = new File(string2);
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                System.out.println("Invalid target:\"" + string2 + "\".");
                return;
            }
            if (!this.checkEnv(string2)) {
                string2 = string2 + string.substring(n);
            }
        }
        this.execute(string4, string, string2, bl2);
    }

    private void HELP_MSG(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        int n;
        Object[] objectArray;
        String string3;
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        String string4 = null;
        bl5 = this.append(string2);
        if (bl5) {
            string4 = string2.substring(string2.lastIndexOf("*.") + 1);
            string2 = string2.substring(0, string2.lastIndexOf(File.separator));
        }
        if ((string3 = this.getCatalogFile(string)) == null) {
            System.out.println(string + " : " + MSG_CATALOG_MISSING);
        } else {
            string3 = string + string3;
            if (bl) {
                string2 = string;
            } else if (string2 == null) {
                string2 = string;
                bl4 = true;
            } else {
                objectArray = new File(string2);
                if (!objectArray.exists()) {
                    objectArray.mkdirs();
                }
                if (!objectArray.isDirectory()) {
                    System.out.println("Invalid target path:\"" + string2 + "\".");
                    return;
                }
                try {
                    string2 = objectArray.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = objectArray.getAbsolutePath();
                }
                if (string2.equals(string)) {
                    bl4 = true;
                }
            }
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            objectArray = this.LoadUniverse(string, ".cls");
            for (n = 0; n < objectArray.length; ++n) {
                object = bl4 ? CONVERT_PREFIX + (String)objectArray[n] : (bl5 ? ((String)objectArray[n]).substring(0, ((String)objectArray[n]).length() - ".cls".length()) + string4 : objectArray[n]);
                this.execute(string3, string + (String)objectArray[n], string2 + (String)object, bl3);
            }
            objectArray = this.LoadUniverse(string, ".rpt");
            for (n = 0; n < objectArray.length; ++n) {
                object = bl4 ? CONVERT_PREFIX + (String)objectArray[n] : (bl5 ? ((String)objectArray[n]).substring(0, ((String)objectArray[n]).length() - ".rpt".length()) + string4 : objectArray[n]);
                this.execute(string3, string + (String)objectArray[n], string2 + (String)object, bl3);
            }
            objectArray = this.LoadUniverse(string, ".cls.xml");
            for (n = 0; n < objectArray.length; ++n) {
                object = bl4 ? CONVERT_PREFIX + (String)objectArray[n] : (bl5 ? ((String)objectArray[n]).substring(0, ((String)objectArray[n]).length() - ".cls.xml".length()) + string4 : objectArray[n]);
                this.execute(string3, string + (String)objectArray[n], string2 + (String)object, bl3);
            }
            objectArray = this.LoadUniverse(string, ".clx");
            for (n = 0; n < objectArray.length; ++n) {
                object = bl4 ? CONVERT_PREFIX + (String)objectArray[n] : (bl5 ? ((String)objectArray[n]).substring(0, ((String)objectArray[n]).length() - ".clx".length()) + string4 : objectArray[n]);
                this.execute(string3, string + (String)objectArray[n], string2 + (String)object, bl3);
            }
        }
        if (bl2) {
            objectArray = this.SEVERE(string);
            for (n = 0; n < objectArray.length; ++n) {
                Object object2 = object = ((File)objectArray[n]).getAbsolutePath().endsWith(File.separator) ? ((File)objectArray[n]).getAbsolutePath() : ((File)objectArray[n]).getAbsoluteFile() + File.separator;
                if (((String)object).equals(string2)) continue;
                File file = new File(string2, ((File)objectArray[n]).getName());
                this.HELP_MSG(((File)objectArray[n]).getAbsolutePath(), file.getAbsolutePath() + (string4 == null ? "" : File.separator + "*" + string4), bl, bl2, bl3);
            }
        }
    }

    private void INFO(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        int n;
        Object object2;
        Object[] objectArray;
        String string3;
        int n2 = string.lastIndexOf(File.separator);
        String string4 = string.substring(0, n2 + 1);
        if (!new File(string4).exists()) {
            System.out.println(MSG_PATH_NOT_FOUND + "\"" + string4 + "\".");
            return;
        }
        String string5 = string.substring(n2 + 1);
        boolean bl4 = false;
        boolean bl5 = false;
        String string6 = null;
        bl5 = this.append(string2);
        if (bl5) {
            string6 = string2.substring(string2.lastIndexOf("*.") + 1);
            string2 = string2.substring(0, string2.lastIndexOf(File.separator));
        }
        if ((string3 = this.getCatalogFile(string4)) == null) {
            System.out.println(string4 + " : " + MSG_CATALOG_MISSING);
        } else {
            string3 = string4 + string3;
            if (bl) {
                string2 = string4;
            } else if (string2 == null) {
                string2 = string4;
                bl4 = true;
            } else {
                objectArray = new File(string2);
                if (!objectArray.exists()) {
                    objectArray.mkdirs();
                }
                if (!objectArray.isDirectory()) {
                    System.out.println("Invalid target path:\"" + string2 + "\".");
                    return;
                }
                if (!objectArray.isAbsolute()) {
                    try {
                        string2 = objectArray.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string2 = objectArray.getAbsolutePath();
                    }
                }
                if (string2.equals(string4)) {
                    bl4 = true;
                }
            }
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            objectArray = new File(string4).list(new FilenameFilterImpl(string5));
            object2 = null;
            if (objectArray.length > 0) {
                if (Pattern.compile(".*.cls$", 2).matcher((CharSequence)objectArray[0]).matches()) {
                    object2 = ".cls";
                } else if (Pattern.compile(".*.clx$", 2).matcher((CharSequence)objectArray[0]).matches()) {
                    object2 = ".clx";
                } else if (Pattern.compile(".*.rpt$", 2).matcher((CharSequence)objectArray[0]).matches()) {
                    object2 = ".rpt";
                } else if (Pattern.compile(".*.cls.xml$", 2).matcher((CharSequence)objectArray[0]).matches()) {
                    object2 = ".cls.xml";
                }
            }
            for (n = 0; n < objectArray.length; ++n) {
                object = bl4 ? CONVERT_PREFIX + (String)objectArray[n] : (bl5 ? ((String)objectArray[n]).substring(0, ((String)objectArray[n]).length() - ((String)object2).length()) + string6 : objectArray[n]);
                this.execute(string3, string4 + (String)objectArray[n], string2 + (String)object, bl3);
            }
        }
        if (bl2) {
            objectArray = this.SEVERE(string4);
            for (n = 0; n < objectArray.length; ++n) {
                Object object3 = object = objectArray[n].getAbsolutePath().endsWith(File.separator) ? ((File)objectArray[n]).getAbsolutePath() : ((File)objectArray[n]).getAbsoluteFile() + File.separator;
                if (((String)object).equals(string2)) continue;
                object2 = new File(string2, ((File)objectArray[n]).getName());
                this.INFO(((File)objectArray[n]).getAbsolutePath() + File.separator + string5, ((File)object2).getAbsolutePath() + (string6 == null ? "" : File.separator + "*" + string6), bl, bl2, bl3);
            }
        }
    }

    private void execute(String string, String string2, String string3, boolean bl) {
        String string4;
        boolean bl2;
        block18: {
            JetUUniverse jetUUniverse;
            block17: {
                bl2 = false;
                string4 = null;
                jetUUniverse = null;
                if (string != null) {
                    try {
                        jetUUniverse = JetUUniverse.LoadUniverse(string);
                    }
                    catch (ReadFailureException readFailureException) {
                        bl2 = true;
                        string4 = readFailureException.getMessage();
                        if (INFO != null) {
                            INFO.log(Level.SEVERE, "Error occured when loading catalog (" + string + ").", readFailureException);
                        }
                    }
                    catch (UniverseFileException universeFileException) {
                        bl2 = true;
                        string4 = universeFileException.getMessage();
                        if (INFO == null) break block17;
                        INFO.log(Level.SEVERE, "Error occured when loading catalog (" + string + ").", universeFileException);
                    }
                }
            }
            if (!bl2) {
                RptConvertEnvImpl rptConvertEnvImpl = new RptConvertEnvImpl(jetUUniverse);
                Converter converter = ConverterFactory.getReportConverter();
                try {
                    converter.doUpgrade(new File(string2), new File(string3), rptConvertEnvImpl);
                }
                catch (ConverterException converterException) {
                    Throwable throwable = converterException.getCause();
                    if (throwable == null) {
                        throwable = converterException;
                    }
                    bl2 = true;
                    string4 = throwable.getMessage();
                    if (INFO != null) {
                        INFO.log(Level.SEVERE, "Error occured when converting report (" + string2 + ").", throwable);
                    }
                }
                catch (Throwable throwable) {
                    bl2 = true;
                    string4 = throwable.getMessage();
                    String string5 = string4 = string4 == null ? "Unknown reason" : string4;
                    if (INFO == null) break block18;
                    INFO.log(Level.SEVERE, "Unknown error occured when converting " + string2 + ".", throwable);
                }
            }
        }
        if (!bl) {
            System.out.print(string2 + "=>" + string3 + ":");
            if (bl2) {
                System.out.println("Failed!(" + string4 + ")");
            } else {
                System.out.println("OK!");
            }
        }
        if (INFO != null) {
            if (bl2) {
                INFO.log(Level.WARNING, string2 + " was NOT converted to " + string3 + " due to " + string4);
            } else {
                INFO.log(Level.INFO, string2 + " was converted to " + string3 + " successfully");
            }
        }
    }

    String getCatalogFile(String string) {
        return this.MSG_PATH_NOT_FOUND(string, ".cat");
    }

    private String[] LoadUniverse(String string, String string2) {
        File file = new File(string);
        return this.MSG_CATALOG_MISSING(file, string2);
    }

    private String[] MSG_CATALOG_MISSING(File file, String string) {
        String[] stringArray = file.list(new FilenameFilterImpl("*" + string + "$"));
        return stringArray;
    }

    private String MSG_PATH_NOT_FOUND(String string, String string2) {
        String[] stringArray = this.LoadUniverse(string, string2);
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    private String SEDU(File file, String string) {
        String[] stringArray = this.MSG_CATALOG_MISSING(file, string);
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    private File[] SEVERE(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles(new FileFilterImpl());
        return fileArray;
    }

    private boolean WARNING(String string) {
        String string2 = ".*[\\*|\\?].*.cls$|.*[\\*|\\?].*.clx$|.*[\\*|\\?].*.cls.xml$|.*[\\*|\\?].*.rpt$";
        Pattern pattern = Pattern.compile(string2, 2);
        return pattern.matcher(string).matches();
    }

    private boolean append(String string) {
        if (string == null) {
            return false;
        }
        String string2 = ".*\\*.cls$|.*\\*.clx$|.*\\*.cls.xml$|.*\\*.rpt$";
        Pattern pattern = Pattern.compile(string2, 2);
        return pattern.matcher(string).matches();
    }

    private boolean checkEnv(String string) {
        int n = string.length();
        if (string.regionMatches(true, n - ".cls".length(), ".cls", 0, ".cls".length())) {
            return true;
        }
        if (string.regionMatches(true, n - ".clx".length(), ".clx", 0, ".clx".length())) {
            return true;
        }
        if (string.regionMatches(true, n - ".cls.xml".length(), ".cls.xml", 0, ".cls.xml".length())) {
            return true;
        }
        return string.regionMatches(true, n - ".rpt".length(), ".rpt", 0, ".rpt".length());
    }

    class RptConvertEnvImpl
    implements RptConvertEnv {
        final JetUUniverse unv;

        RptConvertEnvImpl(JetUUniverse jetUUniverse) {
            this.unv = jetUUniverse;
        }

        @Override
        public ResourceStore getResourceStore() {
            return null;
        }

        @Override
        public JetUUniverse getUniverse() {
            return this.unv;
        }
    }
}

