/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.resstore.defaultimpl;

import com.jinfonet.resstore.MemoryStore;
import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.resstore.defaultimpl.DummySpaceAllocator;
import com.jinfonet.resstore.loader.CacheableLoader;
import com.jinfonet.resstore.loader.CatalogIDImpl;
import com.jinfonet.resstore.loader.ImageIDImpl;
import com.jinfonet.resstore.loader.ReportIDImpl;
import java.io.File;
import java.util.Locale;
import jet.controls.JetObject;
import jet.jetc.JetObjectLoader;
import jet.jetc.UniverseLoader;
import jet.universe.JetUUniverse;
import jet.util.image.ImageResource;
import jet.util.image.ImageResourceLoader;

class DefaultMemoryStore
implements MemoryStore {
    private ResourceStore SEDU;
    private final CacheableLoader load;
    private final CacheableLoader setMaxSize;
    private final CacheableLoader setMaxSpace;

    public DefaultMemoryStore(ResourceStore resourceStore) {
        this.SEDU = resourceStore;
        DummySpaceAllocator dummySpaceAllocator = new DummySpaceAllocator(false);
        this.load = new UniverseLoader();
        this.load.setSpaceAllocator(dummySpaceAllocator);
        this.load.setMaxSize(0);
        this.load.setMaxSpace(0L);
        this.setMaxSize = new JetObjectLoader();
        this.setMaxSize.setSpaceAllocator(dummySpaceAllocator);
        this.setMaxSize.setMaxSize(0);
        this.setMaxSize.setMaxSpace(0L);
        this.setMaxSpace = new ImageResourceLoader();
        this.setMaxSpace.setSpaceAllocator(new DummySpaceAllocator(true));
        this.setMaxSpace.setMaxSize(Integer.MAX_VALUE);
        this.setMaxSpace.setMaxSpace(0xA00000L);
    }

    @Override
    public JetUUniverse loadCatalog(File file) throws ResourceNotFoundException, ResourceLoadException {
        return this.SEDU(file, false);
    }

    @Override
    public JetUUniverse loadCatalogNoCache(File file) throws ResourceNotFoundException, ResourceLoadException {
        return this.SEDU(file, true);
    }

    private JetUUniverse SEDU(File file, boolean bl) throws ResourceNotFoundException, ResourceLoadException {
        JetUUniverse jetUUniverse = (JetUUniverse)this.load.load(new CatalogIDImpl(file), bl);
        if (jetUUniverse != null) {
            jetUUniverse.setResourceStore(this.SEDU);
        }
        return jetUUniverse;
    }

    @Override
    public JetObject loadReport(File file, String string, Locale locale) throws ResourceNotFoundException, ResourceLoadException {
        return (JetObject)this.setMaxSize.load(new ReportIDImpl(file, string, locale), false);
    }

    @Override
    public JetObject loadReportNoCache(File file, String string, Locale locale) throws ResourceNotFoundException, ResourceLoadException {
        return (JetObject)this.setMaxSize.load(new ReportIDImpl(file, string, locale), true);
    }

    @Override
    public ImageResource loadImage(File file, String string) throws ResourceNotFoundException, ResourceLoadException {
        return (ImageResource)this.setMaxSpace.load(new ImageIDImpl(file, string), false);
    }
}

