/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.api;

import com.jinfonet.security.api.AuthorizeManager;
import com.jinfonet.security.api.PrincipalManager;
import com.jinfonet.security.control.JRCubeAuthorizeManager;
import com.jinfonet.security.control.JRPrincipalManager;
import java.util.Hashtable;
import jet.ReportEnv;
import jet.cs.jacl.SecurityData;

public class SecurityService {
    private static SecurityService I = null;
    private static PrincipalManager SEDU = null;
    private Hashtable get = new Hashtable();
    private boolean getCubeAuthorizeManager = false;
    private boolean getPrincipalManager = true;

    private SecurityService() {
    }

    public static SecurityService getInstance() {
        if (I == null) {
            I = new SecurityService();
        }
        return I;
    }

    public PrincipalManager getPrincipalManager() {
        if (SEDU == null) {
            SEDU = new JRPrincipalManager();
        }
        return SEDU;
    }

    public AuthorizeManager getCubeAuthorizeManager(String string) {
        return this.getCubeAuthorizeManager(string, ReportEnv.productid == 7);
    }

    public AuthorizeManager getCubeAuthorizeManager(String string, boolean bl) {
        AuthorizeManager authorizeManager;
        if (string != null) {
            if (this.get.get(string) != null) {
                authorizeManager = (AuthorizeManager)this.get.get(string);
            } else {
                authorizeManager = new JRCubeAuthorizeManager(string, bl);
                this.get.put(string, authorizeManager);
            }
        } else {
            authorizeManager = new JRCubeAuthorizeManager(string, bl);
        }
        return authorizeManager;
    }

    public SecurityData getSecurityData(String string) {
        this.getCubeAuthorizeManager(string, false);
        return (SecurityData)((Object)this.getPrincipalManager());
    }

    public void setCubeAuthorizeManager(String string, AuthorizeManager authorizeManager) {
        if (string != null && authorizeManager != null) {
            this.get.put(string, authorizeManager);
        }
    }

    public boolean isRoleBased() {
        return this.getCubeAuthorizeManager;
    }

    public void setRoleBased(boolean bl) {
        this.getCubeAuthorizeManager = bl;
    }

    public boolean needSecurity() {
        return this.getPrincipalManager;
    }

    public void setNeedSecurity(boolean bl) {
        this.getPrincipalManager = bl;
    }
}

