/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.control;

import com.jinfonet.security.api.PrincipalManager;
import com.jinfonet.security.api.exception.InvalidResource;
import com.jinfonet.security.api.exception.NoPermissionException;
import com.jinfonet.security.control.CubePermissionCalculator;
import com.jinfonet.security.control.JRPrincipal;
import com.jinfonet.security.control.PermissionCalculator;
import com.jinfonet.security.util.AclToolkit;
import guitools.toolkit.JDebug;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Hashtable;

public class CubeAclManager {
    private Hashtable SEDU;
    private PrincipalManager WARNING;
    private PermissionCalculator append = null;

    public CubeAclManager(PrincipalManager principalManager, Hashtable hashtable) {
        this.SEDU = hashtable;
        this.WARNING = principalManager;
        String string = System.getProperty("com.jinfonet.permission.calculator");
        if (string == null || string.length() == 0) {
            this.append = new CubePermissionCalculator();
        } else {
            try {
                this.append = (PermissionCalculator)Class.forName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                JDebug.WARNING(instantiationException);
                this.append = new CubePermissionCalculator();
            }
            catch (IllegalAccessException illegalAccessException) {
                JDebug.WARNING(illegalAccessException);
                this.append = new CubePermissionCalculator();
            }
            catch (ClassNotFoundException classNotFoundException) {
                JDebug.WARNING(classNotFoundException);
                this.append = new CubePermissionCalculator();
            }
        }
    }

    public void setPrincipalManager(PrincipalManager principalManager) {
        this.WARNING = principalManager;
    }

    public void setAcls(Hashtable hashtable) {
        this.SEDU = hashtable;
    }

    public Hashtable getAcls() {
        return this.SEDU;
    }

    public boolean checkPermission(Principal principal, String string, Permission permission) throws InvalidResource {
        if (!(principal instanceof JRPrincipal)) {
            return false;
        }
        Acl acl = null;
        if (string.contains("&")) {
            if (this.SEDU.containsKey(string)) {
                acl = (Acl)this.SEDU.get(string);
            }
        } else {
            String string2 = "*." + string;
            if (this.SEDU.containsKey(string2)) {
                acl = (Acl)this.SEDU.get(string2);
            }
        }
        if (acl == null) {
            return true;
        }
        boolean bl = this.append.checkPermission((JRPrincipal)principal, acl, permission);
        while (!bl) {
            if ((string = this.SEDU(string)) == null || string.length() == 0) {
                return false;
            }
            bl = this.append.checkPermission((JRPrincipal)principal, acl, permission);
            if (!bl) continue;
            return true;
        }
        return bl;
    }

    private String SEDU(String string) {
        int n = string.lastIndexOf(".");
        String string2 = null;
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public Hashtable[] getPermissions(Principal principal, String string) throws NoPermissionException, InvalidResource {
        String string2;
        if (principal == null) {
            throw new NoPermissionException("The operator is null.");
        }
        if (string == null) {
            throw new InvalidResource("Resource path is null.");
        }
        Hashtable[] hashtableArray = null;
        Acl acl = null;
        if (string.contains("&")) {
            if (this.SEDU.containsKey(string)) {
                acl = (Acl)this.SEDU.get(string);
            }
        } else {
            string2 = "*." + string;
            if (this.SEDU.containsKey(string2)) {
                acl = (Acl)this.SEDU.get(string2);
            }
        }
        if (acl != null) {
            hashtableArray = AclToolkit.getHsahtableFromAcls(acl);
        } else {
            string2 = this.SEDU(string);
            if (string2 != null) {
                hashtableArray = this.getPermissions(principal, this.SEDU(string));
            }
        }
        return hashtableArray;
    }

    public void setPermissions(Principal principal, String string, Hashtable[] hashtableArray) throws NoPermissionException, InvalidResource {
        Acl acl;
        String string2 = string;
        if (!string.contains("&")) {
            string2 = "*." + string;
        }
        if (principal == null) {
            throw new NoPermissionException("The operator is null.");
        }
        if (string == null) {
            throw new InvalidResource("Resource path is null.");
        }
        String string3 = "JRAcl[" + string + "]";
        try {
            acl = AclToolkit.createAclByHashtable(principal, string3, hashtableArray, this.WARNING);
        }
        catch (NotOwnerException notOwnerException) {
            JDebug.WARNING(notOwnerException);
            throw new NoPermissionException("The operator is not acl owner!");
        }
        this.SEDU.put(string2, acl);
    }

    public void clearMem() {
        this.WARNING = null;
        this.SEDU = null;
    }
}

