/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.control;

import com.jinfonet.security.control.JRPrincipal;
import com.jinfonet.security.control.JRRole;
import com.jinfonet.security.control.JRUser;
import java.security.Principal;
import java.util.Vector;

public class JRGroup
extends JRPrincipal {
    private Vector parents = new Vector();
    private Vector parGroups = new Vector();
    private Vector roles = new Vector();
    private Vector users = new Vector();
    private Vector subGroups = new Vector();

    public JRGroup(String string, String string2) {
        super(string, string2);
    }

    @Override
    public int getPrincipalType() {
        return 1;
    }

    @Override
    public void addParent(Principal principal) {
        if (principal == null) {
            return;
        }
        this.parents.add(principal);
        if (principal instanceof JRGroup) {
            this.parGroups.add((JRGroup)principal);
            ((JRGroup)principal).addSubPrincipal(this);
        } else if (principal instanceof JRRole) {
            this.roles.add((JRRole)principal);
            ((JRRole)principal).addSubPrincipal(this);
        }
    }

    public void addSubPrincipal(Principal principal) {
        if (principal instanceof JRUser) {
            this.users.add((JRUser)principal);
        } else if (principal instanceof JRGroup) {
            this.subGroups.add((JRGroup)principal);
        }
    }

    @Override
    public void removeParent(Principal principal) {
        this.parents.remove(principal);
        this.parGroups.remove(principal);
        this.roles.remove(principal);
        if (principal instanceof JRGroup) {
            ((JRGroup)principal).removeSubPrincipal(this);
        } else if (principal instanceof JRRole) {
            ((JRRole)principal).removeSubPrincipal(this);
        }
    }

    public void removeSubPrincipal(Principal principal) {
        if (principal instanceof JRUser) {
            this.users.remove(principal);
        } else if (principal instanceof JRGroup) {
            this.subGroups.remove(principal);
        }
    }

    @Override
    public Principal[] getParents() {
        Principal[] principalArray = new Principal[this.parents.size()];
        for (int i = 0; i < this.parents.size(); ++i) {
            principalArray[i] = (Principal)this.parents.elementAt(i);
        }
        return principalArray;
    }

    public JRGroup[] getParentGroups() {
        JRGroup[] jRGroupArray = this.parGroups.toArray(new JRGroup[0]);
        return jRGroupArray;
    }

    public JRRole[] getRoles() {
        JRRole[] jRRoleArray = this.roles.toArray(new JRRole[0]);
        return jRRoleArray;
    }

    public JRUser[] getSubUsers() {
        JRUser[] jRUserArray = this.users.toArray(new JRUser[0]);
        return jRUserArray;
    }

    public JRGroup[] getSubGroups() {
        JRGroup[] jRGroupArray = this.subGroups.toArray(new JRGroup[0]);
        return jRGroupArray;
    }
}

