/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.control;

import com.jinfonet.security.api.PrincipalLoader;
import com.jinfonet.security.api.PrincipalManager;
import com.jinfonet.security.control.JRGroup;
import com.jinfonet.security.control.JRPrincipal;
import com.jinfonet.security.control.JRRole;
import com.jinfonet.security.control.JRUser;
import com.jinfonet.security.loader.DBMSPrincipalLoader;
import com.jinfonet.security.loader.InputPrincipalLoader;
import com.jinfonet.security.loader.LDAPPrincipalLoader;
import com.jinfonet.security.loader.ServerPrincipalLoader;
import com.jinfonet.security.loader.SystemPrincipalLoader;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.SecurityData;
import jet.cs.secinfo.BaseGroupImpl;
import jet.cs.secinfo.BaseRoleImpl;
import jet.cs.secinfo.BaseUserImpl;

public class JRPrincipalManager
implements PrincipalManager,
SecurityData {
    private Hashtable SEDU = null;
    private Hashtable add = null;
    private Hashtable addGroup = null;
    private Hashtable addParentGroup = new Hashtable(5);
    private int addParentRole = -1;
    private Properties addRole = new Properties();
    private ServerPrincipalLoader addSubGroup = null;

    @Override
    public PrincipalLoader getPrincipalLoader(int n) throws Exception {
        this.addParentRole = n;
        switch (n) {
            case 0: {
                String string = System.getProperty("com.jinfonet.principalLoader");
                Object object = this.addParentGroup.get(string);
                if (object == null) {
                    object = Class.forName(string).newInstance();
                    this.addParentGroup.put("CUSTOMIZE" + string, object);
                }
                return (PrincipalLoader)object;
            }
            case 1: {
                Object object = this.addParentGroup.get("SYSTEM");
                if (object == null) {
                    object = new SystemPrincipalLoader();
                    this.addParentGroup.put("SYSTEM", object);
                }
                return (SystemPrincipalLoader)object;
            }
            case 2: {
                Object object = this.addParentGroup.get("LDAP");
                if (object == null) {
                    object = new LDAPPrincipalLoader();
                    this.addParentGroup.put("LDAP", object);
                }
                return (LDAPPrincipalLoader)object;
            }
            case 3: {
                Object object = this.addParentGroup.get("DBMS");
                if (object == null) {
                    object = new DBMSPrincipalLoader();
                    this.addParentGroup.put("DBMS", object);
                }
                return (DBMSPrincipalLoader)object;
            }
            case 4: {
                Object object = this.addParentGroup.get("INPUT");
                if (object == null) {
                    object = new InputPrincipalLoader();
                    this.addParentGroup.put("INPUT", object);
                }
                return (InputPrincipalLoader)object;
            }
            case 5: {
                Object v = this.addParentGroup.get("SERVER_LOCAL");
                if (v == null) {
                    this.addSubGroup = (ServerPrincipalLoader)Class.forName("jet.server.jrc.security.cube.ServerPrincipalLoaderImpl").newInstance();
                    this.addParentGroup.put("SERVER_LOCAL", this.addSubGroup);
                }
                return this.addSubGroup;
            }
        }
        return null;
    }

    @Override
    public Vector[] getPrincipals() {
        Enumeration enumeration;
        if (this.addParentRole == 5 && this.addSubGroup != null) {
            return this.addSubGroup.getPrincipalNames();
        }
        Vector[] vectorArray = new Vector[3];
        vectorArray[0] = new Vector();
        if (this.addGroup != null) {
            enumeration = this.addGroup.elements();
            while (enumeration.hasMoreElements()) {
                vectorArray[0].add(enumeration.nextElement());
            }
        }
        vectorArray[1] = new Vector();
        if (this.SEDU != null) {
            enumeration = this.SEDU.elements();
            while (enumeration.hasMoreElements()) {
                vectorArray[1].add(enumeration.nextElement());
            }
        }
        vectorArray[2] = new Vector();
        if (this.add != null) {
            enumeration = this.add.elements();
            while (enumeration.hasMoreElements()) {
                vectorArray[2].add(enumeration.nextElement());
            }
        }
        return vectorArray;
    }

    @Override
    public Vector[] getPrincipalNames() {
        Enumeration enumeration;
        if (this.addParentRole == 5 && this.addSubGroup != null) {
            return this.addSubGroup.getPrincipalNames();
        }
        Vector[] vectorArray = new Vector[3];
        vectorArray[0] = new Vector();
        if (this.addGroup != null) {
            enumeration = this.addGroup.keys();
            while (enumeration.hasMoreElements()) {
                vectorArray[0].add(enumeration.nextElement());
            }
        }
        vectorArray[1] = new Vector();
        if (this.SEDU != null) {
            enumeration = this.SEDU.keys();
            while (enumeration.hasMoreElements()) {
                vectorArray[1].add(enumeration.nextElement());
            }
        }
        vectorArray[2] = new Vector();
        if (this.add != null) {
            enumeration = this.add.keys();
            while (enumeration.hasMoreElements()) {
                vectorArray[2].add(enumeration.nextElement());
            }
        }
        return vectorArray;
    }

    @Override
    public Principal getPrincipal(String string, int n) {
        if (this.addParentRole == 5 && this.addSubGroup != null) {
            return this.addSubGroup.getPrincipal(string, n);
        }
        if (string != null) {
            switch (n) {
                case 0: {
                    if (this.SEDU == null) break;
                    return (JRRole)this.SEDU.get(string);
                }
                case 1: {
                    if (this.add == null) break;
                    return (JRGroup)this.add.get(string);
                }
                case 2: {
                    if (this.addGroup == null) break;
                    return (JRUser)this.addGroup.get(string);
                }
            }
        }
        return null;
    }

    @Override
    public void setRoles(Hashtable hashtable) {
        this.SEDU = hashtable;
    }

    @Override
    public void setGroups(Hashtable hashtable) {
        this.add = hashtable;
    }

    @Override
    public void setUsers(Hashtable hashtable) {
        this.addGroup = hashtable;
    }

    @Override
    public int getLoaderType() {
        return this.addParentRole;
    }

    @Override
    public Properties getLoaderProperties() {
        return this.addRole;
    }

    @Override
    public void setLoaderProperties(Properties properties) {
        this.addRole = properties;
    }

    @Override
    public BaseRole getRole(String string) {
        JRRole jRRole = (JRRole)this.getPrincipal(string, 0);
        BaseRoleImpl baseRoleImpl = null;
        if (jRRole != null) {
            baseRoleImpl = new BaseRoleImpl();
            baseRoleImpl.setName(string);
            for (Principal principal : jRRole.getParents()) {
                baseRoleImpl.addParentRole(principal.getName());
            }
            for (Principal principal : jRRole.getSubGroups()) {
                baseRoleImpl.addGroup(((JRPrincipal)principal).getName());
            }
            for (Principal principal : jRRole.getSubRoles()) {
                baseRoleImpl.addSubRole(((JRPrincipal)principal).getName());
            }
            for (Principal principal : jRRole.getSubUsers()) {
                baseRoleImpl.addSubUser(((JRPrincipal)principal).getName());
            }
        }
        return baseRoleImpl;
    }

    @Override
    public BaseUser getUser(String string) {
        JRUser jRUser = (JRUser)this.getPrincipal(string, 2);
        BaseUserImpl baseUserImpl = null;
        if (jRUser != null) {
            baseUserImpl = new BaseUserImpl();
            baseUserImpl.setName(string);
            baseUserImpl.setEmail(baseUserImpl.getEmail());
            for (JRGroup jRPrincipal : jRUser.getGroups()) {
                baseUserImpl.addGroup(jRPrincipal.getName());
            }
            for (JRPrincipal jRPrincipal : jRUser.getRoles()) {
                baseUserImpl.addParentRole(jRPrincipal.getName());
            }
        }
        return baseUserImpl;
    }

    @Override
    public BaseGroup getGroup(String string) {
        JRGroup jRGroup = (JRGroup)this.getPrincipal(string, 1);
        BaseGroupImpl baseGroupImpl = null;
        if (jRGroup != null) {
            baseGroupImpl = new BaseGroupImpl();
            baseGroupImpl.setName(string);
            for (JRGroup jRPrincipal : jRGroup.getParentGroups()) {
                baseGroupImpl.addParentGroup(jRPrincipal.getName());
            }
            for (JRPrincipal jRPrincipal : jRGroup.getRoles()) {
                baseGroupImpl.addRole(jRPrincipal.getName());
            }
            for (JRPrincipal jRPrincipal : jRGroup.getSubGroups()) {
                baseGroupImpl.addSubGroup(jRPrincipal.getName());
            }
            for (JRPrincipal jRPrincipal : jRGroup.getSubUsers()) {
                baseGroupImpl.addUser(jRPrincipal.getName());
            }
        }
        return baseGroupImpl;
    }
}

