/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.control;

import com.jinfonet.security.control.JRGroup;
import com.jinfonet.security.control.JRPrincipal;
import com.jinfonet.security.control.JRUser;
import java.security.Principal;
import java.util.Vector;

public class JRRole
extends JRPrincipal {
    private Vector parents = new Vector();
    private Vector subRoles = new Vector();
    private Vector groups = new Vector();
    private Vector users = new Vector();

    public JRRole(String string, String string2) {
        super(string, string2);
    }

    @Override
    public int getPrincipalType() {
        return 0;
    }

    @Override
    public void addParent(Principal principal) {
        if (principal == null) {
            return;
        }
        if (principal instanceof JRRole) {
            this.parents.add(principal);
            ((JRRole)principal).addSubPrincipal(principal);
        }
    }

    public void addSubPrincipal(Principal principal) {
        if (principal instanceof JRRole) {
            this.subRoles.add((JRRole)principal);
        } else if (principal instanceof JRGroup) {
            this.groups.add((JRGroup)principal);
        } else if (principal instanceof JRUser) {
            this.users.add((JRUser)principal);
        }
    }

    @Override
    public void removeParent(Principal principal) {
        if (principal instanceof JRRole) {
            this.parents.remove(principal);
            ((JRRole)principal).removeSubPrincipal(this);
        }
    }

    public void removeSubPrincipal(Principal principal) {
        if (principal instanceof JRGroup) {
            this.groups.remove((JRGroup)principal);
        } else if (principal instanceof JRUser) {
            this.users.remove((JRUser)principal);
        }
    }

    @Override
    public Principal[] getParents() {
        Principal[] principalArray = new Principal[this.parents.size()];
        for (int i = 0; i < this.parents.size(); ++i) {
            principalArray[i] = (Principal)this.parents.elementAt(i);
        }
        return principalArray;
    }

    public JRRole[] getSubRoles() {
        JRRole[] jRRoleArray = this.subRoles.toArray(new JRRole[0]);
        return jRRoleArray;
    }

    public JRGroup[] getSubGroups() {
        JRGroup[] jRGroupArray = this.groups.toArray(new JRGroup[0]);
        return jRGroupArray;
    }

    public JRUser[] getSubUsers() {
        JRUser[] jRUserArray = this.users.toArray(new JRUser[0]);
        return jRUserArray;
    }
}

