/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.control;

import com.jinfonet.security.control.JRGroup;
import com.jinfonet.security.control.JRPrincipal;
import com.jinfonet.security.control.JRRole;
import java.security.Principal;
import java.util.Vector;

public class JRUser
extends JRPrincipal {
    private String email;
    private Vector parents = new Vector();
    private Vector groups = new Vector();
    private Vector roles = new Vector();

    public JRUser(String string, String string2) {
        super(string, string2);
    }

    public String getEmail() {
        if (this.email == null) {
            return "";
        }
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    @Override
    public int getPrincipalType() {
        return 2;
    }

    @Override
    public void addParent(Principal principal) {
        if (principal == null) {
            return;
        }
        this.parents.add(principal);
        if (principal instanceof JRGroup) {
            this.groups.add((JRGroup)principal);
            ((JRGroup)principal).addSubPrincipal(this);
        } else if (principal instanceof JRRole) {
            this.roles.add((JRRole)principal);
            ((JRRole)principal).addSubPrincipal(principal);
        }
    }

    @Override
    public void removeParent(Principal principal) {
        this.parents.remove(principal);
        if (principal instanceof JRGroup) {
            this.groups.remove(principal);
        } else if (principal instanceof JRRole) {
            this.roles.remove(principal);
        }
    }

    @Override
    public Principal[] getParents() {
        Principal[] principalArray = new Principal[this.parents.size()];
        for (int i = 0; i < this.parents.size(); ++i) {
            principalArray[i] = (Principal)this.parents.elementAt(i);
        }
        return principalArray;
    }

    public JRGroup[] getGroups() {
        JRGroup[] jRGroupArray = this.groups.toArray(new JRGroup[0]);
        return jRGroupArray;
    }

    public JRRole[] getRoles() {
        JRRole[] jRRoleArray = this.roles.toArray(new JRRole[0]);
        return jRRoleArray;
    }
}

