/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.control.xml;

import com.jinfonet.security.control.JRGroup;
import com.jinfonet.security.control.JRPrincipal;
import com.jinfonet.security.control.JRRole;
import com.jinfonet.security.control.JRUser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InputPrincipalsXMLReader
extends DefaultHandler {
    public Vector users = new Vector();
    public Vector roles = new Vector();
    public Vector groups = new Vector();
    private int ReaderFile;
    private int SEDU;
    protected final State rootTag = new RootTag();
    protected final StateImpl userTag = new StateImpl("user");
    protected final StateImpl roleTag = new StateImpl("role");
    protected final StateImpl groupTag = new StateImpl("group");
    protected State state = this.rootTag;
    private Hashtable add = new Hashtable();
    private Hashtable addParent = new Hashtable();
    private Hashtable characters = new Hashtable();
    private Hashtable containsKey = new Hashtable();
    private Hashtable elements = new Hashtable();
    private Hashtable endElement = new Hashtable();
    private Hashtable exists = new Hashtable();
    private Hashtable get = new Hashtable();

    public static Vector[] importFromFile(String string) throws IOException, SAXException, ParserConfigurationException {
        InputPrincipalsXMLReader inputPrincipalsXMLReader = new InputPrincipalsXMLReader(4);
        inputPrincipalsXMLReader.ReaderFile(string, true);
        Vector[] vectorArray = new Vector[]{inputPrincipalsXMLReader.users, inputPrincipalsXMLReader.roles, inputPrincipalsXMLReader.groups};
        return vectorArray;
    }

    public InputPrincipalsXMLReader(int n) {
        this.ReaderFile = n;
        this.userTag.parentGroups = this.containsKey;
        this.userTag.parentRoles = this.elements;
        this.groupTag.parentGroups = this.endElement;
        this.groupTag.parentRoles = this.exists;
        this.roleTag.parentRoles = this.get;
        this.roleTag.parentGroups = new Hashtable();
    }

    public void ReaderFile(String string) throws IOException, SAXException, ParserConfigurationException {
        this.ReaderFile(string, false);
    }

    private void ReaderFile(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string);
            JRPrincipal jRPrincipal = (JRPrincipal)hashtable2.get(string);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                jRPrincipal.addParent((JRPrincipal)hashtable3.get(string2));
            }
        }
    }

    public void ReaderFile(String string, boolean bl) throws IOException, SAXException, ParserConfigurationException {
        if (string == null) {
            this.roles.add(new JRRole("everyone", ""));
            return;
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        File file = new File(string);
        if (!file.exists()) {
            this.roles.add(new JRRole("everyone", ""));
            return;
        }
        sAXParser.parse(new File(string), (DefaultHandler)this);
        if (!bl && this.ReaderFile != this.SEDU) {
            this.users = new Vector();
            this.roles = new Vector();
            this.roles.add(new JRRole("everyone", ""));
            this.groups = new Vector();
            this.add = new Hashtable();
            this.addParent = new Hashtable();
            this.characters = new Hashtable();
            return;
        }
        this.ReaderFile(this.containsKey, this.add, this.characters);
        this.ReaderFile(this.elements, this.add, this.addParent);
        this.ReaderFile(this.endElement, this.characters, this.characters);
        this.ReaderFile(this.exists, this.characters, this.addParent);
        this.ReaderFile(this.get, this.addParent, this.addParent);
        Enumeration enumeration = this.add.elements();
        while (enumeration.hasMoreElements()) {
            this.users.add(enumeration.nextElement());
        }
        Enumeration enumeration2 = this.addParent.elements();
        while (enumeration2.hasMoreElements()) {
            this.roles.add(enumeration2.nextElement());
        }
        if (!this.addParent.containsKey("everyone")) {
            this.roles.add(new JRRole("everyone", ""));
        }
        Enumeration enumeration3 = this.characters.elements();
        while (enumeration3.hasMoreElements()) {
            this.groups.add(enumeration3.nextElement());
        }
    }

    public void ReaderInputStream(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputStream, (DefaultHandler)this);
        Enumeration enumeration = this.add.elements();
        while (enumeration.hasMoreElements()) {
            this.users.add(enumeration.nextElement());
        }
        Enumeration enumeration2 = this.addParent.elements();
        while (enumeration2.hasMoreElements()) {
            this.roles.add(enumeration2.nextElement());
        }
        Enumeration enumeration3 = this.characters.elements();
        while (enumeration3.hasMoreElements()) {
            this.groups.add(enumeration3.nextElement());
        }
    }

    public Vector[] getPrincipals() {
        Vector[] vectorArray = new Vector[]{this.users, this.roles, this.groups};
        return vectorArray;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.state = this.state.startElement(string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.state = this.state.endElement(string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.state = this.state.characters(cArray, n, n2);
    }

    public static int parseInt(String string, int n) {
        int n2 = n;
        if (string != null && string.length() > 0) {
            try {
                n2 = Integer.parseInt(string.trim(), 10);
            }
            catch (Exception exception) {
                n2 = n;
            }
        }
        return n2;
    }

    static interface State {
        public State startElement(String var1, Attributes var2) throws SAXException;

        public State endElement(String var1) throws SAXException;

        public State characters(char[] var1, int var2, int var3) throws SAXException;
    }

    class RootTag
    extends StateImpl
    implements State {
        public RootTag() {
            this.principalType = "jreport-principals";
        }

        @Override
        public State startElement(String string, Attributes attributes) throws SAXException {
            if (string.equals("jreport-principals")) {
                String string2 = attributes.getValue("load-type");
                try {
                    InputPrincipalsXMLReader.this.SEDU = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    InputPrincipalsXMLReader.this.SEDU = 4;
                }
                return this;
            }
            return super.startElement(string, attributes);
        }

        @Override
        public State endElement(String string) throws SAXException {
            if (string.equalsIgnoreCase(this.principalType)) {
                return this;
            }
            throw new SAXException("Exception at end tag " + this.principalType);
        }
    }

    class StateImpl
    implements State {
        String principalType = "";
        String principalName = null;
        Hashtable parentGroups = null;
        Hashtable parentRoles = null;

        public StateImpl() {
        }

        public StateImpl(String string) {
            this.principalType = string;
        }

        @Override
        public State startElement(String string, Attributes attributes) throws SAXException {
            if (string.equals("user")) {
                String string2;
                InputPrincipalsXMLReader.this.userTag.principalName = string2 = attributes.getValue("username");
                String string3 = attributes.getValue("description");
                String string4 = attributes.getValue("email");
                String string5 = attributes.getValue("sourcetype");
                JRUser jRUser = new JRUser(string2, string3);
                jRUser.setEmail(string4);
                jRUser.setSourceType(InputPrincipalsXMLReader.parseInt(string5, 0));
                if (!InputPrincipalsXMLReader.this.add.containsKey(string2)) {
                    InputPrincipalsXMLReader.this.add.put(string2, jRUser);
                }
                return InputPrincipalsXMLReader.this.userTag;
            }
            if (string.equals("group")) {
                String string6;
                InputPrincipalsXMLReader.this.groupTag.principalName = string6 = attributes.getValue("groupname");
                String string7 = attributes.getValue("description");
                String string8 = attributes.getValue("sourcetype");
                JRGroup jRGroup = new JRGroup(string6, string7);
                jRGroup.setSourceType(InputPrincipalsXMLReader.parseInt(string8, 0));
                if (!InputPrincipalsXMLReader.this.characters.containsKey(string6)) {
                    InputPrincipalsXMLReader.this.characters.put(string6, jRGroup);
                }
                return InputPrincipalsXMLReader.this.groupTag;
            }
            if (string.equals("role")) {
                String string9;
                InputPrincipalsXMLReader.this.roleTag.principalName = string9 = attributes.getValue("rolename");
                String string10 = attributes.getValue("description");
                String string11 = attributes.getValue("sourcetype");
                JRRole jRRole = new JRRole(string9, string10);
                jRRole.setSourceType(InputPrincipalsXMLReader.parseInt(string11, 0));
                if (!InputPrincipalsXMLReader.this.addParent.containsKey(string9)) {
                    InputPrincipalsXMLReader.this.addParent.put(string9, jRRole);
                }
                return InputPrincipalsXMLReader.this.roleTag;
            }
            if (string.equals("parent-group")) {
                String string12 = attributes.getValue("groupname");
                Vector<String> vector = (Vector<String>)this.parentGroups.get(this.principalName);
                if (vector == null) {
                    vector = new Vector<String>();
                    this.parentGroups.put(this.principalName, vector);
                }
                vector.add(string12);
                return this;
            }
            if (string.equals("parent-role")) {
                String string13 = attributes.getValue("rolename");
                Vector<String> vector = (Vector<String>)this.parentRoles.get(this.principalName);
                if (vector == null) {
                    vector = new Vector<String>();
                    this.parentRoles.put(this.principalName, vector);
                }
                vector.add(string13);
                return this;
            }
            throw new SAXException("Exception at begin tag " + this.principalType);
        }

        @Override
        public State endElement(String string) throws SAXException {
            if (string.equalsIgnoreCase("user") || string.equalsIgnoreCase("role") || string.equalsIgnoreCase("group") || string.equalsIgnoreCase("jreport-principals")) {
                this.principalName = null;
                return this;
            }
            if (string.equalsIgnoreCase("parent-group") || string.equalsIgnoreCase("parent-role")) {
                return this;
            }
            throw new SAXException("Exception at end tag " + this.principalType);
        }

        @Override
        public State characters(char[] cArray, int n, int n2) throws SAXException {
            return this;
        }
    }
}

