/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.security.control.xml;

import com.jinfonet.security.control.JRGroup;
import com.jinfonet.security.control.JRPrincipal;
import com.jinfonet.security.control.JRRole;
import com.jinfonet.security.control.JRUser;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.Principal;
import java.util.Vector;

public class InputPrincipalsXMLWriter {
    private Vector[] SEDU = new Vector[3];
    private int append;
    private StringBuffer charAt = new StringBuffer();

    public static void exportToFile(Vector[] vectorArray, String string, int n) throws UnsupportedEncodingException, IOException {
        InputPrincipalsXMLWriter inputPrincipalsXMLWriter = new InputPrincipalsXMLWriter(vectorArray, n);
        inputPrincipalsXMLWriter.writeXMLToFile(string);
    }

    public InputPrincipalsXMLWriter(Vector[] vectorArray, int n) {
        this.SEDU = vectorArray;
        this.append = n;
        this.writeSecInfo();
    }

    private void SEDU(StringBuffer stringBuffer, JRUser jRUser) {
        if (stringBuffer == null || jRUser == null) {
            return;
        }
        stringBuffer.append("\t<");
        stringBuffer.append("user");
        stringBuffer.append(" ");
        stringBuffer.append("username");
        stringBuffer.append("=\"");
        stringBuffer.append(this.elementAt(jRUser.getName()));
        stringBuffer.append("\"");
        stringBuffer.append(" ");
        stringBuffer.append("description");
        stringBuffer.append("=\"");
        stringBuffer.append(this.elementAt(jRUser.getDescription()));
        stringBuffer.append("\"");
        stringBuffer.append(" ");
        stringBuffer.append("email");
        stringBuffer.append("=\"");
        stringBuffer.append(this.elementAt(jRUser.getEmail()));
        stringBuffer.append("\"");
        stringBuffer.append(" ");
        stringBuffer.append("sourcetype");
        stringBuffer.append("=\"");
        stringBuffer.append(jRUser.getSourceType());
        stringBuffer.append("\"");
        if (jRUser.getParents().length == 0) {
            stringBuffer.append("/>\n");
        } else {
            stringBuffer.append(">\n");
            Principal[] principalArray = jRUser.getGroups();
            Principal[] principalArray2 = jRUser.getRoles();
            this.append(stringBuffer, principalArray, "parent-group", "groupname");
            this.append(stringBuffer, principalArray2, "parent-role", "rolename");
            stringBuffer.append("\t</user>\n");
        }
    }

    private void append(StringBuffer stringBuffer, Principal[] principalArray, String string, String string2) {
        for (Principal principal : principalArray) {
            stringBuffer.append("\t\t<");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append("=\"");
            stringBuffer.append(this.elementAt(principal.getName()));
            stringBuffer.append("\"");
            stringBuffer.append(" ");
            stringBuffer.append("/>\n");
        }
    }

    private void charAt(StringBuffer stringBuffer, JRRole jRRole) {
        if (stringBuffer == null || jRRole == null) {
            return;
        }
        stringBuffer.append("\t<");
        stringBuffer.append("role");
        stringBuffer.append(" ");
        stringBuffer.append("rolename");
        stringBuffer.append("=\"");
        stringBuffer.append(this.elementAt(jRRole.getName()));
        stringBuffer.append("\"");
        stringBuffer.append(" ");
        stringBuffer.append("description");
        stringBuffer.append("=\"");
        stringBuffer.append(this.elementAt(jRRole.getDescription()));
        stringBuffer.append("\"");
        stringBuffer.append(" ");
        stringBuffer.append("sourcetype");
        stringBuffer.append("=\"");
        stringBuffer.append(jRRole.getSourceType());
        stringBuffer.append("\"");
        if (jRRole.getParents().length == 0) {
            stringBuffer.append("/>\n");
        } else {
            stringBuffer.append(">\n");
            Principal[] principalArray = jRRole.getParents();
            this.append(stringBuffer, principalArray, "parent-role", "rolename");
            stringBuffer.append("\t</role>\n");
        }
    }

    private void close(StringBuffer stringBuffer, JRGroup jRGroup) {
        if (stringBuffer == null || jRGroup == null) {
            return;
        }
        stringBuffer.append("\t<");
        stringBuffer.append("group");
        stringBuffer.append(" ");
        stringBuffer.append("groupname");
        stringBuffer.append("=\"");
        stringBuffer.append(this.elementAt(jRGroup.getName()));
        stringBuffer.append("\"");
        stringBuffer.append(" ");
        stringBuffer.append("description");
        stringBuffer.append("=\"");
        stringBuffer.append(this.elementAt(jRGroup.getDescription()));
        stringBuffer.append("\"");
        stringBuffer.append(" ");
        stringBuffer.append("sourcetype");
        stringBuffer.append("=\"");
        stringBuffer.append(jRGroup.getSourceType());
        stringBuffer.append("\"");
        if (jRGroup.getParents().length == 0) {
            stringBuffer.append("/>\n");
        } else {
            stringBuffer.append(">\n");
            Principal[] principalArray = jRGroup.getParentGroups();
            Principal[] principalArray2 = jRGroup.getRoles();
            this.append(stringBuffer, principalArray, "parent-group", "groupname");
            this.append(stringBuffer, principalArray2, "parent-role", "rolename");
            stringBuffer.append("\t</group>\n");
        }
    }

    public void writeSecInfo() {
        JRPrincipal jRPrincipal;
        int n;
        Vector vector = this.SEDU[0];
        Vector vector2 = this.SEDU[1];
        Vector vector3 = this.SEDU[2];
        this.charAt.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.charAt.append("<jreport-principals").append(" ").append("load-type").append("=\"").append(this.append).append("\">\n");
        for (n = 0; n < vector.size(); ++n) {
            jRPrincipal = (JRUser)vector.elementAt(n);
            this.SEDU(this.charAt, (JRUser)jRPrincipal);
        }
        for (n = 0; n < vector3.size(); ++n) {
            jRPrincipal = (JRGroup)vector3.elementAt(n);
            this.close(this.charAt, (JRGroup)jRPrincipal);
        }
        for (n = 0; n < vector2.size(); ++n) {
            jRPrincipal = (JRRole)vector2.elementAt(n);
            this.charAt(this.charAt, (JRRole)jRPrincipal);
        }
        this.charAt.append("</jreport-principals>\n");
    }

    public void writeXMLToWriter(Writer writer) throws IOException {
        writer.write(this.charAt.toString());
        writer.close();
    }

    public void writeXMLToFile(String string) throws IOException, UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
        outputStreamWriter.write(this.charAt.toString());
        outputStreamWriter.close();
    }

    private String elementAt(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            string2 = c == '<' ? string2 + "&lt;" : (c == '&' ? string2 + "&amp;" : string2 + c);
        }
        return string2;
    }
}

