/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.util.gmap.impl;

import com.jinfonet.util.JRLog;
import com.jinfonet.util.gmap.api.GeoDictDB;
import com.jinfonet.util.gmap.api.GeoProxy;
import com.jinfonet.util.gmap.api.LatLng;
import com.jinfonet.util.gmap.impl.GeoDictDBimpl;
import com.jinfonet.util.gmap.impl.LatLngImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class GeoProxyImpl
extends Thread
implements GeoProxy {
    public static String GeoCoderServiceUrl = "http://maps.googleapis.com/maps/api/geocode/json?";
    private Proxy SECONDS;
    private GeoDictDB SEDU;
    LinkedBlockingQueue queryList;
    private boolean append = false;
    private boolean close = false;
    private Hashtable currentThread;

    public GeoProxyImpl(File file, Proxy proxy) throws URISyntaxException, UnknownHostException {
        this.SECONDS(proxy);
        this.SEDU = new GeoDictDBimpl(file);
        this.queryList = new LinkedBlockingQueue();
        this.currentThread = new Hashtable();
        this.start();
    }

    public GeoProxyImpl(File file, Proxy proxy, boolean bl) throws URISyntaxException, UnknownHostException {
        this.SECONDS(proxy);
        this.SEDU = new GeoDictDBimpl(file);
        if (!bl) {
            this.queryList = new LinkedBlockingQueue();
            this.currentThread = new Hashtable();
            this.start();
        }
        this.append = bl;
    }

    @Override
    public LatLng getLocation(String string) throws IOException {
        if (this.close) {
            throw new RuntimeException("GeoProxyImpl instance have be destroy!");
        }
        LatLng latLng = this.SEDU.getLocation(string);
        if (latLng != null) {
            return latLng;
        }
        if (this.append) {
            block6: {
                try {
                    latLng = this.getLocationByGeocoder(string);
                }
                catch (Throwable throwable) {
                    if (!JRLog.isError(2)) break block6;
                    JRLog.error(2, throwable);
                }
            }
            if (latLng != null) {
                this.SEDU.putLocation(string, latLng);
            }
            return latLng;
        }
        this.GeoCoderServiceUrl(string);
        return null;
    }

    private void GeoCoderServiceUrl(String string) throws IOException {
        try {
            this.queryList.put(string);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                Integer n;
                LatLngImpl latLngImpl;
                String string;
                block10: {
                    if (this.close && this.queryList.size() == 0) {
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "GeoProxyImpl run: this.geoDictDB.close()");
                        }
                        this.SEDU.close();
                        break;
                    }
                    string = (String)this.queryList.poll(30L, TimeUnit.SECONDS);
                    if (string == null) continue;
                    latLngImpl = null;
                    try {
                        n = (Integer)this.currentThread.get(string);
                        if (n != null && n > 3) continue;
                        latLngImpl = this.getLocationByGeocoder(string);
                    }
                    catch (Throwable throwable) {
                        if (!JRLog.isError(2)) break block10;
                        JRLog.error(2, throwable);
                    }
                }
                if (latLngImpl != null) {
                    this.SEDU.putLocation(string, latLngImpl);
                    continue;
                }
                n = (Integer)this.currentThread.get(string);
                if (n == null) {
                    n = 0;
                }
                int n2 = n;
                this.currentThread.put(string, ++n2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void destroy() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GeoProxyImpl destroy:");
        }
        if (this.append && JRLog.isTrace(6)) {
            JRLog.trace(6, "GeoProxyImpl destroy: this.geoDictDB.close()");
        }
        this.SEDU.close();
        this.close = true;
    }

    private void SECONDS(Proxy proxy) throws URISyntaxException, UnknownHostException {
        this.SECONDS = proxy != null ? proxy : null;
    }

    public LatLngImpl getLocationByGeocoder(String string) throws IOException, JSONException {
        InputStreamReader inputStreamReader;
        String string2 = GeoCoderServiceUrl + "address=" + URLEncoder.encode(string, "UTF-8") + "&sensor=false";
        URL uRL = new URL(string2);
        URLConnection uRLConnection = this.SECONDS != null ? uRL.openConnection(this.SECONDS) : uRL.openConnection();
        int n = ((HttpURLConnection)uRLConnection).getResponseCode();
        if (n != 200) {
            return null;
        }
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        JSONTokener jSONTokener = new JSONTokener((Reader)inputStreamReader);
        JSONObject jSONObject = new JSONObject(jSONTokener);
        if (!"OK".equals(jSONObject.getString("status"))) {
            return null;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("results");
        if (jSONArray != null && jSONArray.length() > 0) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(0);
            JSONObject jSONObject3 = jSONObject2.getJSONObject("geometry").getJSONObject("location");
            LatLngImpl latLngImpl = new LatLngImpl((float)jSONObject3.getDouble("lat"), (float)jSONObject3.getDouble("lng"));
            return latLngImpl;
        }
        return null;
    }

    public static void main(String[] stringArray) throws URISyntaxException, IOException, InterruptedException {
        File file = new File("C:\\test.xml");
        GeoProxyImpl geoProxyImpl = new GeoProxyImpl(file, null);
        LatLng latLng = geoProxyImpl.getLocation("KM");
        System.out.println(latLng);
        Thread.currentThread();
        Thread.sleep(60000L);
        latLng = geoProxyImpl.getLocation("KM");
        System.out.println(latLng);
        geoProxyImpl.destroy();
        System.out.println(latLng);
    }
}

