/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.util.gmap.impl;

import com.jinfonet.util.JRLog;
import com.jinfonet.util.gmap.api.ConfigurationGeoMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

public class JRConfigurationGeoMap
implements ConfigurationGeoMap {
    public static final String XML_FILE = "mapConfiguration.xml";
    public static final String homePathkey = "reporthome";
    public static final String installrootkey = "install.root";
    public static final String binPathStr = "bin";
    private String reportBinPath = null;
    private static JRConfigurationGeoMap uniqueInstance = null;
    private GeoMapServiceConfiguration cfg = new GeoMapServiceConfiguration();

    private JRConfigurationGeoMap() {
        if (this.reportBinPath == null) {
            this.reportBinPath = this.getReportBinPath();
        }
        this.loadConfig();
    }

    private JRConfigurationGeoMap(String binPath) {
        this.reportBinPath = binPath;
        this.loadConfig();
    }

    public static synchronized JRConfigurationGeoMap getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new JRConfigurationGeoMap();
        }
        return uniqueInstance;
    }

    public static synchronized JRConfigurationGeoMap getInstance(String reportBinPath) {
        if (uniqueInstance == null) {
            uniqueInstance = new JRConfigurationGeoMap(reportBinPath);
        }
        return uniqueInstance;
    }

    private String getReportBinPath() {
        String homePath;
        String libPath;
        block10: {
            String strRoot;
            String originalHomePath;
            block9: {
                libPath = null;
                homePath = null;
                originalHomePath = null;
                String strHome = System.getProperty(homePathkey);
                if (strHome != null) {
                    try {
                        originalHomePath = strHome;
                        homePath = new File(originalHomePath).getCanonicalPath();
                    }
                    catch (IOException e) {
                        if (!JRLog.isError(3)) break block9;
                        JRLog.error(3, e);
                    }
                }
            }
            if (homePath == null && (strRoot = System.getProperty(installrootkey)) != null) {
                try {
                    originalHomePath = strRoot;
                    homePath = new File(originalHomePath).getCanonicalPath();
                }
                catch (IOException e) {
                    if (!JRLog.isError(3)) break block10;
                    JRLog.error(3, e);
                }
            }
        }
        if (homePath == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "system properties have not been defined yet. \nTry\"java -Dreporthome=path ...\"");
            }
            return null;
        }
        if (!homePath.endsWith(File.separator)) {
            homePath = homePath + File.separator;
        }
        libPath = homePath + binPathStr + File.separator;
        return libPath;
    }

    private synchronized void loadConfig() {
        try {
            this.cfg = (GeoMapServiceConfiguration)JAXBContext.newInstance((Class[])new Class[]{GeoMapServiceConfiguration.class}).createUnmarshaller().unmarshal(new File(this.reportBinPath, XML_FILE));
        }
        catch (Throwable t) {
            this.cfg = new GeoMapServiceConfiguration();
            JRLog.error(2, t);
        }
        JRLog.trace(5, "Load GeoMapConfiguration: " + this.cfg);
        System.out.println(this.cfg);
    }

    private GeoMapService getMapService(int mapType) {
        for (GeoMapService s : this.cfg.getGeoMapServices()) {
            if (s.getMapType() != mapType) continue;
            return s;
        }
        return null;
    }

    @Override
    public ConfigurationGeoMap.MapServicePolicy getMapServicePolicy() {
        return this.cfg.getPolicy();
    }

    @Override
    public List<List<String>> getMapServiceAddresses(int mapType, ConfigurationGeoMap.MapServicePolicy policy) {
        if (policy == null) {
            return null;
        }
        GeoMapService m = this.getMapService(mapType);
        if (m == null) {
            return null;
        }
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        switch (policy) {
            case INTRANET_SERVICE_ONLY: {
                ret.add(m.getIntranetAddresses());
                break;
            }
            case INTERNET_SERVICE_ONLY: {
                ret.add(m.getInternetAddresses());
                break;
            }
            case INTRANET_SERVICE_FIRST: {
                ret.add(m.getIntranetAddresses());
                ret.add(m.getInternetAddresses());
                break;
            }
            case INTERNET_SERVICE_FIRST: {
                ret.add(m.getInternetAddresses());
                ret.add(m.getIntranetAddresses());
                break;
            }
        }
        return ret;
    }

    @Override
    public String getMapServiceProperty(int mapType, String propName) {
        GeoMapService m = this.getMapService(mapType);
        if (m == null || propName == null) {
            return null;
        }
        for (Property p : m.getProperties()) {
            if (!propName.equals(p.getName())) continue;
            return p.getValue();
        }
        return null;
    }

    @Override
    public Map<String, String> getMapServiceProperties(int mapType) {
        GeoMapService m = this.getMapService(mapType);
        if (m == null) {
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Property p : m.getProperties()) {
            ret.put(p.getName(), p.getValue());
        }
        return ret;
    }

    @XmlRootElement(name="property")
    protected static class Property {
        @XmlAttribute(name="name")
        protected String name;
        @XmlValue
        protected String value;

        protected Property() {
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }

    @XmlRootElement(name="geoMapService")
    protected static class GeoMapService {
        @XmlAttribute(name="mapType")
        protected int mapType = 0;
        @XmlElement(name="description")
        protected String description = "";
        @XmlElementWrapper(name="intranetAddresses")
        @XmlElement(name="url")
        protected List<String> intranetAddresses = new ArrayList<String>();
        @XmlElementWrapper(name="internetAddresses")
        @XmlElement(name="url")
        protected List<String> internetAddresses = new ArrayList<String>();
        @XmlElementWrapper(name="properties")
        @XmlElementRef
        protected List<Property> properties = new ArrayList<Property>();

        protected GeoMapService() {
        }

        public int getMapType() {
            return this.mapType;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getIntranetAddresses() {
            return this.intranetAddresses;
        }

        public List<String> getInternetAddresses() {
            return this.internetAddresses;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public String toString() {
            return "{" + "mapType=" + this.getMapType() + ", description=" + this.getDescription() + ", intranet=" + this.getIntranetAddresses() + ", internet=" + this.getInternetAddresses() + ", properties=" + this.getProperties() + "}";
        }
    }

    @XmlRootElement(name="geoMapServiceConfiguration")
    protected static class GeoMapServiceConfiguration {
        @XmlAttribute(name="policy")
        protected ConfigurationGeoMap.MapServicePolicy policy = ConfigurationGeoMap.MapServicePolicy.OFF;
        @XmlElementRef(name="geoMapServices")
        protected List<GeoMapService> geoMapServices = new ArrayList<GeoMapService>();

        protected GeoMapServiceConfiguration() {
        }

        public ConfigurationGeoMap.MapServicePolicy getPolicy() {
            return this.policy;
        }

        public List<GeoMapService> getGeoMapServices() {
            return this.geoMapServices;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":" + "policy=" + (Object)((Object)this.getPolicy()) + ", geoMapServices=" + this.getGeoMapServices();
        }
    }
}

