/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.util.inspectortree;

import com.jinfonet.util.inspectortree.IElementNodeCreator;
import com.jinfonet.util.inspectortree.IElementTreeNode;
import com.jinfonet.util.inspectortree.NodeBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.ireport.IReport;
import jet.ireport.IRptBody;
import jet.lc.LCBody;
import jet.lc.LCConfiguration;
import jet.lc.LCContent;
import jet.lc.LCDataSource;
import jet.lc.LCObject;
import jet.lc.LCPrintPage;
import jet.lc.impl.JetLCRefreshObj;
import jet.lc.logic.LCLogicFactory;
import jet.report.JetRptCTAggField;
import jet.report.JetRptForm;
import jet.report.JetRptGroupFilter;
import jet.report.JetRptMap;
import jet.report.JetRptObject;
import jet.report.JetRptPageBreaker;
import jet.report.JetRptPageEnd;
import jet.report.JetRptPagePanel;
import jet.report.JetRptPageStart;
import jet.report.JetRptReportBody;
import jet.report.chart.JetRptChartGroupRect;
import jet.report.chart.JetRptChartGroupRectTitle;
import jet.report.chart.JetRptChartOrgLine;
import jet.report.chart.JetRptChartOrgNode;
import jet.report.geomap.JetRptGeoArea;
import jet.report.geomap.JetRptGeoGroup;
import jet.report.geomap.JetRptGeoMap;
import jet.report.geomap.JetRptGeoMarker;
import jet.report.paragraph.build.JetRptParaReplaceElement;
import jet.report.paragraph.build.JetRptParagraph;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableColGroup;
import jet.reportLogic.objectLogic.FormLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.DataSet;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;

public class ElementTreeNodeBuilderImpl
implements NodeBuilder {
    private JetRptReportSet SEDU;
    private JetObject add;
    private HashMap addAll;
    private Class[] addElement = new Class[0];
    private IElementNodeCreator append;

    public ElementTreeNodeBuilderImpl(JetRptReportSet jetRptReportSet, JetObject jetObject, IElementNodeCreator iElementNodeCreator) {
        this.SEDU = jetRptReportSet;
        this.add = jetObject;
        this.addAll = new HashMap();
        this.append = iElementNodeCreator;
    }

    public ElementTreeNodeBuilderImpl(JetObject jetObject, IElementNodeCreator iElementNodeCreator) {
        this((JetRptReportSet)ObjectLogicFactory.getBasicComponentLogic().getAncestorComponentByClass(jetObject, JetRptReportSet.class), jetObject, iElementNodeCreator);
    }

    public Class[] getDisabledNodeClass() {
        return this.addElement;
    }

    public void setDisabledNodeClass(Class[] classArray) {
        if (classArray == null) {
            classArray = new Class[]{};
        }
        this.addElement = classArray;
    }

    @Override
    public void setRoot(Class clazz) {
        if (clazz == JetRptReportSet.class) {
            if (this.SEDU != null) {
                this.add = this.SEDU;
            }
        } else if (clazz == JetRptReport.class) {
            if (this.SEDU != null) {
                this.add = this.SEDU.getCurReport();
            }
        } else if (clazz == JetRptReportBody.class && this.SEDU != null) {
            this.add = (JetRptObject)this.SEDU.getCurReport().getChildren().get(0);
        }
    }

    @Override
    public IElementTreeNode getElementTreeNode() {
        if (this.add instanceof JetRptReportSet) {
            IElementTreeNode iElementTreeNode = this.SEDU((JetRptReportSet)this.add);
            this.add = ((JetRptReportSet)this.add).getCurReport();
            IElementTreeNode iElementTreeNode2 = this.append(this.add);
            IElementTreeNode iElementTreeNode3 = this.addAll(iElementTreeNode2);
            iElementTreeNode.add(iElementTreeNode3);
            return iElementTreeNode;
        }
        if (this.add instanceof LCObject) {
            IElementTreeNode iElementTreeNode;
            IElementTreeNode iElementTreeNode4 = this.append(this.add);
            if (iElementTreeNode4.getChildCount() > 1) {
                iElementTreeNode4.insertNode(iElementTreeNode4.getChildNodeAt(1), 0);
            }
            if (this.elementAt(iElementTreeNode = this.append.create(this.add, "wrapper", true))) {
                iElementTreeNode.setDisabled(true);
            }
            iElementTreeNode4.insertNode(iElementTreeNode, 0);
            iElementTreeNode4.setShowProperties(false);
            iElementTreeNode.setEditabled(false);
            return iElementTreeNode4;
        }
        IElementTreeNode iElementTreeNode = this.append(this.add);
        IElementTreeNode iElementTreeNode5 = this.addAll(iElementTreeNode);
        return iElementTreeNode5;
    }

    private IElementTreeNode SEDU(JetRptReportSet jetRptReportSet) {
        IElementTreeNode iElementTreeNode = null;
        if (jetRptReportSet != null) {
            iElementTreeNode = this.append.create(this.SEDU, jetRptReportSet.getInstName(), true);
        }
        return iElementTreeNode;
    }

    private String add(JetObject jetObject) {
        if (jetObject instanceof JetRptObject) {
            String string;
            String string2 = string = ((JetRptObject)jetObject).displayName.get() != null && !((JetRptObject)jetObject).displayName.get().trim().equals("") ? ((JetRptObject)jetObject).getDisplayName() : jetObject.getInstName();
            if (jetObject instanceof JetRptChartOrgNode) {
                return "Node";
            }
            if (jetObject instanceof JetRptChartOrgLine) {
                return "Line";
            }
            if (jetObject instanceof JetRptChartGroupRect) {
                return "Rectangle" + ElementTreeNodeBuilderImpl.getTextSuffixNumber(string);
            }
            if (jetObject instanceof JetRptChartGroupRectTitle) {
                return "Rectangle Title" + ElementTreeNodeBuilderImpl.getTextSuffixNumber(string);
            }
            return string;
        }
        if (jetObject instanceof LCConfiguration) {
            return "Configuration";
        }
        if (jetObject instanceof LCBody) {
            return "Body";
        }
        if (jetObject instanceof LCContent) {
            return "Contents";
        }
        if (jetObject instanceof LCDataSource) {
            return "Data Source";
        }
        if (jetObject instanceof LCPrintPage) {
            return "Page Panel";
        }
        return jetObject.getInstName();
    }

    public static String getTextSuffixNumber(String string) {
        String string2 = "";
        char[] cArray = string.toCharArray();
        for (int i = cArray.length - 1; i >= 0 && (Character.isDigit(cArray[i]) || Character.isSpaceChar(cArray[i])); --i) {
            string2 = cArray[i] + string2;
        }
        try {
            String string3 = string2;
            Integer.parseInt(string2.trim());
            return string3;
        }
        catch (Exception exception) {
            string2 = "";
            return string2;
        }
    }

    private IElementTreeNode addAll(IElementTreeNode iElementTreeNode) {
        if (this.append.isWebReport()) {
            return iElementTreeNode;
        }
        if (this.add instanceof JetRptReport) {
            DataSet[] dataSetArray;
            IElementTreeNode iElementTreeNode2 = null;
            if (this.SEDU.getDataSets() != null) {
                iElementTreeNode2 = this.append.create(this.SEDU.getDataSets(), this.add(this.SEDU.getDataSets()), true);
                iElementTreeNode.add(iElementTreeNode2);
            }
            if ((dataSetArray = this.equals(this.add)) != null) {
                for (int i = 0; i < dataSetArray.length; ++i) {
                    JetRptDataSet jetRptDataSet = (JetRptDataSet)dataSetArray[i];
                    if (jetRptDataSet == null) continue;
                    IElementTreeNode iElementTreeNode3 = this.append.create(jetRptDataSet, this.add(jetRptDataSet), true);
                    iElementTreeNode2.add(iElementTreeNode3);
                }
            }
        }
        return iElementTreeNode;
    }

    private IElementTreeNode addElement(IElementTreeNode iElementTreeNode) {
        if (iElementTreeNode.getUserObject() instanceof LCDataSource) {
            Object object;
            LCDataSource lCDataSource = (LCDataSource)iElementTreeNode.getUserObject();
            List list = LCLogicFactory.getLCObjectLogic().getBodyCurrentUsedDataSetsIn(lCDataSource);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                object = (JetRptDataSet)list.get(i);
                if (object == null) continue;
                IElementTreeNode iElementTreeNode2 = this.append.create((JetObject)object, this.add((JetObject)object), true);
                iElementTreeNode.add(iElementTreeNode2);
            }
            String string = "RefreshObject";
            object = LCLogicFactory.getLCObjectLogic().getRefreshObjectList((LCObject)((Object)this.add));
            Collections.sort(object, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((JetLCRefreshObj)object).getInstName().compareTo(((JetLCRefreshObj)object2).getInstName());
                }
            });
            for (int i = 0; i < object.size(); ++i) {
                JetLCRefreshObj jetLCRefreshObj = (JetLCRefreshObj)object.get(i);
                IElementTreeNode iElementTreeNode3 = this.append.create(jetLCRefreshObj, i == 0 ? string : string + i, true);
                iElementTreeNode.add(iElementTreeNode3);
            }
        }
        return iElementTreeNode;
    }

    public boolean isNum(String string) {
        return string.substring(12) != null && !string.substring(12).equals("");
    }

    private IElementTreeNode append(JetObject jetObject) {
        Vector<JetObject> vector;
        if (jetObject instanceof JetRptGroupFilter) {
            return null;
        }
        IElementTreeNode iElementTreeNode = null;
        String string = "";
        FormLogic formLogic = ObjectLogicFactory.getFormLogic();
        JetRptPageStart jetRptPageStart = null;
        if (jetObject instanceof JetRptPageStart) {
            jetRptPageStart = (JetRptPageStart)jetObject;
            jetObject = jetRptPageStart.getPagePanel();
        }
        if (jetObject instanceof JetRptReport) {
            vector = (JetRptReport)jetObject;
            int n = 1;
            if (this.SEDU.getAllReportsName().length > 1) {
                n = 0;
            }
            ((JetObject)((Object)vector)).nameToProperty("PortletReport").setEditFlag(n);
        }
        if (jetObject instanceof JetContainable || jetObject instanceof JetRptForm) {
            int n;
            Object object;
            iElementTreeNode = this.append.create(jetObject, this.add(jetObject), true);
            vector = null;
            if (jetObject instanceof JetContainable) {
                if (jetObject.getClass().equals(JetRptPagePanel.class)) {
                    vector = new Vector<JetObject>(2);
                    if (((JetRptPagePanel)jetObject).getHeaders().size() > 0) {
                        vector.addAll(((JetRptPagePanel)jetObject).getHeaders());
                    }
                    if (((JetRptPagePanel)jetObject).getFooters().size() > 0) {
                        vector.addAll(((JetRptPagePanel)jetObject).getFooters());
                    }
                } else if (jetObject instanceof LCDataSource) {
                    iElementTreeNode = this.addElement(iElementTreeNode);
                } else {
                    vector = jetRptPageStart != null ? this.displayName(jetRptPageStart) : ((JetContainable)((Object)jetObject)).getChildren();
                }
                if (jetObject instanceof JetRptNewTable) {
                    JetRptTableColGroup jetRptTableColGroup = ((JetRptNewTable)jetObject).getTableColumnGroup();
                    object = new Vector<JetObject>(2);
                    for (int i = 0; i < vector.size(); ++i) {
                        ((Vector)object).addElement((JetObject)vector.get(i));
                    }
                    ((Vector)object).addElement(jetRptTableColGroup);
                    vector = object;
                }
            } else if (jetObject instanceof JetRptForm) {
                vector = formLogic.getFromContainObjects((JetRptForm)jetObject);
            }
            int n2 = n = vector == null ? 0 : vector.size();
            if (jetObject instanceof JetRptMap) {
                n = 0;
            }
            if (n > 0) {
                object = null;
                for (int i = 0; i < n; ++i) {
                    JetObject jetObject2 = (JetObject)vector.elementAt(i);
                    if (jetObject2 instanceof JetRptParaReplaceElement && jetObject2.getChildren().size() > 0) {
                        jetObject2 = (JetObject)jetObject2.getChildren().get(0);
                    }
                    if (this.addAll.get(jetObject2) != null || !jetObject2.canBeBrowse() || jetObject2 instanceof JetRptPageEnd) continue;
                    object = this.append(jetObject2);
                    if (jetObject2 instanceof JetRptParagraph) {
                        this.create((IElementTreeNode)object, iElementTreeNode);
                    } else if (object != null) {
                        iElementTreeNode.add((IElementTreeNode)object);
                    }
                    if (jetRptPageStart == null) continue;
                    this.addAll.put(jetObject2, "E");
                }
            }
        } else if (jetObject instanceof JetRptPageStart) {
            iElementTreeNode = this.append(jetObject);
        } else {
            if (jetObject instanceof JetRptCTAggField && ((JetRptCTAggField)jetObject).isBlank()) {
                return null;
            }
            iElementTreeNode = this.append.create(jetObject, this.add(jetObject), false);
        }
        if (jetObject instanceof JetRptGeoMap && jetObject.getChildren().size() > 0 && jetObject.getChildren() != null && jetObject.getChildren().get(0) instanceof JetRptGeoGroup) {
            iElementTreeNode = this.canBeBrowse((JetRptGeoGroup)jetObject.getChildren().get(0), iElementTreeNode);
        }
        if (this.elementAt(iElementTreeNode)) {
            iElementTreeNode.setDisabled(true);
        }
        iElementTreeNode.setEditabled(iElementTreeNode.getUserObject() instanceof JetRptObject);
        return iElementTreeNode;
    }

    private IElementTreeNode canBeBrowse(JetRptGeoGroup jetRptGeoGroup, IElementTreeNode iElementTreeNode) {
        IElementTreeNode iElementTreeNode2 = this.append((JetRptGeoMarker)jetRptGeoGroup.getChildren().get(0));
        IElementTreeNode iElementTreeNode3 = this.append((JetRptGeoArea)jetRptGeoGroup.getChildren().get(1));
        if (jetRptGeoGroup.getChildren() != null && jetRptGeoGroup.getChildren().size() > 2) {
            this.clear(iElementTreeNode2, iElementTreeNode3, (JetRptGeoGroup)jetRptGeoGroup.getChildren().get(2));
        }
        iElementTreeNode.add(iElementTreeNode2);
        iElementTreeNode.add(iElementTreeNode3);
        return iElementTreeNode;
    }

    private void clear(IElementTreeNode iElementTreeNode, IElementTreeNode iElementTreeNode2, JetRptGeoGroup jetRptGeoGroup) {
        IElementTreeNode iElementTreeNode3 = this.append((JetRptGeoMarker)jetRptGeoGroup.getChildren().get(0));
        IElementTreeNode iElementTreeNode4 = this.append((JetRptGeoArea)jetRptGeoGroup.getChildren().get(1));
        iElementTreeNode.add(iElementTreeNode3);
        iElementTreeNode2.add(iElementTreeNode4);
        if (jetRptGeoGroup.getChildren() != null && jetRptGeoGroup.getChildren().size() > 2) {
            this.clear(iElementTreeNode3, iElementTreeNode4, (JetRptGeoGroup)jetRptGeoGroup.getChildren().get(2));
        }
    }

    private void create(IElementTreeNode iElementTreeNode, IElementTreeNode iElementTreeNode2) {
        int n = iElementTreeNode.getChildCount();
        if (iElementTreeNode.removable()) {
            for (int i = 0; i < n; ++i) {
                IElementTreeNode iElementTreeNode3 = iElementTreeNode.getChildNodeAt(i);
                iElementTreeNode2.add(iElementTreeNode3);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                IElementTreeNode iElementTreeNode4 = iElementTreeNode.getChildNodeAt(0);
                iElementTreeNode2.add(iElementTreeNode4);
            }
        }
    }

    private Vector displayName(JetRptObject jetRptObject) {
        JetContainable jetContainable = jetRptObject.getParent();
        Vector vector = jetContainable.getChildren();
        int n = vector.size();
        Vector<JetRptObject> vector2 = new Vector<JetRptObject>();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            JetRptObject jetRptObject2 = (JetRptObject)vector.get(i);
            if (jetRptObject2 instanceof JetRptPageStart && jetRptObject == jetRptObject2) {
                vector2.clear();
                bl = true;
                continue;
            }
            if (jetRptObject2 instanceof JetRptPageBreaker && jetRptObject == jetRptObject2) {
                vector2.clear();
                bl = true;
                continue;
            }
            if (jetRptObject2 instanceof JetRptPageEnd || jetRptObject2 instanceof JetRptPageBreaker) {
                if (!bl) continue;
                break;
            }
            if (!bl) continue;
            vector2.add(jetRptObject2);
        }
        return vector2;
    }

    private boolean elementAt(IElementTreeNode iElementTreeNode) {
        Object object = iElementTreeNode.getUserObject();
        for (int i = 0; i < this.addElement.length; ++i) {
            if (!this.addElement[i].isInstance(object)) continue;
            return !(object instanceof LCObject);
        }
        return false;
    }

    private DataSet[] equals(JetObject jetObject) {
        if (jetObject instanceof JetRptReportSet) {
            return ((JetRptReportSet)jetObject).getAllDataSet();
        }
        if (jetObject instanceof IReport) {
            List list = jetObject instanceof JetRptReport ? ((JetRptReport)jetObject).getUsedDataSet() : ((IReport)((Object)jetObject)).getIRptBody().getUsedDataSet();
            return list.toArray(new DataSet[list.size()]);
        }
        if (jetObject instanceof IRptBody) {
            List list = ((IRptBody)((Object)jetObject)).getUsedDataSet();
            return list.toArray(new DataSet[list.size()]);
        }
        return null;
    }
}

