/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.util.loader;

import com.jinfonet.util.loader.ClassLoaderFactory;
import com.jinfonet.util.loader.ZipClassLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import jet.log.JRLogger;

public final class DynamicClassManager {
    private Hashtable C = null;
    private Hashtable J = null;
    private RootClassLoader SEDU = null;
    private static JRLogger access$200;
    private static Method add;
    private static DynamicClassManager append;
    private static final String[] arraycopy;
    private Map bytesToClass = new WeakHashMap(10);

    private void logError(String string) {
        if (add != null) {
            try {
                add.invoke((Object)this, string);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            access$200.error(string);
        }
    }

    private DynamicClassManager() {
        this.C = new Hashtable();
        this.J = new Hashtable();
        this.SEDU = new RootClassLoader(this.getClass().getClassLoader());
    }

    public static DynamicClassManager getInstance() {
        return append;
    }

    public synchronized void loadClasses(String string) throws IllegalArgumentException {
        long l = System.currentTimeMillis();
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("\"Dynamic Class Dir\" must be a valid directory path: \"" + string + "\"");
        }
        this.J.clear();
        File[] fileArray = this.append(file);
        ArrayList arrayList = this.add(fileArray);
        this.SEDU(arrayList);
        this.J(arrayList);
        this.bytesToClass.clear();
        String string2 = "loadClasses in " + string;
        this.C(l, string2);
    }

    private void C(long l, String string) {
        long l2 = System.currentTimeMillis();
        access$200.debug(string + "\nElapsed: " + (l2 - l) + "ms");
    }

    private void J(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = this.bytesToClass(arrayList);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string);
            int n = vector.size();
            if (n <= 1) continue;
            stringBuffer.append("\nDuplicated Dynamic Classes: " + string + ", which contained in below files.");
            stringBuffer.append("\nPlease check. (now the uppermost one take effect)\n");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("\t" + vector.get(i) + "\n");
            }
        }
        if (stringBuffer.length() > 0) {
            this.logError(stringBuffer.toString());
        }
    }

    private void SEDU(ArrayList arrayList) {
        Hashtable<String, ClassLoaderWrapper> hashtable = new Hashtable<String, ClassLoaderWrapper>();
        int n = arrayList.size();
        File file = null;
        String string = null;
        ClassLoaderWrapper classLoaderWrapper = null;
        ClassLoader classLoader = null;
        ClassLoaderWrapper classLoaderWrapper2 = null;
        for (int i = 0; i < n; ++i) {
            file = (File)arrayList.get(i);
            string = file.getAbsolutePath();
            classLoaderWrapper = (ClassLoaderWrapper)this.C.get(string);
            if (classLoaderWrapper != null && classLoaderWrapper.lastModified == file.lastModified() && classLoaderWrapper.size == file.length()) {
                if (access$200.isDebugEnabled()) {
                    access$200.debug("ClassLoader already exist, ignore..: " + string);
                }
                classLoader = classLoaderWrapper.wrapLoader;
                classLoaderWrapper2 = classLoaderWrapper;
            } else {
                if (access$200.isDebugEnabled()) {
                    access$200.debug("Loading class from package: " + string);
                }
                classLoader = ClassLoaderFactory.getClassLoader(file, this.SEDU);
                classLoaderWrapper2 = new ClassLoaderWrapper(file, classLoader);
            }
            this.access$200(classLoader);
            hashtable.put(string, classLoaderWrapper2);
        }
        this.C.clear();
        this.C = null;
        this.C = hashtable;
    }

    private void access$200(ClassLoader classLoader) {
        ZipClassLoader zipClassLoader = (ZipClassLoader)classLoader;
        Vector vector = zipClassLoader.getClassAndResourceNames();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            if (this.J.containsKey(string)) continue;
            this.J.put(string, zipClassLoader);
        }
    }

    private ArrayList add(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(fileArray[i]);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                File file = (File)object;
                File file2 = (File)object2;
                long l = file2.lastModified() - file.lastModified();
                if (l < 0L) {
                    return -1;
                }
                if (l == 0L) {
                    return 0;
                }
                return 1;
            }
        });
        return arrayList;
    }

    private File[] append(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName();
                if (file.isFile() && (string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".zip"))) {
                    if (access$200.isDebugEnabled()) {
                        access$200.debug("Check file in dynamic folder, valid package: " + file.getAbsolutePath());
                    }
                    return true;
                }
                if (access$200.isDebugEnabled()) {
                    access$200.debug("Check file in dynamic folder, invalid package: " + file.getAbsolutePath());
                }
                return false;
            }
        });
        return fileArray;
    }

    public synchronized Class getClass(String string) throws ClassNotFoundException {
        long l = System.currentTimeMillis();
        Class<?> clazz = this.SEDU.loadClass(string);
        String string2 = "getClass: " + string;
        this.C(l, string2);
        return clazz;
    }

    private boolean arraycopy(String string) {
        for (int i = 0; i < arraycopy.length; ++i) {
            if (!string.equalsIgnoreCase(arraycopy[i])) continue;
            return true;
        }
        return false;
    }

    private Hashtable bytesToClass(ArrayList arrayList) {
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = ((File)arrayList.get(i)).getAbsolutePath();
            ClassLoaderWrapper classLoaderWrapper = (ClassLoaderWrapper)this.C.get(string);
            ZipClassLoader zipClassLoader = (ZipClassLoader)classLoaderWrapper.wrapLoader;
            Vector vector = zipClassLoader.getClassAndResourceNames();
            for (int j = 0; j < vector.size(); ++j) {
                Vector vector2;
                String string2 = (String)vector.get(j);
                if (this.arraycopy(string2)) continue;
                if (hashtable.containsKey(string2)) {
                    vector2 = (Vector)hashtable.get(string2);
                    vector2.add(string);
                    continue;
                }
                vector2 = new Vector();
                vector2.add(string);
                hashtable.put(string2, vector2);
            }
        }
        return hashtable;
    }

    public ClassLoader getRootClassLoader() {
        return this.SEDU;
    }

    public synchronized Class bytesToClass(String string, byte[] byArray, boolean bl) throws ClassNotFoundException {
        String string2 = " new create";
        long l = System.currentTimeMillis();
        Class clazz = null;
        if (this.bytesToClass.get(string) != null) {
            Class clazz2 = clazz = bl ? (Class)((SoftReference)this.bytesToClass.get(string)).get() : null;
        }
        if (clazz == null) {
            clazz = new DefineClassLoader((ClassLoader)this.SEDU).SEDU(string, byArray);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            if (bl) {
                this.bytesToClass.put(string, new SoftReference<Class>(clazz));
                string2 = " new create and cache";
            } else {
                string2 = " new create with no cache";
            }
        } else {
            string2 = " from cache";
        }
        l = System.currentTimeMillis() - l;
        access$200.info("byteToClass: " + string + string2 + " time: " + l);
        return clazz;
    }

    public synchronized Class bytesToClass(String string, byte[] byArray) throws ClassNotFoundException {
        return this.bytesToClass(string, byArray, true);
    }

    public synchronized String[] getResourceName(String[] stringArray) {
        Object object;
        int n;
        Vector<String> vector = new Vector<String>();
        String string = null;
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string == null || string.equals("")) continue;
            try {
                object = this.getClass(string);
                String string2 = this.charAt((Class)object);
                if (vector.contains(string2)) continue;
                vector.add(string2);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                access$200.error(classNotFoundException);
            }
        }
        n = vector.size();
        object = new String[n];
        System.arraycopy(vector.toArray(), 0, object, 0, n);
        return object;
    }

    private String charAt(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        String string = clazz.getName().replace('.', '/') + ".class";
        URL uRL = classLoader.getResource(string);
        String string2 = URLDecoder.decode(uRL.getPath());
        String string3 = uRL.getProtocol();
        uRL.getPort();
        uRL.getProtocol();
        if (string3.equals("jar") || string3.equals("wsjar") || string3.equals("zip")) {
            if (string2.startsWith("file:")) {
                string2 = string2.charAt(7) == ':' ? string2.substring(6) : string2.substring(5);
            }
            if (string2.indexOf(33) >= 0) {
                return string2.substring(0, string2.indexOf(33)).replace('/', File.separatorChar);
            }
            return string2.replace('/', File.separatorChar);
        }
        if (string2.length() >= 3 && string2.charAt(0) == '/' && string2.charAt(2) == ':') {
            string2 = string2.substring(1);
        }
        String string4 = null;
        if (classLoader instanceof ZipClassLoader) {
            string4 = string2;
            if ((string4 = string4.replace('/', File.separatorChar)).endsWith(File.separator)) {
                string4 = string4.substring(0, string4.length() - 1);
            }
        } else {
            string4 = string2.substring(0, string2.length() - string.length()).replace('/', File.separatorChar);
            if (string4.endsWith(File.separator)) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            if (string4.endsWith("!")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
        }
        return string4;
    }

    static {
        add = null;
        try {
            Class<?> clazz = Class.forName("jet.server.log.ServiceLogger");
            add = clazz.getMethod("logError", String.class);
        }
        catch (Throwable throwable) {
            add = null;
        }
        access$200 = JRLogger.getLogger(DynamicClassManager.class.getName());
        append = new DynamicClassManager();
        arraycopy = new String[]{"META-INF/MANIFEST.MF"};
    }

    private class DefineClassLoader
    extends ClassLoader {
        public DefineClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        private Class SEDU(String string, byte[] byArray) {
            Class<?> clazz = null;
            clazz = this.defineClass(byArray, 0, byArray.length);
            this.resolveClass(clazz);
            return clazz;
        }
    }

    private class ClassLoaderWrapper {
        long lastModified = -1L;
        ClassLoader wrapLoader = null;
        long size = -1L;

        ClassLoaderWrapper(File file, ClassLoader classLoader) {
            this.lastModified = file.lastModified();
            this.size = file.length();
            this.wrapLoader = classLoader;
        }
    }

    private class RootClassLoader
    extends ClassLoader {
        public RootClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class clazz = null;
            if (!string.startsWith("java.") && !string.startsWith("javax.")) {
                clazz = this.SEDU(string);
            }
            if (clazz == null) {
                clazz = this.getParent().loadClass(string);
            }
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            if (clazz != null && bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        private Class SEDU(String string) {
            Class clazz = null;
            ZipClassLoader zipClassLoader = (ZipClassLoader)DynamicClassManager.this.J.get(string);
            if (zipClassLoader != null) {
                try {
                    clazz = zipClassLoader.findClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
            return clazz;
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            ZipClassLoader zipClassLoader = (ZipClassLoader)DynamicClassManager.this.J.get(string);
            if (zipClassLoader != null) {
                return zipClassLoader.getResourceStream(string);
            }
            return this.getParent().getResourceAsStream(string);
        }
    }
}

