/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.util.loader;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import jet.log.JRLogger;

public final class JarResources {
    private static JRLogger SEDU = JRLogger.getLogger(JarResources.class.getName());
    private Hashtable add = new Hashtable();
    private Hashtable append = new Hashtable();
    private Vector close = new Vector();
    private String endsWith;
    private static final String entries = ".class";

    public JarResources(String string) {
        this.endsWith = string;
        this.SEDU();
    }

    public byte[] getResource(String string) {
        return (byte[])this.append.get(string);
    }

    private void SEDU() {
        try {
            this.append();
            this.add();
        }
        catch (FileNotFoundException fileNotFoundException) {
            SEDU.error("File not found: " + this.endsWith);
        }
        catch (IOException iOException) {
            SEDU.error("Failed to read file: " + this.endsWith + " , please check whether it is a valid file");
        }
        catch (Throwable throwable) {
            SEDU.error("Failed to read file: " + this.endsWith + " , please check whether it is damaged!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.endsWith);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                int n = (int)zipEntry.getSize();
                if (n == -1) {
                    n = (Integer)this.add.get(zipEntry.getName());
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n - n2 > 0 && (n3 = zipInputStream.read(byArray, n2, n - n2)) != -1) {
                    n2 += n3;
                }
                this.append.put(zipEntry.getName(), byArray);
                this.endsWith(zipEntry.getName());
            }
        }
        finally {
            zipInputStream.close();
            bufferedInputStream.close();
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append() throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.endsWith);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                this.add.put(zipEntry.getName(), new Integer((int)zipEntry.getSize()));
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private String close(ZipEntry zipEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        if (zipEntry.isDirectory()) {
            stringBuffer.append("d ");
        } else {
            stringBuffer.append("f ");
        }
        if (zipEntry.getMethod() == 0) {
            stringBuffer.append("stored   ");
        } else {
            stringBuffer.append("defalted ");
        }
        stringBuffer.append(zipEntry.getName());
        stringBuffer.append("\t");
        stringBuffer.append("" + zipEntry.getSize());
        if (zipEntry.getMethod() == 8) {
            stringBuffer.append("/" + zipEntry.getCompressedSize());
        }
        return stringBuffer.toString();
    }

    private void endsWith(String string) {
        if (string.toLowerCase().endsWith(entries)) {
            String string2 = string.substring(0, string.length() - entries.length()).replace('/', '.');
            this.close.add(string2);
        } else {
            this.close.add(string);
        }
    }

    public Vector getClassAndResourceNames() {
        return this.close;
    }

    public String getJarFileName() {
        return this.endsWith;
    }
}

