/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.util.loader;

import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.JarResources;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class ZipClassLoader
extends ClassLoader {
    private static final String SEDU = ".class";
    private JarResources append = null;
    private Hashtable contains = new Hashtable();

    public ZipClassLoader(File file, ClassLoader classLoader) {
        super(classLoader);
        this.append = new JarResources(file.getAbsolutePath());
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = (Class<?>)this.contains.get(string);
        if (clazz != null) {
            return clazz;
        }
        String string2 = string.replace('.', '/') + SEDU;
        byte[] byArray = this.append.getResource(string2);
        if (byArray != null && byArray.length > 0) {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        if (clazz != null) {
            this.resolveClass(clazz);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        this.contains.put(string, clazz);
        return clazz;
    }

    public Vector getClassAndResourceNames() {
        return this.append.getClassAndResourceNames();
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        return this.getParent().getResourceAsStream(string);
    }

    InputStream getResourceStream(String string) {
        ByteArrayInputStream byteArrayInputStream = null;
        byte[] byArray = this.append.getResource(string);
        if (byArray != null && byArray.length > 0) {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        return byteArrayInputStream;
    }

    @Override
    protected URL findResource(String string) {
        String string2 = null;
        if (string.endsWith(SEDU)) {
            string2 = string.substring(0, string.length() - SEDU.length());
            string2 = string2.replace('/', '.');
        }
        if (this.append.getClassAndResourceNames().contains(string2)) {
            URL uRL;
            try {
                uRL = new File(this.append.getJarFileName()).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, malformedURLException);
                }
                return null;
            }
            return uRL;
        }
        return super.findResource(string);
    }
}

