/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util;

public class SymbolTable {
    protected static final int TABLE_SIZE = 173;
    protected Entry[] fBuckets = null;
    protected int fTableSize;

    public SymbolTable() {
        this(173);
    }

    public SymbolTable(int n) {
        this.fTableSize = n;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public String addSymbol(String string) {
        int n = this.hash(string);
        int n2 = n % this.fTableSize;
        int n3 = string.length();
        Entry entry = this.fBuckets[n2];
        while (entry != null) {
            if (n3 == entry.characters.length && n == entry.hashCode && string.regionMatches(0, entry.symbol, 0, n3)) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        entry = new Entry(string, this.fBuckets[n2]);
        entry.hashCode = n;
        this.fBuckets[n2] = entry;
        return entry.symbol;
    }

    public String addSymbol(char[] cArray, int n, int n2) {
        int n3 = this.hash(cArray, n, n2);
        int n4 = n3 % this.fTableSize;
        Entry entry = this.fBuckets[n4];
        while (entry != null) {
            block4: {
                if (n2 == entry.characters.length && n3 == entry.hashCode) {
                    for (int i = 0; i < n2; ++i) {
                        if (cArray[n + i] == entry.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return entry.symbol;
                }
            }
            entry = entry.next;
        }
        this.fBuckets[n4] = entry = new Entry(cArray, n, n2, this.fBuckets[n4]);
        entry.hashCode = n3;
        return entry.symbol;
    }

    public int hash(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n = n * 37 + string.charAt(i);
        }
        return n & 0x7FFFFFF;
    }

    public int hash(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 * 37 + cArray[n + i];
        }
        return n3 & 0x7FFFFFF;
    }

    public boolean containsSymbol(String string) {
        int n = this.hash(string);
        int n2 = n % this.fTableSize;
        int n3 = string.length();
        Entry entry = this.fBuckets[n2];
        while (entry != null) {
            if (n3 == entry.characters.length && n == entry.hashCode && string.regionMatches(0, entry.symbol, 0, n3)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] cArray, int n, int n2) {
        int n3 = this.hash(cArray, n, n2);
        int n4 = n3 % this.fTableSize;
        Entry entry = this.fBuckets[n4];
        while (entry != null) {
            block4: {
                if (n2 == entry.characters.length && n3 == entry.hashCode) {
                    for (int i = 0; i < n2; ++i) {
                        if (cArray[n + i] == entry.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    protected static final class Entry {
        public String symbol;
        int hashCode = 0;
        public char[] characters;
        public Entry next;

        public Entry(String string, Entry entry) {
            this.symbol = string.intern();
            this.characters = new char[string.length()];
            string.getChars(0, this.characters.length, this.characters, 0);
            this.next = entry;
        }

        public Entry(char[] cArray, int n, int n2, Entry entry) {
            this.characters = new char[n2];
            System.arraycopy(cArray, n, this.characters, 0, n2);
            this.symbol = new String(this.characters).intern();
            this.next = entry;
        }
    }
}

