/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.policy;

import com.jinfonet.webservice.policy.Policy;
import com.jinfonet.webservice.policy.PolicyException;
import com.jinfonet.webservice.policy.PolicyMapKey;
import com.jinfonet.webservice.policy.PolicyMapKeyHandler;
import com.jinfonet.webservice.policy.PolicyScope;
import com.jinfonet.webservice.policy.PolicySubject;
import com.jinfonet.webservice.policy.processor.Merger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import jet.log.JRLogger;

public final class PolicyMap
implements Iterable {
    private static JRLogger $SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType = JRLogger.getLogger(PolicyMap.class.getName());
    private static final PolicyMapKeyHandler SEDU = new PolicyMapKeyHandler(){

        @Override
        public boolean areEqual(PolicyMapKey policyMapKey, PolicyMapKey policyMapKey2) {
            return policyMapKey.getService().equals(policyMapKey2.getService());
        }

        @Override
        public int generateHashCode(PolicyMapKey policyMapKey) {
            int n = 17;
            n = 37 * n + policyMapKey.getService().hashCode();
            return n;
        }
    };
    private static final PolicyMapKeyHandler addAll = new PolicyMapKeyHandler(){

        @Override
        public boolean areEqual(PolicyMapKey policyMapKey, PolicyMapKey policyMapKey2) {
            boolean bl = true;
            boolean bl2 = bl = bl && policyMapKey.getService().equals(policyMapKey2.getService());
            bl = bl && (policyMapKey.getEndpoint() == null ? policyMapKey2.getEndpoint() == null : policyMapKey.getEndpoint().equals(policyMapKey2.getEndpoint()));
            return bl;
        }

        @Override
        public int generateHashCode(PolicyMapKey policyMapKey) {
            int n = 17;
            n = 37 * n + policyMapKey.getService().hashCode();
            n = 37 * n + (policyMapKey.getEndpoint() == null ? 0 : policyMapKey.getEndpoint().hashCode());
            return n;
        }
    };
    private static final PolicyMapKeyHandler append = new PolicyMapKeyHandler(){

        @Override
        public boolean areEqual(PolicyMapKey policyMapKey, PolicyMapKey policyMapKey2) {
            boolean bl = true;
            boolean bl2 = bl = bl && policyMapKey.getService().equals(policyMapKey2.getService());
            boolean bl3 = bl && (policyMapKey.getEndpoint() == null ? policyMapKey2.getEndpoint() == null : policyMapKey.getEndpoint().equals(policyMapKey2.getEndpoint())) ? true : (bl = false);
            bl = bl && (policyMapKey.getOperation() == null ? policyMapKey2.getOperation() == null : policyMapKey.getOperation().equals(policyMapKey2.getOperation()));
            return bl;
        }

        @Override
        public int generateHashCode(PolicyMapKey policyMapKey) {
            int n = 17;
            n = 37 * n + policyMapKey.getService().hashCode();
            n = 37 * n + (policyMapKey.getEndpoint() == null ? 0 : policyMapKey.getEndpoint().hashCode());
            n = 37 * n + (policyMapKey.getOperation() == null ? 0 : policyMapKey.getOperation().hashCode());
            return n;
        }
    };
    private static final PolicyMapKeyHandler contains = new PolicyMapKeyHandler(){

        @Override
        public boolean areEqual(PolicyMapKey policyMapKey, PolicyMapKey policyMapKey2) {
            boolean bl = true;
            boolean bl2 = bl = bl && policyMapKey.getService().equals(policyMapKey2.getService());
            boolean bl3 = bl && (policyMapKey.getEndpoint() == null ? policyMapKey2.getEndpoint() == null : policyMapKey.getEndpoint().equals(policyMapKey2.getEndpoint())) ? true : (bl = false);
            boolean bl4 = bl && (policyMapKey.getOperation() == null ? policyMapKey2.getOperation() == null : policyMapKey.getOperation().equals(policyMapKey2.getOperation())) ? true : (bl = false);
            bl = bl && (policyMapKey.getFaultMessage() == null ? policyMapKey2.getFaultMessage() == null : policyMapKey.getFaultMessage().equals(policyMapKey2.getFaultMessage()));
            return bl;
        }

        @Override
        public int generateHashCode(PolicyMapKey policyMapKey) {
            int n = 17;
            n = 37 * n + policyMapKey.getService().hashCode();
            n = 37 * n + (policyMapKey.getEndpoint() == null ? 0 : policyMapKey.getEndpoint().hashCode());
            n = 37 * n + (policyMapKey.getOperation() == null ? 0 : policyMapKey.getOperation().hashCode());
            n = 37 * n + (policyMapKey.getFaultMessage() == null ? 0 : policyMapKey.getFaultMessage().hashCode());
            return n;
        }
    };
    private static final Merger error = Merger.getMerger();
    private final ScopeMap getAllKeys = new ScopeMap(error, SEDU);
    private final ScopeMap getEffectivePolicy = new ScopeMap(error, addAll);
    private final ScopeMap getLogger = new ScopeMap(error, append);
    private final ScopeMap getMerger = new ScopeMap(error, append);
    private final ScopeMap getName = new ScopeMap(error, append);
    private final ScopeMap getPolicySubjects = new ScopeMap(error, contains);

    private PolicyMap() {
    }

    public static PolicyMap createAttachments() {
        PolicyMap policyMap = new PolicyMap();
        return policyMap;
    }

    public Policy getServiceEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.getAllKeys.getEffectivePolicy(policyMapKey);
    }

    public Policy getEndpointEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.getEffectivePolicy.getEffectivePolicy(policyMapKey);
    }

    public Policy getOperationEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.getLogger.getEffectivePolicy(policyMapKey);
    }

    public Policy getInputMessageEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.getMerger.getEffectivePolicy(policyMapKey);
    }

    public Policy getOutputMessageEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.getName.getEffectivePolicy(policyMapKey);
    }

    public Policy getFaultMessageEffectivePolicy(PolicyMapKey policyMapKey) throws PolicyException {
        return this.getPolicySubjects.getEffectivePolicy(policyMapKey);
    }

    public Collection getAllServiceScopeKeys() {
        return this.getAllKeys.getAllKeys();
    }

    public Collection getAllEndpointScopeKeys() {
        return this.getEffectivePolicy.getAllKeys();
    }

    public Collection getAllOperationScopeKeys() {
        return this.getLogger.getAllKeys();
    }

    public Collection getAllInputMessageScopeKeys() {
        return this.getMerger.getAllKeys();
    }

    public Collection getAllOutputMessageScopeKeys() {
        return this.getName.getAllKeys();
    }

    public Collection getAllFaultMessageScopeKeys() {
        return this.getPolicySubjects.getAllKeys();
    }

    public void putSubject(ScopeType scopeType, PolicyMapKey policyMapKey, PolicySubject policySubject) {
        switch (scopeType) {
            case SERVICE: {
                this.getAllKeys.putSubject(policyMapKey, policySubject);
                break;
            }
            case ENDPOINT: {
                this.getEffectivePolicy.putSubject(policyMapKey, policySubject);
                break;
            }
            case OPERATION: {
                this.getLogger.putSubject(policyMapKey, policySubject);
                break;
            }
            case INPUT_MESSAGE: {
                this.getMerger.putSubject(policyMapKey, policySubject);
                break;
            }
            case OUTPUT_MESSAGE: {
                this.getName.putSubject(policyMapKey, policySubject);
                break;
            }
            case FAULT_MESSAGE: {
                this.getPolicySubjects.putSubject(policyMapKey, policySubject);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported policy scope type: " + (Object)((Object)scopeType));
            }
        }
    }

    public Collection getPolicySubjects() {
        LinkedList linkedList = new LinkedList();
        this.$SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType(linkedList, this.getAllKeys);
        this.$SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType(linkedList, this.getEffectivePolicy);
        this.$SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType(linkedList, this.getLogger);
        this.$SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType(linkedList, this.getMerger);
        this.$SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType(linkedList, this.getName);
        this.$SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType(linkedList, this.getPolicySubjects);
        return linkedList;
    }

    public boolean isInputMessageSubject(PolicySubject policySubject) {
        for (PolicyScope policyScope : this.getMerger.getStoredScopes()) {
            if (!policyScope.getPolicySubjects().contains(policySubject)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutputMessageSubject(PolicySubject policySubject) {
        for (PolicyScope policyScope : this.getName.getStoredScopes()) {
            if (!policyScope.getPolicySubjects().contains(policySubject)) continue;
            return true;
        }
        return false;
    }

    public boolean isFaultMessageSubject(PolicySubject policySubject) {
        for (PolicyScope policyScope : this.getPolicySubjects.getStoredScopes()) {
            if (!policyScope.getPolicySubjects().contains(policySubject)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.getAllKeys.isEmpty() && this.getEffectivePolicy.isEmpty() && this.getLogger.isEmpty() && this.getMerger.isEmpty() && this.getName.isEmpty() && this.getPolicySubjects.isEmpty();
    }

    private void $SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType(Collection collection, ScopeMap scopeMap) {
        for (PolicyScope policyScope : scopeMap.getStoredScopes()) {
            List list = policyScope.getPolicySubjects();
            collection.addAll(list);
        }
    }

    public static PolicyMapKey createWsdlServiceScopeKey(QName qName) throws IllegalArgumentException {
        if (qName == null) {
            $SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType.error("Input parameter must not be null: service=" + qName);
        }
        return new PolicyMapKey(qName, null, null, SEDU);
    }

    public static PolicyMapKey createWsdlEndpointScopeKey(QName qName, QName qName2) throws IllegalArgumentException {
        if (qName == null || qName2 == null) {
            $SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType.error("Input parameter must not be null: service=" + qName + "; endpoint=" + qName2);
        }
        return new PolicyMapKey(qName, qName2, null, addAll);
    }

    public static PolicyMapKey createWsdlOperationScopeKey(QName qName, QName qName2, QName qName3) throws IllegalArgumentException {
        return PolicyMap.SEDU(qName, qName2, qName3);
    }

    public static PolicyMapKey createWsdlInputOutputMessageScopeKey(QName qName, QName qName2, QName qName3) throws IllegalArgumentException {
        return PolicyMap.SEDU(qName, qName2, qName3);
    }

    public static PolicyMapKey createWsdlFaultMessageScopeKey(QName qName, QName qName2, QName qName3, QName qName4) throws IllegalArgumentException {
        if (qName == null || qName2 == null || qName3 == null || qName4 == null) {
            $SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType.error("Input parameter must not be null: service=" + qName + "; endpoint=" + qName2 + "; operation=" + qName3 + "; fault=" + qName4);
        }
        return new PolicyMapKey(qName, qName2, qName3, qName4, contains);
    }

    private static PolicyMapKey SEDU(QName qName, QName qName2, QName qName3) {
        if (qName == null || qName2 == null || qName3 == null) {
            $SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType.error("Input parameter must not be null: service=" + qName + "; endpoint=" + qName2 + "; operation=" + qName3);
        }
        return new PolicyMapKey(qName, qName2, qName3, append);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.getAllKeys) {
            stringBuffer.append("\nServiceMap=").append(this.getAllKeys);
        }
        if (null != this.getEffectivePolicy) {
            stringBuffer.append("\nEndpointMap=").append(this.getEffectivePolicy);
        }
        if (null != this.getLogger) {
            stringBuffer.append("\nOperationMap=").append(this.getLogger);
        }
        if (null != this.getMerger) {
            stringBuffer.append("\nInputMessageMap=").append(this.getMerger);
        }
        if (null != this.getName) {
            stringBuffer.append("\nOutputMessageMap=").append(this.getName);
        }
        if (null != this.getPolicySubjects) {
            stringBuffer.append("\nFaultMessageMap=").append(this.getPolicySubjects);
        }
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new Iterator(){
            private final Iterator SEDU;
            private Iterator access$200;
            {
                ArrayList<Iterator> arrayList = new ArrayList<Iterator>(6);
                arrayList.add(PolicyMap.this.getAllKeys.iterator());
                arrayList.add(PolicyMap.this.getEffectivePolicy.iterator());
                arrayList.add(PolicyMap.this.getLogger.iterator());
                arrayList.add(PolicyMap.this.getMerger.iterator());
                arrayList.add(PolicyMap.this.getName.iterator());
                arrayList.add(PolicyMap.this.getPolicySubjects.iterator());
                this.SEDU = arrayList.iterator();
                this.access$200 = (Iterator)this.SEDU.next();
            }

            @Override
            public boolean hasNext() {
                while (!this.access$200.hasNext()) {
                    if (this.SEDU.hasNext()) {
                        this.access$200 = (Iterator)this.SEDU.next();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            public Policy next() {
                if (this.hasNext()) {
                    return (Policy)this.access$200.next();
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static final class ScopeMap
    implements Iterable {
        private final Map SEDU = new HashMap();
        private final PolicyMapKeyHandler access$000;
        private final Merger add;

        ScopeMap(Merger merger, PolicyMapKeyHandler policyMapKeyHandler) {
            this.add = merger;
            this.access$000 = policyMapKeyHandler;
        }

        Policy getEffectivePolicy(PolicyMapKey policyMapKey) {
            PolicyScope policyScope = (PolicyScope)this.SEDU.get(this.SEDU(policyMapKey));
            return policyScope == null ? null : policyScope.getEffectivePolicy(this.add);
        }

        void putSubject(PolicyMapKey policyMapKey, PolicySubject policySubject) {
            PolicyMapKey policyMapKey2 = this.SEDU(policyMapKey);
            PolicyScope policyScope = (PolicyScope)this.SEDU.get(policyMapKey2);
            if (policyScope == null) {
                LinkedList<PolicySubject> linkedList = new LinkedList<PolicySubject>();
                linkedList.add(policySubject);
                this.SEDU.put(policyMapKey2, new PolicyScope(linkedList));
            } else {
                policyScope.attach(policySubject);
            }
        }

        Collection getStoredScopes() {
            return this.SEDU.values();
        }

        Set getAllKeys() {
            return this.SEDU.keySet();
        }

        private PolicyMapKey SEDU(PolicyMapKey policyMapKey) {
            if (policyMapKey == null) {
                $SwitchMap$com$jinfonet$webservice$policy$PolicyMap$ScopeType.error("PolicyMapKey must not be null!");
                return null;
            }
            PolicyMapKey policyMapKey2 = new PolicyMapKey(policyMapKey);
            policyMapKey2.setHandler(this.access$000);
            return policyMapKey2;
        }

        public Iterator iterator() {
            return new Iterator(){
                private final Iterator SEDU;
                {
                    this.SEDU = ScopeMap.this.SEDU.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.SEDU.hasNext();
                }

                public Policy next() {
                    PolicyMapKey policyMapKey = (PolicyMapKey)this.SEDU.next();
                    return ScopeMap.this.getEffectivePolicy(policyMapKey);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean isEmpty() {
            return this.SEDU.isEmpty();
        }

        public String toString() {
            return this.SEDU.toString();
        }
    }

    public static enum ScopeType {
        SERVICE,
        ENDPOINT,
        OPERATION,
        INPUT_MESSAGE,
        OUTPUT_MESSAGE,
        FAULT_MESSAGE;

    }
}

