/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.policy.parser;

import com.jinfonet.webservice.policy.Policy;
import com.jinfonet.webservice.policy.PolicyMap;
import com.jinfonet.webservice.policy.PolicyMapKey;
import com.jinfonet.webservice.policy.PolicyReference;
import com.jinfonet.webservice.policy.PolicySubject;
import com.jinfonet.webservice.policy.WSDL11PolicyExtensionWrapper;
import com.jinfonet.webservice.policy.WSDLPolicyExtensionWrapper;
import com.jinfonet.webservice.policy.parser.Element2PolicyComponent;
import com.jinfonet.webservice.policy.parser.MapIterator;
import com.jinfonet.webservice.policy.parser.PolicyParserListener;
import com.jinfonet.webservice.policy.parser.WSDLPolicyExtensionDeserializer;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import jet.log.JRLogger;
import org.w3c.dom.Element;

public class WSDL11PolicyExtensionDeserializer
extends WSDLPolicyExtensionDeserializer
implements ExtensionDeserializer {
    private static JRLogger ENDPOINT = JRLogger.getLogger(WSDL11PolicyExtensionDeserializer.class.getName());
    private static QName FAULT_MESSAGE;

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        String string = definition.getTargetNamespace().toString();
        this.baseUri = definition.getDocumentBaseURI().toString();
        if (ENDPOINT.isDebugEnabled()) {
            ENDPOINT.debug("Unmarshall policy: parentType=" + clazz.getName() + " extType=" + qName + " tns=" + string + " baseUri=" + this.baseUri);
        }
        WSDL11PolicyExtensionWrapper wSDL11PolicyExtensionWrapper = null;
        if ("Policy".equals(qName.getLocalPart())) {
            Policy policy = Element2PolicyComponent.parsePolicy(element, (PolicyParserListener)this);
            wSDL11PolicyExtensionWrapper = new WSDL11PolicyExtensionWrapper(policy);
            String string2 = policy.getId();
            if (ENDPOINT.isDebugEnabled()) {
                ENDPOINT.debug("policyId=" + string2);
            }
            if (null != string2 && !"".equals(string2)) {
                String string3 = this.baseUri + "#" + string2;
                if (!this.policiesWithId.containsKey(string3)) {
                    this.policiesWithId.put(string3, policy);
                }
            } else {
                policy.setId(this.createAnonymousPolicyId());
            }
        } else if ("PolicyReference".equals(qName.getLocalPart())) {
            PolicyReference policyReference = Element2PolicyComponent.parsePolicyReference(element, this);
            wSDL11PolicyExtensionWrapper = new WSDL11PolicyExtensionWrapper(policyReference);
        }
        if (null != wSDL11PolicyExtensionWrapper) {
            wSDL11PolicyExtensionWrapper.setElementType(qName);
        }
        return wSDL11PolicyExtensionWrapper;
    }

    private Collection ENDPOINT(ElementExtensible elementExtensible) {
        String[] stringArray;
        Object object;
        Object[] objectArray;
        ArrayList<Policy> arrayList = new ArrayList<Policy>();
        if (null == elementExtensible) {
            return arrayList;
        }
        Policy policy = null;
        for (Object object2 : objectArray = elementExtensible.getExtensibilityElements().toArray()) {
            if (!(object2 instanceof WSDLPolicyExtensionWrapper)) continue;
            object = (ExtensibilityElement)object2;
            stringArray = ((WSDLPolicyExtensionWrapper)object).getWrappedPolicyCompnent();
            if (WSDLPolicyExtensionDeserializer.policyQNames.contains(object.getElementType())) {
                policy = (Policy)stringArray;
                arrayList.add(this.normalize(policy));
                continue;
            }
            if (!WSDLPolicyExtensionDeserializer.policyReferenceQNames.contains(object.getElementType())) continue;
            String[] stringArray2 = stringArray;
            String string = stringArray2.getReferencedPolicyUri().toString();
            if (string.startsWith("#")) {
                string = this.getBaseUri() + string;
            }
            policy = (Policy)this.policiesWithId.get(string);
            arrayList.add(this.normalize(policy));
        }
        Object object3 = ((AttributeExtensible)elementExtensible).getExtensionAttribute(FAULT_MESSAGE);
        if (null != object3) {
            Object object2;
            QName qName = (QName)object3;
            String string = qName.getLocalPart();
            object2 = "";
            object = "";
            if (string.startsWith("#")) {
                object2 = "#";
                object = this.getBaseUri();
            } else {
                object2 = "http://";
                object = "";
            }
            for (String string2 : stringArray = string.split((String)object2)) {
                string2 = (String)object + (String)object2 + string2;
                policy = (Policy)this.policiesWithId.get(string2);
                if (null != policy) {
                    arrayList.add(this.normalize(policy));
                    continue;
                }
                URI uRI = null;
                try {
                    uRI = new URI(string2);
                    InputStream exception = uRI.toURL().openStream();
                    Policy policy2 = Element2PolicyComponent.parsePolicy(exception, (PolicyParserListener)this);
                    arrayList.add(this.normalize(policy2));
                }
                catch (Exception exception) {
                    if (!ENDPOINT.isDebugEnabled()) continue;
                    ENDPOINT.debug(exception);
                }
            }
        }
        return arrayList;
    }

    public PolicyMap resolvePolicyAttachments(Definition definition) {
        PolicyMap policyMap = PolicyMap.createAttachments();
        Collection collection = null;
        PolicySubject policySubject = null;
        PolicyMapKey policyMapKey = null;
        String string = definition.getTargetNamespace().toString();
        for (WSDLElement wSDLElement : MapIterator.newInstance(definition.getServices())) {
            QName qName = ((Service)wSDLElement).getQName();
            collection = this.ENDPOINT((ElementExtensible)wSDLElement);
            if (collection.size() > 0) {
                policyMapKey = PolicyMap.createWsdlServiceScopeKey(qName);
                policySubject = new PolicySubject(wSDLElement, collection);
                policyMap.putSubject(PolicyMap.ScopeType.SERVICE, policyMapKey, policySubject);
            }
            for (WSDLElement wSDLElement2 : MapIterator.newInstance(((Service)wSDLElement).getPorts())) {
                PortType portType;
                Binding binding;
                QName qName2 = new QName(string, ((Port)wSDLElement2).getName().toString());
                policyMapKey = PolicyMap.createWsdlEndpointScopeKey(qName, qName2);
                collection = this.ENDPOINT((ElementExtensible)wSDLElement2);
                if (collection.size() > 0) {
                    policySubject = new PolicySubject(wSDLElement2, collection);
                    policyMap.putSubject(PolicyMap.ScopeType.ENDPOINT, policyMapKey, policySubject);
                }
                if ((collection = this.ENDPOINT((ElementExtensible)(binding = ((Port)wSDLElement2).getBinding()))).size() > 0) {
                    policySubject = new PolicySubject(binding, collection);
                    policyMap.putSubject(PolicyMap.ScopeType.ENDPOINT, policyMapKey, policySubject);
                }
                if ((collection = this.ENDPOINT((ElementExtensible)(portType = binding.getPortType()))).size() > 0) {
                    policySubject = new PolicySubject(portType, collection);
                    policyMap.putSubject(PolicyMap.ScopeType.ENDPOINT, policyMapKey, policySubject);
                }
                for (Object e : binding.getBindingOperations()) {
                    QName qName3;
                    BindingOutput bindingOutput;
                    Output output;
                    BindingInput bindingInput;
                    Input input;
                    BindingOperation bindingOperation = (BindingOperation)e;
                    Operation operation = bindingOperation.getOperation();
                    QName qName4 = new QName(string, operation.getName());
                    policyMapKey = PolicyMap.createWsdlOperationScopeKey(qName, qName2, qName4);
                    collection = this.ENDPOINT((ElementExtensible)operation);
                    if (collection.size() > 0) {
                        policySubject = new PolicySubject(operation, collection);
                        policyMap.putSubject(PolicyMap.ScopeType.OPERATION, policyMapKey, policySubject);
                    }
                    if ((collection = this.ENDPOINT((ElementExtensible)bindingOperation)).size() > 0) {
                        policySubject = new PolicySubject(bindingOperation, collection);
                        policyMap.putSubject(PolicyMap.ScopeType.OPERATION, policyMapKey, policySubject);
                    }
                    if ((collection = this.ENDPOINT((ElementExtensible)(input = operation.getInput()))).size() > 0) {
                        policySubject = new PolicySubject(input, collection);
                        policyMap.putSubject(PolicyMap.ScopeType.INPUT_MESSAGE, policyMapKey, policySubject);
                    }
                    if ((collection = this.ENDPOINT((ElementExtensible)(bindingInput = bindingOperation.getBindingInput()))).size() > 0) {
                        policySubject = new PolicySubject(bindingInput, collection);
                        policyMap.putSubject(PolicyMap.ScopeType.INPUT_MESSAGE, policyMapKey, policySubject);
                    }
                    if ((collection = this.ENDPOINT((ElementExtensible)(output = operation.getOutput()))).size() > 0) {
                        policySubject = new PolicySubject(output, collection);
                        policyMap.putSubject(PolicyMap.ScopeType.OUTPUT_MESSAGE, policyMapKey, policySubject);
                    }
                    if ((collection = this.ENDPOINT((ElementExtensible)(bindingOutput = bindingOperation.getBindingOutput()))).size() > 0) {
                        policySubject = new PolicySubject(bindingOutput, collection);
                        policyMap.putSubject(PolicyMap.ScopeType.OUTPUT_MESSAGE, policyMapKey, policySubject);
                    }
                    for (WSDLElement wSDLElement3 : MapIterator.newInstance(operation.getFaults())) {
                        qName3 = new QName(string, ((Fault)wSDLElement3).getName());
                        policyMapKey = PolicyMap.createWsdlFaultMessageScopeKey(qName, qName2, qName4, qName3);
                        collection = this.ENDPOINT((ElementExtensible)wSDLElement3);
                        if (collection.size() <= 0) continue;
                        policySubject = new PolicySubject(bindingOutput, collection);
                        policyMap.putSubject(PolicyMap.ScopeType.FAULT_MESSAGE, policyMapKey, policySubject);
                    }
                    for (WSDLElement wSDLElement3 : MapIterator.newInstance(bindingOperation.getBindingFaults())) {
                        qName3 = new QName(string, ((BindingFault)wSDLElement3).getName());
                        policyMapKey = PolicyMap.createWsdlFaultMessageScopeKey(qName, qName2, qName4, qName3);
                        collection = this.ENDPOINT((ElementExtensible)wSDLElement3);
                        if (collection.size() <= 0) continue;
                        policySubject = new PolicySubject(bindingOutput, collection);
                        policyMap.putSubject(PolicyMap.ScopeType.FAULT_MESSAGE, policyMapKey, policySubject);
                    }
                }
            }
        }
        return policyMap;
    }

    static {
        parentTypes.add(Binding.class);
        parentTypes.add(BindingFault.class);
        parentTypes.add(BindingInput.class);
        parentTypes.add(BindingOperation.class);
        parentTypes.add(BindingOutput.class);
        parentTypes.add(Definition.class);
        parentTypes.add(Fault.class);
        parentTypes.add(Input.class);
        parentTypes.add(Message.class);
        parentTypes.add(Operation.class);
        parentTypes.add(OperationType.class);
        parentTypes.add(Output.class);
        parentTypes.add(Part.class);
        parentTypes.add(Port.class);
        parentTypes.add(PortType.class);
        parentTypes.add(Service.class);
        FAULT_MESSAGE = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyURIs", "wsp");
    }
}

