/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.policy.parser;

import com.jinfonet.webservice.policy.Policy;
import com.jinfonet.webservice.policy.PolicyComponent;
import com.jinfonet.webservice.policy.PolicyMap;
import com.jinfonet.webservice.policy.PolicyMapKey;
import com.jinfonet.webservice.policy.PolicyReference;
import com.jinfonet.webservice.policy.PolicySubject;
import com.jinfonet.webservice.policy.WSDL20PolicyExtensionWrapper;
import com.jinfonet.webservice.policy.parser.Element2PolicyComponent;
import com.jinfonet.webservice.policy.parser.PolicyParserListener;
import com.jinfonet.webservice.policy.parser.WSDLPolicyExtensionDeserializer;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import jet.log.JRLogger;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.wsdl20.extensions.AttributeExtensible;
import org.apache.woden.wsdl20.extensions.ElementExtensible;
import org.apache.woden.wsdl20.extensions.ExtensionDeserializer;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.xml.BindingElement;
import org.apache.woden.wsdl20.xml.BindingFaultElement;
import org.apache.woden.wsdl20.xml.BindingFaultReferenceElement;
import org.apache.woden.wsdl20.xml.BindingMessageReferenceElement;
import org.apache.woden.wsdl20.xml.BindingOperationElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.EndpointElement;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.ServiceElement;
import org.apache.woden.xml.XMLAttr;
import org.w3c.dom.Element;

public class WSDL20PolicyExtensionDeserializer
extends WSDLPolicyExtensionDeserializer
implements ExtensionDeserializer {
    private static JRLogger ENDPOINT = JRLogger.getLogger(WSDL20PolicyExtensionDeserializer.class.getName());
    private static QName FAULT_MESSAGE;

    public ExtensionElement unmarshall(Class clazz, Object object, QName qName, XMLElement xMLElement, DescriptionElement descriptionElement, ExtensionRegistry extensionRegistry) throws WSDLException {
        if (!(xMLElement.getSource() instanceof Element)) {
            throw new WSDLException("Must based on w3c.Element", "");
        }
        Element element = (Element)xMLElement.getSource();
        String string = descriptionElement.getTargetNamespace().toString();
        this.baseUri = descriptionElement.getDocumentBaseURI().toString();
        if (ENDPOINT.isDebugEnabled()) {
            ENDPOINT.debug("Unmarshall policy: parentType=" + clazz.getName() + " extType=" + qName + " tns=" + string + " baseUri=" + this.baseUri);
        }
        WSDL20PolicyExtensionWrapper wSDL20PolicyExtensionWrapper = null;
        if ("Policy".equals(qName.getLocalPart())) {
            Policy policy = Element2PolicyComponent.parsePolicy(element, (PolicyParserListener)this);
            wSDL20PolicyExtensionWrapper = new WSDL20PolicyExtensionWrapper(policy);
            String string2 = policy.getId();
            if (ENDPOINT.isDebugEnabled()) {
                ENDPOINT.debug("policyId=" + string2);
            }
            if (null != string2 && !"".equals(string2)) {
                String string3 = this.baseUri + "#" + string2;
                if (!this.policiesWithId.containsKey(string3)) {
                    this.policiesWithId.put(string3, policy);
                }
            } else {
                policy.setId(this.createAnonymousPolicyId());
            }
        } else if ("PolicyReference".equals(qName.getLocalPart())) {
            PolicyReference policyReference = Element2PolicyComponent.parsePolicyReference(element, this);
            wSDL20PolicyExtensionWrapper = new WSDL20PolicyExtensionWrapper(policyReference);
        }
        if (null != wSDL20PolicyExtensionWrapper) {
            wSDL20PolicyExtensionWrapper.setExtensionType(qName);
        }
        return wSDL20PolicyExtensionWrapper;
    }

    private Collection ENDPOINT(ElementExtensible elementExtensible) {
        ArrayList<Policy> arrayList = new ArrayList<Policy>();
        if (null == elementExtensible) {
            return arrayList;
        }
        Policy policy = null;
        for (QName qName : policyQNames) {
            for (ExtensionElement extensionElement : elementExtensible.getExtensionElementsOfType(qName)) {
                PolicyComponent object = ((WSDL20PolicyExtensionWrapper)extensionElement).getWrappedPolicyCompnent();
                policy = (Policy)object;
                arrayList.add(this.normalize(policy));
            }
        }
        for (QName qName : policyReferenceQNames) {
            for (ExtensionElement extensionElement : elementExtensible.getExtensionElementsOfType(qName)) {
                PolicyComponent policyComponent = ((WSDL20PolicyExtensionWrapper)extensionElement).getWrappedPolicyCompnent();
                PolicyReference policyReference = (PolicyReference)policyComponent;
                String string = policyReference.getReferencedPolicyUri().toString();
                if (string.startsWith("#")) {
                    string = this.getBaseUri() + string;
                }
                policy = (Policy)this.policiesWithId.get(string);
                arrayList.add(this.normalize(policy));
            }
        }
        XMLAttr xMLAttr = ((AttributeExtensible)elementExtensible).getExtensionAttribute(FAULT_MESSAGE);
        if (null != xMLAttr) {
            ExtensionElement extensionElement;
            QName qName;
            qName = (QName)xMLAttr;
            String string = qName.getLocalPart();
            String string2 = "";
            String string3 = "";
            if (string.startsWith("#")) {
                string2 = "#";
                string3 = this.getBaseUri();
            } else {
                string2 = "http://";
                string3 = "";
            }
            for (String string4 : extensionElement = string.split(string2)) {
                string4 = string3 + string2 + string4;
                policy = (Policy)this.policiesWithId.get(string4);
                if (null != policy) {
                    arrayList.add(this.normalize(policy));
                    continue;
                }
                URI uRI = null;
                try {
                    uRI = new URI(string4);
                    InputStream inputStream = uRI.toURL().openStream();
                    Policy policy2 = Element2PolicyComponent.parsePolicy(inputStream, (PolicyParserListener)this);
                    arrayList.add(this.normalize(policy2));
                }
                catch (Exception exception) {
                    if (!ENDPOINT.isDebugEnabled()) continue;
                    ENDPOINT.debug(exception);
                }
            }
        }
        return arrayList;
    }

    public PolicyMap resolvePolicyAttachments(DescriptionElement descriptionElement) {
        PolicyMap policyMap = PolicyMap.createAttachments();
        Collection collection = null;
        PolicySubject policySubject = null;
        PolicyMapKey policyMapKey = null;
        String string = descriptionElement.getTargetNamespace().toString();
        for (ServiceElement serviceElement : descriptionElement.getServiceElements()) {
            QName qName = serviceElement.getName();
            collection = this.ENDPOINT((ElementExtensible)serviceElement);
            if (collection.size() > 0) {
                policyMapKey = PolicyMap.createWsdlServiceScopeKey(qName);
                policySubject = new PolicySubject(serviceElement, collection);
                policyMap.putSubject(PolicyMap.ScopeType.SERVICE, policyMapKey, policySubject);
            }
            for (EndpointElement endpointElement : serviceElement.getEndpointElements()) {
                InterfaceElement interfaceElement;
                BindingElement bindingElement;
                QName qName2 = new QName(string, endpointElement.getName().toString());
                policyMapKey = PolicyMap.createWsdlEndpointScopeKey(qName, qName2);
                collection = this.ENDPOINT((ElementExtensible)endpointElement);
                if (collection.size() > 0) {
                    policySubject = new PolicySubject(endpointElement, collection);
                    policyMap.putSubject(PolicyMap.ScopeType.ENDPOINT, policyMapKey, policySubject);
                }
                if ((collection = this.ENDPOINT((ElementExtensible)(bindingElement = endpointElement.getBindingElement()))).size() > 0) {
                    policySubject = new PolicySubject(bindingElement, collection);
                    policyMap.putSubject(PolicyMap.ScopeType.ENDPOINT, policyMapKey, policySubject);
                }
                if ((collection = this.ENDPOINT((ElementExtensible)(interfaceElement = bindingElement.getInterfaceElement()))).size() > 0) {
                    policySubject = new PolicySubject(interfaceElement, collection);
                    policyMap.putSubject(PolicyMap.ScopeType.ENDPOINT, policyMapKey, policySubject);
                }
                for (BindingOperationElement bindingOperationElement : bindingElement.getBindingOperationElements()) {
                    InterfaceOperationElement interfaceOperationElement = bindingOperationElement.getInterfaceOperationElement();
                    QName qName3 = interfaceOperationElement.getName();
                    policyMapKey = PolicyMap.createWsdlOperationScopeKey(qName, qName2, qName3);
                    collection = this.ENDPOINT((ElementExtensible)interfaceOperationElement);
                    if (collection.size() > 0) {
                        policySubject = new PolicySubject(interfaceOperationElement, collection);
                        policyMap.putSubject(PolicyMap.ScopeType.OPERATION, policyMapKey, policySubject);
                    }
                    if ((collection = this.ENDPOINT((ElementExtensible)bindingOperationElement)).size() > 0) {
                        policySubject = new PolicySubject(bindingOperationElement, collection);
                        policyMap.putSubject(PolicyMap.ScopeType.OPERATION, policyMapKey, policySubject);
                    }
                    for (BindingMessageReferenceElement bindingMessageReferenceElement : bindingOperationElement.getBindingMessageReferenceElements()) {
                        collection = this.ENDPOINT((ElementExtensible)bindingMessageReferenceElement);
                        if (collection.size() <= 0) continue;
                        policySubject = new PolicySubject(bindingMessageReferenceElement, collection);
                        if ("in".equalsIgnoreCase(bindingMessageReferenceElement.getDirection().toString())) {
                            policyMap.putSubject(PolicyMap.ScopeType.INPUT_MESSAGE, policyMapKey, policySubject);
                            continue;
                        }
                        policyMap.putSubject(PolicyMap.ScopeType.OUTPUT_MESSAGE, policyMapKey, policySubject);
                    }
                    ArrayList arrayList = new ArrayList();
                    for (BindingFaultElement bindingFaultElement : bindingElement.getBindingFaultElements()) {
                        collection = this.ENDPOINT((ElementExtensible)bindingFaultElement);
                        arrayList.addAll(collection);
                        InterfaceFaultElement interfaceFaultElement = bindingFaultElement.getInterfaceFaultElement();
                        collection = this.ENDPOINT((ElementExtensible)interfaceFaultElement);
                        arrayList.addAll(collection);
                    }
                    ArrayList arrayList2 = new ArrayList();
                    for (BindingFaultReferenceElement bindingFaultReferenceElement : bindingOperationElement.getBindingFaultReferenceElements()) {
                        collection = this.ENDPOINT((ElementExtensible)bindingFaultReferenceElement);
                        arrayList2.addAll(collection);
                        InterfaceFaultReferenceElement interfaceFaultReferenceElement = bindingFaultReferenceElement.getInterfaceFaultReferenceElement();
                        collection = this.ENDPOINT((ElementExtensible)interfaceFaultReferenceElement);
                        arrayList2.addAll(collection);
                        arrayList2.addAll(arrayList);
                        if (arrayList2.size() > 0) {
                            policySubject = new PolicySubject(bindingFaultReferenceElement, arrayList2);
                            policyMapKey = PolicyMap.createWsdlFaultMessageScopeKey(qName, qName2, qName3, bindingFaultReferenceElement.getRef());
                            policyMap.putSubject(PolicyMap.ScopeType.FAULT_MESSAGE, policyMapKey, policySubject);
                        }
                        arrayList2.clear();
                    }
                }
            }
        }
        return policyMap;
    }

    static {
        parentTypes.add(DescriptionElement.class);
        parentTypes.add(BindingElement.class);
        parentTypes.add(BindingFaultElement.class);
        parentTypes.add(BindingMessageReferenceElement.class);
        parentTypes.add(BindingFaultReferenceElement.class);
        parentTypes.add(BindingOperationElement.class);
        parentTypes.add(EndpointElement.class);
        parentTypes.add(InterfaceElement.class);
        parentTypes.add(InterfaceFaultElement.class);
        parentTypes.add(InterfaceFaultReferenceElement.class);
        parentTypes.add(InterfaceMessageReferenceElement.class);
        parentTypes.add(InterfaceOperationElement.class);
        parentTypes.add(ServiceElement.class);
        FAULT_MESSAGE = new QName("http://www.w3.org/ns/ws-policy", "PolicyURIs", "wsp");
    }
}

