/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.api;

import com.jinfonet.util.JRLog;
import com.jinfonet.webservice.security.api.WSSecurityContext;
import com.jinfonet.webservice.security.api.WSSecurityProcessor;
import jet.dataengine.api.DSException;

public abstract class WSSecurityProcessorFactory {
    private static WSSecurityProcessorFactory SEDU;

    protected WSSecurityProcessorFactory() {
    }

    public static synchronized WSSecurityProcessor create(WSSecurityContext wSSecurityContext) throws DSException {
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "WSSecurityProcessor: WSSecurityContext is " + wSSecurityContext);
        }
        WSSecurityProcessorFactory wSSecurityProcessorFactory = WSSecurityProcessorFactory.SEDU(wSSecurityContext);
        return wSSecurityProcessorFactory.createSecurityProcessor(wSSecurityContext);
    }

    protected abstract WSSecurityProcessor createSecurityProcessor(WSSecurityContext var1) throws DSException;

    private static synchronized WSSecurityProcessorFactory SEDU(WSSecurityContext wSSecurityContext) throws DSException {
        try {
            if (SEDU == null) {
                Class<?> clazz = Class.forName("com.jinfonet.webservice.security.impl.SecurityProcessorConcreteFactory");
                return (WSSecurityProcessorFactory)clazz.newInstance();
            }
            return SEDU;
        }
        catch (InstantiationException instantiationException) {
            throw new DSException(1001, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DSException(1002, (Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DSException(1003, (Throwable)classNotFoundException);
        }
    }
}

