/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.impl;

import com.jinfonet.webservice.security.impl.NamespaceContextImpl;
import com.jinfonet.webservice.security.impl.SecurityData;
import com.jinfonet.webservice.security.impl.SecurityDataContext;
import com.jinfonet.webservice.security.impl.SecurityUtil;
import com.jinfonet.webservice.security.model.SupportingToken;
import com.jinfonet.webservice.security.model.Token;
import com.jinfonet.webservice.security.model.UsernameToken;
import com.jinfonet.webservice.security.model.X509Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import jet.dataengine.api.DSException;
import org.apache.ws.security.SOAP11Constants;
import org.apache.ws.security.SOAP12Constants;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityBasedResultsValidator {
    public void validate(String string, Vector vector, SecurityDataContext securityDataContext) throws DSException {
        Object object;
        SecurityData securityData = securityDataContext.getSecData();
        WSSecurityEngineResult wSSecurityEngineResult = null;
        if (securityData.isIncludeTimestamp() && (wSSecurityEngineResult = WSSecurityUtil.fetchActionResult((Vector)vector, (int)32)) == null) {
            throw new DSException(4207);
        }
        Vector vector2 = SecurityUtil.getEncryptedParts(securityDataContext);
        if (securityData != null && securityData.isSignatureProtection() && this.isSignatureRequired(securityDataContext)) {
            object = SecurityUtil.getSigElementId(securityDataContext);
            vector2.add(new WSEncryptionPart("Signature", "http://www.w3.org/2000/09/xmldsig#", "Element"));
        }
        object = SecurityUtil.getSignedParts(securityDataContext);
        if (securityData.isIncludeTimestamp() && !securityData.isTransportBinding()) {
            ((Vector)object).add(new WSEncryptionPart("timestamp"));
        }
        this.validateEncrSig(securityDataContext, vector2, (Vector)object, vector);
        if (!securityData.isTransportBinding()) {
            this.validateProtectionOrder(securityData, vector);
        }
        this.validateEncryptedParts(string, securityDataContext, vector2, vector);
        this.validateSignedPartsHeaders(securityDataContext, (Vector)object, vector);
        this.validateRequiredElements(securityDataContext);
        if (securityData.isSignatureConfirmation()) {
            this.NODESET(securityDataContext);
        }
    }

    private void NODESET(SecurityDataContext securityDataContext) throws DSException {
        Node node;
        int n;
        SecurityData securityData = securityDataContext.getSecData();
        Document document = securityDataContext.getDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagNameNS(element.getNamespaceURI(), "Header");
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!(node2 instanceof Element)) continue;
                element2 = (Element)node2;
                break;
            }
        }
        NodeList nodeList2 = element2.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node3 = nodeList2.item(i);
            if (!(node3 instanceof Element)) continue;
            element3 = (Element)node3;
            break;
        }
        NodeList nodeList3 = element3.getElementsByTagNameNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "SignatureConfirmation");
        for (n = 0; n < nodeList3.getLength(); ++n) {
            node = nodeList3.item(n);
            if (!(node instanceof Element)) continue;
            element4 = (Element)node;
        }
        if (element4 == null) {
            throw new DSException(4208);
        }
        n = securityData.isSymmetricBinding() && securityData.getSignatureToken() != null || !securityData.isSymmetricBinding() && !securityData.isTransportBinding() && securityData.getInitiatorToken() != null ? 1 : 0;
        node = element4.getAttributeNode("Value");
        if (n != 0 && node == null) {
            throw new DSException(4209);
        }
        if (n == 0 && node != null) {
            throw new DSException(4210);
        }
        if (node != null && securityDataContext.getSignatureValues() != null && !securityDataContext.getSignatureValues().contains(node.getValue())) {
            throw new DSException(4211, new String[]{node.getValue()});
        }
    }

    protected void handleSupportingTokens(Vector vector, SupportingToken supportingToken) throws DSException {
        if (supportingToken == null) {
            return;
        }
        ArrayList arrayList = supportingToken.getTokens();
        for (Token token : arrayList) {
            WSSecurityEngineResult wSSecurityEngineResult;
            if (token instanceof UsernameToken) {
                wSSecurityEngineResult = WSSecurityUtil.fetchActionResult((Vector)vector, (int)1);
                if (wSSecurityEngineResult != null) continue;
                throw new DSException(4212);
            }
            if (!(token instanceof X509Token) || (wSSecurityEngineResult = WSSecurityUtil.fetchActionResult((Vector)vector, (int)4096)) != null) continue;
            throw new DSException(4213);
        }
    }

    protected void validateSupportingTokens(SecurityData securityData, Vector vector) throws DSException {
        SupportingToken supportingToken;
        Vector vector2 = securityData.getSupportingTokensList();
        for (int i = 0; i < vector2.size(); ++i) {
            supportingToken = (SupportingToken)vector2.get(i);
            this.handleSupportingTokens(vector, supportingToken);
        }
        SupportingToken supportingToken2 = securityData.getSignedSupportingTokens();
        this.handleSupportingTokens(vector, supportingToken2);
        supportingToken = securityData.getSignedEndorsingSupportingTokens();
        this.handleSupportingTokens(vector, supportingToken);
        SupportingToken supportingToken3 = securityData.getEndorsingSupportingTokens();
        this.handleSupportingTokens(vector, supportingToken3);
    }

    public void validateRequiredElements(SecurityDataContext securityDataContext) throws DSException {
        SecurityData securityData = securityDataContext.getSecData();
        Element element = securityDataContext.getDocument().getDocumentElement();
        for (String string : securityData.getRequiredElements()) {
            if (SecurityUtil.checkRequiredElements(element, securityData.getDeclaredNamespaces(), string)) continue;
            throw new DSException(4214, new String[]{string});
        }
    }

    public static WSSecurityEngineResult[] fetchActionResults(Vector vector, int n) {
        ArrayList<WSSecurityEngineResult> arrayList = new ArrayList<WSSecurityEngineResult>();
        for (int i = 0; i < vector.size(); ++i) {
            WSSecurityEngineResult wSSecurityEngineResult = (WSSecurityEngineResult)vector.get(i);
            int n2 = (Integer)wSSecurityEngineResult.get((Object)"action");
            if (n2 != n) continue;
            arrayList.add((WSSecurityEngineResult)vector.get(i));
        }
        return arrayList.toArray(new WSSecurityEngineResult[arrayList.size()]);
    }

    protected void validateSignedPartsHeaders(SecurityDataContext securityDataContext, Vector vector, Vector vector2) throws DSException {
        Object object;
        WSSecurityEngineResult wSSecurityEngineResult;
        int n;
        Node node = securityDataContext.getDocument().getFirstChild();
        WSSecurityEngineResult[] wSSecurityEngineResultArray = SecurityBasedResultsValidator.fetchActionResults(vector2, 2);
        Vector<Element> vector3 = new Vector<Element>();
        if (wSSecurityEngineResultArray != null) {
            for (n = 0; n < wSSecurityEngineResultArray.length; ++n) {
                wSSecurityEngineResult = wSSecurityEngineResultArray[n];
                object = (Set)wSSecurityEngineResult.get((Object)"signed-element-ids");
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Element element = WSSecurityUtil.findElementById((Node)node, (String)string, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                    vector3.add(element);
                }
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            wSSecurityEngineResult = (WSEncryptionPart)vector.get(n);
            if (wSSecurityEngineResult.getType() == 2) {
                object = "http://schemas.xmlsoap.org/soap/envelope/".equals(node.getNamespaceURI()) ? WSSecurityUtil.findBodyElement((Document)securityDataContext.getDocument(), (SOAPConstants)new SOAP11Constants()) : WSSecurityUtil.findBodyElement((Document)securityDataContext.getDocument(), (SOAPConstants)new SOAP12Constants());
                if (vector3.contains(object)) continue;
                throw new DSException(4215);
            }
            if (wSSecurityEngineResult.getType() != 1 && wSSecurityEngineResult.getType() != 3 || (object = (Element)WSSecurityUtil.findElement((Node)node, (String)wSSecurityEngineResult.getName(), (String)wSSecurityEngineResult.getNamespace())) == null || vector3.contains(object)) continue;
            int n2 = wSSecurityEngineResult.getType() == 1 ? 4216 : 4217;
            throw new DSException(n2, new String[]{object.getNamespaceURI(), object.getLocalName()});
        }
    }

    private String SEDU(String string, NamespaceContext namespaceContext) {
        return null;
    }

    protected void validateEncryptedParts(String string, SecurityDataContext securityDataContext, Vector vector, Vector vector2) throws DSException {
        ArrayList arrayList = this.getEncryptedReferences(vector2);
        SecurityData securityData = securityDataContext.getSecData();
        Element element = securityDataContext.getDocument().getDocumentElement();
        Set set = SecurityUtil.findAllPrefixNamespaces(element, securityData.getDeclaredNamespaces());
        try {
            Object object;
            WSDataRef wSDataRef;
            int n;
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            xPath.setNamespaceContext(new NamespaceContextImpl(set));
            HashMap<Node, Boolean> hashMap = new HashMap<Node, Boolean>();
            for (n = 0; n < arrayList.size(); ++n) {
                wSDataRef = (WSDataRef)arrayList.get(n);
                if (wSDataRef == null || wSDataRef.getXpath() == null) continue;
                object = xPath.compile(wSDataRef.getXpath());
                NodeList nodeList = (NodeList)object.evaluate(element, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    hashMap.put(nodeList.item(i), wSDataRef.isContent());
                }
            }
            if (securityData.isEncryptBody() && !this.booleanValue(arrayList, string)) {
                throw new DSException(4218, new String[]{string});
            }
            for (n = 0; n < vector.size(); ++n) {
                wSDataRef = (WSEncryptionPart)vector.get(n);
                if (wSDataRef.getType() == 2) continue;
                if ("Signature".equals(wSDataRef.getName()) && "http://www.w3.org/2000/09/xmldsig#".equals(wSDataRef.getNamespace()) || wSDataRef.getType() == 1) {
                    if (this.add(arrayList, new QName(wSDataRef.getNamespace(), wSDataRef.getName()))) continue;
                    throw new DSException(4219, new String[]{wSDataRef.getNamespace(), wSDataRef.getName()});
                }
                object = wSDataRef.getXpath();
                boolean bl = false;
                XPathExpression xPathExpression = xPath.compile((String)object);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Object v = hashMap.get(nodeList.item(i));
                    if (v == null || !("Element".equals(wSDataRef.getEncModifier()) ^ (Boolean)v)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new DSException(4220, new String[]{object});
            }
        }
        catch (Exception exception) {
            throw new DSException(4221, (Throwable)exception);
        }
    }

    private boolean add(ArrayList arrayList, QName qName) {
        for (int i = 0; i < arrayList.size(); ++i) {
            QName qName2;
            WSDataRef wSDataRef = (WSDataRef)arrayList.get(i);
            if (wSDataRef == null || (qName2 = wSDataRef.getName()) == null || !qName2.equals(qName)) continue;
            return true;
        }
        return false;
    }

    private boolean booleanValue(ArrayList arrayList, String string) {
        if (string != null && string.charAt(0) == '#') {
            string = string.substring(1);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            WSDataRef wSDataRef = (WSDataRef)arrayList.get(i);
            if (wSDataRef == null) continue;
            String string2 = wSDataRef.getWsuId();
            if (string2 == null) {
                string2 = wSDataRef.getDataref();
            }
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    protected ArrayList getEncryptedReferences(Vector vector) {
        ArrayList arrayList = this.getResults(vector, 4);
        ArrayList<WSDataRef> arrayList2 = new ArrayList<WSDataRef>();
        for (WSSecurityEngineResult wSSecurityEngineResult : arrayList) {
            ArrayList arrayList3 = (ArrayList)wSSecurityEngineResult.get((Object)"data-ref-uris");
            if (arrayList3 == null) continue;
            for (WSDataRef wSDataRef : arrayList3) {
                arrayList2.add(wSDataRef);
            }
        }
        return arrayList2;
    }

    protected void validateProtectionOrder(SecurityData securityData, Vector vector) throws DSException {
        String string = securityData.getProtectionOrder();
        ArrayList arrayList = this.getSigEncrActions(vector);
        if (arrayList.size() < 2) {
            return;
        }
        boolean bl = true;
        boolean bl2 = true;
        for (Integer n : arrayList) {
            if (n == 2) {
                bl = false;
                continue;
            }
            if (n != 4) continue;
            bl2 = false;
        }
        if (bl || bl2) {
            return;
        }
        boolean bl3 = false;
        if ("SignBeforeEncrypting".equals(string)) {
            Integer n;
            boolean bl4 = false;
            Iterator iterator = arrayList.iterator();
            while (!(!iterator.hasNext() && bl3 || (n = (Integer)iterator.next()) == 4 && !bl4)) {
                if (n == 2) {
                    bl4 = true;
                    continue;
                }
                if (!bl4) continue;
                bl3 = true;
            }
        } else {
            Integer n;
            boolean bl5 = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && ((n = (Integer)iterator.next()) != 2 || bl5)) {
                if (n == 4) {
                    bl5 = true;
                    continue;
                }
                if (!bl5) continue;
                bl3 = true;
            }
        }
        if (!bl3) {
            throw new DSException(4222, new String[]{string});
        }
    }

    protected boolean isSignatureRequired(SecurityDataContext securityDataContext) {
        SecurityData securityData = securityDataContext.getSecData();
        return securityData.isSymmetricBinding() && securityData.getSignatureToken() != null || !securityData.isSymmetricBinding() && !securityData.isTransportBinding() && (securityData.getInitiatorToken() != null && securityDataContext.isInitiator() || securityData.getRecipientToken() != null && !securityDataContext.isInitiator());
    }

    protected ArrayList getSigEncrActions(Vector vector) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)((WSSecurityEngineResult)iterator.next()).get((Object)"action");
            int n2 = n;
            if (2 != n2 && 4 != n2) continue;
            arrayList.add(new Integer(n2));
        }
        return arrayList;
    }

    protected ArrayList getResults(Vector vector, int n) {
        ArrayList<WSSecurityEngineResult> arrayList = new ArrayList<WSSecurityEngineResult>();
        for (int i = 0; i < vector.size(); ++i) {
            Integer n2 = (Integer)((WSSecurityEngineResult)vector.get(i)).get((Object)"action");
            if (n2 != n) continue;
            arrayList.add((WSSecurityEngineResult)vector.get(i));
        }
        return arrayList;
    }

    protected void validateEncrSig(SecurityDataContext securityDataContext, Vector vector, Vector vector2, Vector vector3) throws DSException {
        Object object2;
        ArrayList arrayList = this.getSigEncrActions(vector3);
        boolean bl = false;
        boolean bl2 = false;
        for (Object object2 : arrayList) {
            if ((Integer)object2 == 2) {
                bl = true;
                continue;
            }
            if ((Integer)object2 != 4) continue;
            bl2 = true;
        }
        SecurityData securityData = securityDataContext.getSecData();
        object2 = securityData.getSignedSupportingTokens();
        SupportingToken supportingToken = securityData.getSignedEndorsingSupportingTokens();
        if (!(!bl || vector2.size() != 0 || object2 != null && ((SupportingToken)object2).getTokens().size() != 0 || supportingToken != null && supportingToken.getTokens().size() != 0)) {
            throw new DSException(4223);
        }
        if (!bl && vector2.size() > 0) {
            throw new DSException(4223);
        }
        if (bl2 && vector.size() == 0) {
            ArrayList arrayList2 = this.getResults(vector3, 4);
            boolean bl3 = false;
            for (WSSecurityEngineResult wSSecurityEngineResult : arrayList2) {
                ArrayList arrayList3 = (ArrayList)wSSecurityEngineResult.get((Object)"data-ref-uris");
                if (arrayList3 == null || arrayList3.size() == 0) continue;
                bl3 = true;
            }
            if (bl3 && !this.isUsernameTokenPresent(securityData)) {
                throw new DSException(4224);
            }
        } else if (!bl2 && vector.size() > 0) {
            throw new DSException(4225);
        }
    }

    protected boolean isUsernameTokenPresent(SecurityData securityData) {
        SupportingToken supportingToken;
        Vector vector = securityData.getSupportingTokensList();
        for (int i = 0; i < vector.size(); ++i) {
            supportingToken = (SupportingToken)vector.get(i);
            if (!this.isUsernameTokenPresent(supportingToken)) continue;
            return true;
        }
        SupportingToken supportingToken2 = securityData.getSignedSupportingTokens();
        if (this.isUsernameTokenPresent(supportingToken2)) {
            return true;
        }
        supportingToken = securityData.getSignedEndorsingSupportingTokens();
        if (this.isUsernameTokenPresent(supportingToken)) {
            return true;
        }
        SupportingToken supportingToken3 = securityData.getEndorsingSupportingTokens();
        return this.isUsernameTokenPresent(supportingToken3);
    }

    protected boolean isUsernameTokenPresent(SupportingToken supportingToken) {
        if (supportingToken == null) {
            return false;
        }
        ArrayList arrayList = supportingToken.getTokens();
        for (Token token : arrayList) {
            if (!(token instanceof UsernameToken)) continue;
            return true;
        }
        return false;
    }
}

