/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.impl;

import com.jinfonet.webservice.security.impl.SecurityData;
import com.jinfonet.webservice.security.model.AbstractSecurityAssertion;
import com.jinfonet.webservice.security.model.AsymmetricBinding;
import com.jinfonet.webservice.security.model.Binding;
import com.jinfonet.webservice.security.model.ContentEncryptedElements;
import com.jinfonet.webservice.security.model.EncryptionToken;
import com.jinfonet.webservice.security.model.Header;
import com.jinfonet.webservice.security.model.InitiatorToken;
import com.jinfonet.webservice.security.model.ProtectionToken;
import com.jinfonet.webservice.security.model.RecipientToken;
import com.jinfonet.webservice.security.model.RequiredElements;
import com.jinfonet.webservice.security.model.SignatureToken;
import com.jinfonet.webservice.security.model.SignedEncryptedElements;
import com.jinfonet.webservice.security.model.SignedEncryptedParts;
import com.jinfonet.webservice.security.model.SupportingToken;
import com.jinfonet.webservice.security.model.SymmetricAsymmetricBindingBase;
import com.jinfonet.webservice.security.model.SymmetricBinding;
import com.jinfonet.webservice.security.model.TransportBinding;
import com.jinfonet.webservice.security.model.TransportToken;
import com.jinfonet.webservice.security.model.Trust10;
import com.jinfonet.webservice.security.model.Wss10;
import com.jinfonet.webservice.security.model.Wss11;
import java.util.Iterator;
import jet.dataengine.api.DSException;

public class SecurityDataBuilder {
    public static SecurityData build(AbstractSecurityAssertion[] abstractSecurityAssertionArray) throws DSException {
        SecurityData securityData = new SecurityData();
        for (int i = 0; i < abstractSecurityAssertionArray.length; ++i) {
            AbstractSecurityAssertion abstractSecurityAssertion = abstractSecurityAssertionArray[i];
            if (abstractSecurityAssertion instanceof Binding) {
                if (abstractSecurityAssertion instanceof SymmetricBinding) {
                    SecurityDataBuilder.addSignedPart((SymmetricBinding)abstractSecurityAssertion, securityData);
                    continue;
                }
                if (abstractSecurityAssertion instanceof AsymmetricBinding) {
                    SecurityDataBuilder.getDeclaredNamespaces((AsymmetricBinding)abstractSecurityAssertion, securityData);
                    continue;
                }
                SecurityDataBuilder.SEDU((TransportBinding)abstractSecurityAssertion, securityData);
                continue;
            }
            if (abstractSecurityAssertion instanceof Wss11) {
                SecurityDataBuilder.getEncryptionToken((Wss11)abstractSecurityAssertion, securityData);
                continue;
            }
            if (abstractSecurityAssertion instanceof Wss10) {
                SecurityDataBuilder.getAlgorithmSuite((Wss10)abstractSecurityAssertion, securityData);
                continue;
            }
            if (abstractSecurityAssertion instanceof SignedEncryptedElements) {
                SecurityDataBuilder.getHeaders((SignedEncryptedElements)abstractSecurityAssertion, securityData);
                continue;
            }
            if (abstractSecurityAssertion instanceof SignedEncryptedParts) {
                SecurityDataBuilder.getInitiatorToken((SignedEncryptedParts)abstractSecurityAssertion, securityData);
                continue;
            }
            if (abstractSecurityAssertion instanceof RequiredElements) {
                SecurityDataBuilder.getName((RequiredElements)abstractSecurityAssertion, securityData);
                continue;
            }
            if (abstractSecurityAssertion instanceof ContentEncryptedElements) {
                SecurityDataBuilder.getLayout((ContentEncryptedElements)abstractSecurityAssertion, securityData);
                continue;
            }
            if (abstractSecurityAssertion instanceof SupportingToken) {
                SecurityDataBuilder.getRecipientToken((SupportingToken)abstractSecurityAssertion, securityData);
                continue;
            }
            if (!(abstractSecurityAssertion instanceof Trust10)) continue;
            SecurityDataBuilder.addDeclaredNamespaces((Trust10)abstractSecurityAssertion, securityData);
        }
        return securityData;
    }

    private static void SEDU(TransportBinding transportBinding, SecurityData securityData) {
        SecurityDataBuilder.getNamespace(transportBinding, securityData);
        securityData.setTransportBinding(true);
        TransportToken transportToken = transportBinding.getTransportToken();
        if (transportToken != null) {
            securityData.setTransportToken(transportToken.getTransportToken());
        }
    }

    private static void addDeclaredNamespaces(Trust10 trust10, SecurityData securityData) {
        securityData.setTrust10(trust10);
    }

    private static void addSignedPart(SymmetricBinding symmetricBinding, SecurityData securityData) throws DSException {
        securityData.setSymmetricBinding(true);
        SecurityDataBuilder.getNamespace(symmetricBinding, securityData);
        SecurityDataBuilder.getProtectionOrder(symmetricBinding, securityData);
        SecurityDataBuilder.getProtectionToken(symmetricBinding, securityData);
    }

    private static void getAlgorithmSuite(Wss10 wss10, SecurityData securityData) {
        securityData.setWss10(wss10);
    }

    private static void getDeclaredNamespaces(AsymmetricBinding asymmetricBinding, SecurityData securityData) throws DSException {
        securityData.setAsymmetricBinding(true);
        SecurityDataBuilder.getNamespace(asymmetricBinding, securityData);
        SecurityDataBuilder.getProtectionOrder(asymmetricBinding, securityData);
        SecurityDataBuilder.getReceipientToken(asymmetricBinding, securityData);
    }

    private static void getEncryptionToken(Wss11 wss11, SecurityData securityData) {
        securityData.setSignatureConfirmation(wss11.isRequireSignatureConfirmation());
        securityData.setWss11(wss11);
    }

    private static void getHeaders(SignedEncryptedElements signedEncryptedElements, SecurityData securityData) {
        Iterator iterator = signedEncryptedElements.getXPathExpressions().iterator();
        if (signedEncryptedElements.isSignedElemets()) {
            while (iterator.hasNext()) {
                securityData.setSignedElements((String)iterator.next());
            }
        } else {
            while (iterator.hasNext()) {
                securityData.setEncryptedElements((String)iterator.next());
            }
        }
        securityData.addDeclaredNamespaces(signedEncryptedElements.getDeclaredNamespaces());
    }

    private static void getInitiatorToken(SignedEncryptedParts signedEncryptedParts, SecurityData securityData) {
        Iterator iterator = signedEncryptedParts.getHeaders().iterator();
        if (signedEncryptedParts.isSignedParts()) {
            securityData.setSignBody(signedEncryptedParts.isBody());
            securityData.setSignAttachments(signedEncryptedParts.isAttachments());
            while (iterator.hasNext()) {
                Header header = (Header)iterator.next();
                securityData.addSignedPart(header.getNamespace(), header.getName());
            }
        } else {
            securityData.setEncryptBody(signedEncryptedParts.isBody());
            securityData.setEncryptAttachments(signedEncryptedParts.isAttachments());
            while (iterator.hasNext()) {
                Header header = (Header)iterator.next();
                securityData.setEncryptedParts(header.getNamespace(), header.getName(), "Header");
            }
        }
    }

    private static void getLayout(ContentEncryptedElements contentEncryptedElements, SecurityData securityData) {
        Iterator iterator = contentEncryptedElements.getXPathExpressions().iterator();
        while (iterator.hasNext()) {
            securityData.setContentEncryptedElements((String)iterator.next());
        }
        securityData.addDeclaredNamespaces(contentEncryptedElements.getDeclaredNamespaces());
    }

    private static void getName(RequiredElements requiredElements, SecurityData securityData) {
        Iterator iterator = requiredElements.getXPathExpressions().iterator();
        while (iterator.hasNext()) {
            securityData.setRequiredElements((String)iterator.next());
        }
        securityData.addDeclaredNamespaces(requiredElements.getDeclaredNamespaces());
    }

    private static void getNamespace(Binding binding, SecurityData securityData) {
        securityData.setLayout(binding.getLayout().getValue());
        securityData.setIncludeTimestamp(binding.isIncludeTimestamp());
        securityData.setAlgorithmSuite(binding.getAlgorithmSuite());
    }

    private static void getProtectionOrder(SymmetricAsymmetricBindingBase symmetricAsymmetricBindingBase, SecurityData securityData) {
        securityData.setEntireHeadersAndBodySignatures(symmetricAsymmetricBindingBase.isEntireHeadersAndBodySignatures());
        securityData.setProtectionOrder(symmetricAsymmetricBindingBase.getProtectionOrder());
        securityData.setSignatureProtection(symmetricAsymmetricBindingBase.isSignatureProtection());
        securityData.setTokenProtection(symmetricAsymmetricBindingBase.isTokenProtection());
        securityData.setAlgorithmSuite(symmetricAsymmetricBindingBase.getAlgorithmSuite());
    }

    private static void getProtectionToken(SymmetricBinding symmetricBinding, SecurityData securityData) throws DSException {
        ProtectionToken protectionToken = symmetricBinding.getProtectionToken();
        if (protectionToken != null) {
            securityData.setProtectionToken(protectionToken.getProtectionToken());
        } else {
            EncryptionToken encryptionToken = symmetricBinding.getEncryptionToken();
            SignatureToken signatureToken = symmetricBinding.getSignatureToken();
            if (protectionToken == null && signatureToken == null) {
                throw new DSException(4227);
            }
            securityData.setEncryptionToken(encryptionToken.getEncryptionToken());
            securityData.setSignatureToken(signatureToken.getSignatureToken());
        }
    }

    private static void getReceipientToken(AsymmetricBinding asymmetricBinding, SecurityData securityData) throws DSException {
        RecipientToken recipientToken = asymmetricBinding.getRecipientToken();
        InitiatorToken initiatorToken = asymmetricBinding.getInitiatorToken();
        if (recipientToken == null || initiatorToken == null) {
            throw new DSException(4228);
        }
        securityData.setRecipientToken(recipientToken.getReceipientToken());
        securityData.setInitiatorToken(initiatorToken.getInitiatorToken());
    }

    private static void getRecipientToken(SupportingToken supportingToken, SecurityData securityData) throws DSException {
        securityData.setSupportingTokens(supportingToken);
    }
}

