/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.impl;

import com.jinfonet.util.JRLog;
import com.jinfonet.webservice.security.api.WSSecurityContext;
import com.jinfonet.webservice.security.api.WSSecurityPolicyAssertion;
import com.jinfonet.webservice.security.api.WSSecurityProcessor;
import com.jinfonet.webservice.security.impl.PwdCBHandler;
import com.jinfonet.webservice.security.impl.SP13Constants;
import com.jinfonet.webservice.security.impl.SecurityBasedResultsValidator;
import com.jinfonet.webservice.security.impl.SecurityData;
import com.jinfonet.webservice.security.impl.SecurityDataBuilder;
import com.jinfonet.webservice.security.impl.SecurityDataContext;
import com.jinfonet.webservice.security.impl.SimpleTokenStore;
import com.jinfonet.webservice.security.impl.processor.AsymmetricBindingProcessor;
import com.jinfonet.webservice.security.impl.processor.SymmetricBindingProcessor;
import com.jinfonet.webservice.security.impl.processor.TransportBindingProcessor;
import com.jinfonet.webservice.security.model.AbstractSecurityAssertion;
import com.jinfonet.webservice.security.model.SupportingToken;
import com.jinfonet.webservice.security.model.Token;
import com.jinfonet.webservice.security.model.UsernameToken;
import com.jinfonet.webservice.security.model.builders.AssertionModelBuilder;
import com.jinfonet.webservice.security.model.builders.AsymmetricBindingBuilder;
import com.jinfonet.webservice.security.model.builders.ContentEncryptedElementsBuilder;
import com.jinfonet.webservice.security.model.builders.EncryptedElementsBuilder;
import com.jinfonet.webservice.security.model.builders.EncryptedPartsBuilder;
import com.jinfonet.webservice.security.model.builders.RequiredElementsBuilder;
import com.jinfonet.webservice.security.model.builders.SignedElementsBuilder;
import com.jinfonet.webservice.security.model.builders.SignedPartsBuilder;
import com.jinfonet.webservice.security.model.builders.SupportingTokensBuilder;
import com.jinfonet.webservice.security.model.builders.SymmetricBindingBuilder;
import com.jinfonet.webservice.security.model.builders.TransportBindingBuilder;
import com.jinfonet.webservice.security.model.builders.WSS10Builder;
import com.jinfonet.webservice.security.model.builders.WSS11Builder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import jet.dataengine.api.DSException;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityProcessImpl
implements WSSecurityProcessor {
    SecurityData inputSecData;
    SecurityData outputSecData;
    private String ASYMMETRIC_BINDING;
    private String CONTENT_ENCRYPTED_ELEMENTS;
    private String ENCRYPTED_ELEMENTS;
    private String ENCRYPTED_PARTS;
    private String REQUIRED_ELEMENTS;
    private String SEDU;
    private Crypto SIGNED_ELEMENTS;
    private Crypto SIGNED_PARTS;
    private Crypto SYMMETRIC_BINDING;
    ArrayList encryptedDataRefIds = new ArrayList();
    private String TRANSPORT_BINDING;
    private SimpleTokenStore WSS10 = new SimpleTokenStore();
    private Vector WSS11 = new Vector();

    public SecurityProcessImpl(WSSecurityContext wSSecurityContext) throws DSException {
        this.ASYMMETRIC_BINDING = wSSecurityContext.getAuthUser();
        this.CONTENT_ENCRYPTED_ELEMENTS = wSSecurityContext.getAuthPaswd();
        this.ENCRYPTED_ELEMENTS = wSSecurityContext.getEncyptUser();
        this.ENCRYPTED_PARTS = wSSecurityContext.getEncyptPaswd();
        this.REQUIRED_ELEMENTS = wSSecurityContext.getSignUser();
        this.SEDU = wSSecurityContext.getSignPaswd();
        if (wSSecurityContext.getSignProp() != null) {
            this.SIGNED_ELEMENTS = CryptoFactory.getInstance((Properties)wSSecurityContext.getSignProp());
        }
        if (wSSecurityContext.getEncyptProp() != null) {
            this.SIGNED_PARTS = CryptoFactory.getInstance((Properties)wSSecurityContext.getEncyptProp());
        }
        if (wSSecurityContext.getDecryptPro() != null) {
            this.SYMMETRIC_BINDING = CryptoFactory.getInstance((Properties)wSSecurityContext.getDecryptPro());
        }
        if (wSSecurityContext.getInputAssertion() != null) {
            this.inputSecData = this.ASYMMETRIC_BINDING(wSSecurityContext.getInputAssertion());
        }
        if (wSSecurityContext.getOutputAssertion() != null) {
            this.outputSecData = this.ASYMMETRIC_BINDING(wSSecurityContext.getOutputAssertion());
        }
    }

    private SecurityData ASYMMETRIC_BINDING(WSSecurityPolicyAssertion[] wSSecurityPolicyAssertionArray) throws DSException {
        AbstractSecurityAssertion[] abstractSecurityAssertionArray = this.CONTENT_ENCRYPTED_ELEMENTS(wSSecurityPolicyAssertionArray);
        return SecurityDataBuilder.build(abstractSecurityAssertionArray);
    }

    private AbstractSecurityAssertion[] CONTENT_ENCRYPTED_ELEMENTS(WSSecurityPolicyAssertion[] wSSecurityPolicyAssertionArray) throws DSException {
        AbstractSecurityAssertion[] abstractSecurityAssertionArray = new AbstractSecurityAssertion[wSSecurityPolicyAssertionArray.length];
        for (int i = 0; i < wSSecurityPolicyAssertionArray.length; ++i) {
            AssertionModelBuilder assertionModelBuilder;
            WSSecurityPolicyAssertion wSSecurityPolicyAssertion = wSSecurityPolicyAssertionArray[i];
            QName qName = wSSecurityPolicyAssertion.getName();
            StringBuffer stringBuffer = new StringBuffer("Supporting");
            if (qName.getLocalPart().contains(stringBuffer)) {
                assertionModelBuilder = new SupportingTokensBuilder();
                abstractSecurityAssertionArray[i] = ((SupportingTokensBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.ASYMMETRIC_BINDING)) {
                assertionModelBuilder = new AsymmetricBindingBuilder();
                abstractSecurityAssertionArray[i] = ((AsymmetricBindingBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.WSS10)) {
                assertionModelBuilder = new WSS10Builder();
                abstractSecurityAssertionArray[i] = ((WSS10Builder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.SIGNED_PARTS)) {
                assertionModelBuilder = new SignedPartsBuilder();
                abstractSecurityAssertionArray[i] = ((SignedPartsBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.ENCRYPTED_PARTS)) {
                assertionModelBuilder = new EncryptedPartsBuilder();
                abstractSecurityAssertionArray[i] = ((EncryptedPartsBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.SYMMETRIC_BINDING)) {
                assertionModelBuilder = new SymmetricBindingBuilder();
                abstractSecurityAssertionArray[i] = ((SymmetricBindingBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.WSS11)) {
                assertionModelBuilder = new WSS11Builder();
                abstractSecurityAssertionArray[i] = ((WSS11Builder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.TRANSPORT_BINDING)) {
                assertionModelBuilder = new TransportBindingBuilder();
                abstractSecurityAssertionArray[i] = ((TransportBindingBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.SIGNED_ELEMENTS)) {
                assertionModelBuilder = new SignedElementsBuilder();
                abstractSecurityAssertionArray[i] = ((SignedElementsBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.ENCRYPTED_ELEMENTS)) {
                assertionModelBuilder = new EncryptedElementsBuilder();
                abstractSecurityAssertionArray[i] = ((EncryptedElementsBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.REQUIRED_ELEMENTS)) {
                assertionModelBuilder = new RequiredElementsBuilder();
                abstractSecurityAssertionArray[i] = ((RequiredElementsBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            if (qName.equals(SP13Constants.CONTENT_ENCRYPTED_ELEMENTS)) {
                assertionModelBuilder = new ContentEncryptedElementsBuilder();
                abstractSecurityAssertionArray[i] = ((ContentEncryptedElementsBuilder)assertionModelBuilder).build(wSSecurityPolicyAssertion);
                continue;
            }
            throw new DSException(4229, new String[]{qName.toString()});
        }
        return abstractSecurityAssertionArray;
    }

    private static boolean ENCRYPTED_ELEMENTS(SecurityData securityData) {
        if (securityData.isIncludeTimestamp()) {
            return true;
        }
        if (securityData.isSignBody() || securityData.getSignedParts().size() != 0 || securityData.getSignedElements().size() != 0) {
            return true;
        }
        return securityData.isEncryptBody() || securityData.getEncryptedParts().size() != 0 || securityData.getEncryptedElements().size() != 0;
    }

    @Override
    public void decrypt(Document document) throws DSException {
        Object object;
        NodeList nodeList;
        if (this.outputSecData == null) {
            throw new DSException(4230);
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Document before docrypt:" + document);
        }
        if (!SecurityProcessImpl.ENCRYPTED_ELEMENTS(this.outputSecData)) {
            return;
        }
        SecurityDataContext securityDataContext = new SecurityDataContext(document, null, this.outputSecData);
        securityDataContext.setAuthPwd(this.CONTENT_ENCRYPTED_ELEMENTS);
        securityDataContext.setAuthUser(this.ASYMMETRIC_BINDING);
        securityDataContext.setEncrypto(this.SIGNED_PARTS);
        securityDataContext.setEncryUser(this.ENCRYPTED_ELEMENTS);
        securityDataContext.setInitiator(false);
        securityDataContext.setSignpto(this.SIGNED_ELEMENTS);
        securityDataContext.setSignPwd(this.SEDU);
        securityDataContext.setSignUser(this.REQUIRED_ELEMENTS);
        securityDataContext.setSignatureValues(this.WSS11);
        Element element = document.getDocumentElement();
        NodeList nodeList2 = element.getElementsByTagNameNS(element.getNamespaceURI(), "Header");
        Element element2 = null;
        Element element3 = null;
        if (nodeList2 != null && nodeList2.getLength() > 0) {
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (!(node instanceof Element)) continue;
                element2 = (Element)node;
                break;
            }
        } else {
            throw new DSException(4231);
        }
        if (element2 != null) {
            nodeList = element2.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                if (!(object instanceof Element)) continue;
                element3 = (Element)object;
                break;
            }
        } else {
            throw new DSException(4231);
        }
        if (element3 == null) {
            throw new DSException(4232);
        }
        nodeList = new WSSecurityEngine();
        try {
            String string = element3.getAttributeNS(element.getNamespaceURI(), "actor");
            object = new HashMap();
            ((HashMap)object).put(this.ASYMMETRIC_BINDING, this.CONTENT_ENCRYPTED_ELEMENTS);
            ((HashMap)object).put(this.REQUIRED_ELEMENTS, this.SEDU);
            ((HashMap)object).put(this.ENCRYPTED_ELEMENTS, this.ENCRYPTED_PARTS);
            PwdCBHandler pwdCBHandler = new PwdCBHandler((Map)object, this.WSS10);
            this.ENCRYPTED_PARTS(document);
            Vector vector = nodeList.processSecurityHeader(document, string, pwdCBHandler, this.SIGNED_ELEMENTS, this.SYMMETRIC_BINDING);
            if (vector == null) {
                throw new DSException(4233);
            }
            SecurityBasedResultsValidator securityBasedResultsValidator = new SecurityBasedResultsValidator();
            securityBasedResultsValidator.validate(this.TRANSPORT_BINDING, vector, securityDataContext);
        }
        catch (Exception exception) {
            throw new DSException(4234, (Throwable)exception);
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Document after decrypt:" + document);
        }
    }

    @Override
    public Document doSecurity(Document document) throws DSException {
        if (this.inputSecData == null) {
            throw new DSException(4230);
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Document before doSecurity:" + document);
        }
        WSSecHeader wSSecHeader = new WSSecHeader();
        wSSecHeader.insertSecurityHeader(document);
        SecurityDataContext securityDataContext = new SecurityDataContext(document, wSSecHeader, this.inputSecData);
        securityDataContext.setAuthPwd(this.CONTENT_ENCRYPTED_ELEMENTS);
        securityDataContext.setAuthUser(this.ASYMMETRIC_BINDING);
        securityDataContext.setEncrypto(this.SIGNED_PARTS);
        securityDataContext.setEncryUser(this.ENCRYPTED_ELEMENTS);
        securityDataContext.setInitiator(true);
        securityDataContext.setSignpto(this.SIGNED_ELEMENTS);
        securityDataContext.setSignPwd(this.SEDU);
        securityDataContext.setSignUser(this.REQUIRED_ELEMENTS);
        securityDataContext.setTokenStore(this.WSS10);
        securityDataContext.setSignatureValues(this.WSS11);
        Document document2 = null;
        if (this.inputSecData.isAsymmetricBinding()) {
            AsymmetricBindingProcessor asymmetricBindingProcessor = new AsymmetricBindingProcessor();
            asymmetricBindingProcessor.build(securityDataContext);
            document2 = securityDataContext.getDocument();
        } else if (this.inputSecData.isSymmetricBinding()) {
            SymmetricBindingProcessor symmetricBindingProcessor = new SymmetricBindingProcessor();
            symmetricBindingProcessor.build(securityDataContext);
        } else if (this.inputSecData.isTransportBinding()) {
            TransportBindingProcessor transportBindingProcessor = new TransportBindingProcessor();
            transportBindingProcessor.build(securityDataContext);
        } else {
            SupportingToken supportingToken = this.inputSecData.getSupportingTokens();
            if (supportingToken != null && supportingToken.getTokens() != null && supportingToken.getTokens().size() > 0) {
                ArrayList arrayList = supportingToken.getTokens();
                for (Token token : arrayList) {
                    if (!(token instanceof UsernameToken)) continue;
                    UsernameToken usernameToken = (UsernameToken)token;
                    WSSecUsernameToken wSSecUsernameToken = new WSSecUsernameToken();
                    if (usernameToken.isNoPassword()) {
                        wSSecUsernameToken.setUserInfo(this.ASYMMETRIC_BINDING, null);
                        wSSecUsernameToken.setPasswordType(null);
                    } else if (usernameToken.isHashPassword()) {
                        wSSecUsernameToken.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                    } else {
                        wSSecUsernameToken.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                    }
                    wSSecUsernameToken.setUserInfo(this.ASYMMETRIC_BINDING, this.CONTENT_ENCRYPTED_ELEMENTS);
                    wSSecHeader.insertSecurityHeader(document);
                    document2 = wSSecUsernameToken.build(document, wSSecHeader);
                }
            }
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Document after doSecurity:" + document2);
        }
        return document2;
    }

    private void ENCRYPTED_PARTS(Document document) throws DSException {
        Element element = document.getDocumentElement();
        if (element == null || !element.getLocalName().equals("Envelope")) {
            throw new DSException(4235);
        }
        this.REQUIRED_ELEMENTS(element, element.getNamespaceURI());
    }

    private void REQUIRED_ELEMENTS(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if (element2.getNamespaceURI() != null && element2.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") && element2.getLocalName().equals("EncryptedData")) {
                if (element.getLocalName().equals("Body") && element.getNamespaceURI().equals(string)) {
                    this.TRANSPORT_BINDING = element2.getAttribute("Id");
                    break;
                }
                this.encryptedDataRefIds.add(element2.getAttribute("Id"));
                break;
            }
            this.REQUIRED_ELEMENTS(element2, string);
        }
    }
}

