/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.impl;

import com.jinfonet.util.JRLog;
import com.jinfonet.webservice.security.impl.NamespaceContextImpl;
import com.jinfonet.webservice.security.impl.SecurityData;
import com.jinfonet.webservice.security.impl.SecurityDataContext;
import com.jinfonet.webservice.security.impl.SupportingSecurityData;
import com.jinfonet.webservice.security.model.AbstractSecurityAssertion;
import com.jinfonet.webservice.security.model.Token;
import com.jinfonet.webservice.security.model.Wss10;
import com.jinfonet.webservice.security.model.Wss11;
import com.jinfonet.webservice.security.model.X509Token;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import jet.dataengine.api.DSException;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityUtil {
    private static final String NODESET = "org.apache.ws.security.crypto.provider";
    private static Map SEDU = new Hashtable();

    public static WSPasswordCallback performCallback(CallbackHandler callbackHandler, String string, int n) throws DSException {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 64: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 4;
            }
        }
        WSPasswordCallback wSPasswordCallback = new WSPasswordCallback(string, n2);
        Callback[] callbackArray = new Callback[]{wSPasswordCallback};
        try {
            callbackHandler.handle(callbackArray);
        }
        catch (Exception exception) {
            throw new DSException(4236, (Throwable)exception);
        }
        return wSPasswordCallback;
    }

    public static int getKeyIdentifier(X509Token x509Token) throws DSException {
        if (x509Token.isRequireIssuerSerialReference()) {
            return 2;
        }
        if (x509Token.isRequireThumbprintReference()) {
            return 8;
        }
        if (x509Token.isRequireEmbeddedTokenReference()) {
            return 1;
        }
        throw new DSException(4237);
    }

    public static String addWsuIdToElement(Element element) {
        String string;
        Attr attr = element.getAttributeNode("Id");
        if (attr == null) {
            attr = element.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        }
        if (attr != null) {
            string = attr.getValue();
        } else {
            element.setAttribute("xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            string = "Id-" + element.hashCode();
            String string2 = "wsu:Id";
            element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", string2, string);
        }
        return string;
    }

    public static Element appendChildToSecHeader(SecurityDataContext securityDataContext, Element element) {
        Element element2 = securityDataContext.getSecHeader().getSecurityHeader();
        Node node = element2.getOwnerDocument().importNode(element, true);
        return (Element)element2.appendChild(node);
    }

    public static Vector getEncryptedParts(SecurityDataContext securityDataContext) throws DSException {
        SecurityData securityData = securityDataContext.getSecData();
        Document document = securityDataContext.getDocument();
        Vector vector = SecurityUtil.getPartsAndElements(false, document, securityData.isEncryptBody(), securityData.getEncryptedParts(), securityData.getEncryptedElements(), securityData.getDeclaredNamespaces());
        return SecurityUtil.getContentEncryptedElements(vector, document, securityData.getContentEncryptedElements(), securityData.getDeclaredNamespaces());
    }

    public static Vector getSignedParts(SecurityDataContext securityDataContext) throws DSException {
        SecurityData securityData = securityDataContext.getSecData();
        Document document = securityDataContext.getDocument();
        return SecurityUtil.getPartsAndElements(true, document, securityData.isSignBody(), securityData.getSignedParts(), securityData.getSignedElements(), securityData.getDeclaredNamespaces());
    }

    public static Vector getSupportingEncryptedParts(SecurityDataContext securityDataContext, SupportingSecurityData supportingSecurityData) throws DSException {
        Document document = securityDataContext.getDocument();
        return SecurityUtil.getPartsAndElements(false, document, supportingSecurityData.isEncryptBody(), supportingSecurityData.getEncryptedParts(), supportingSecurityData.getEncryptedElements(), supportingSecurityData.getDeclaredNamespaces());
    }

    public static Vector getSupportingSignedParts(SecurityDataContext securityDataContext, SupportingSecurityData supportingSecurityData) throws DSException {
        Document document = securityDataContext.getDocument();
        return SecurityUtil.getPartsAndElements(true, document, supportingSecurityData.isSignBody(), supportingSecurityData.getSignedParts(), supportingSecurityData.getSignedElements(), supportingSecurityData.getDeclaredNamespaces());
    }

    public static Set findAllPrefixNamespaces(Node node, HashMap hashMap) {
        HashSet<QName> hashSet = new HashSet<QName>();
        SecurityUtil.NODESET(node, hashSet);
        List list = SecurityUtil.SEDU();
        for (Object object : list) {
            if (hashSet.contains(object)) continue;
            hashSet.add((QName)object);
        }
        for (Object object : hashMap.keySet()) {
            String string = (String)hashMap.get(object);
            QName qName = new QName(string, "NotUserLocalPart", (String)object);
            if (hashSet.contains(qName)) continue;
            hashSet.add(qName);
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    private static void NODESET(Node node, Set set) {
        void var5_10;
        NamedNodeMap namedNodeMap = node.getAttributes();
        ArrayList<QName> arrayList = new ArrayList<QName>();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr object = (Attr)namedNodeMap.item(i);
                String string = object.getName();
                if (!string.startsWith("xmlns:")) continue;
                String string2 = string.substring(string.indexOf(":") + 1);
                String string3 = object.getValue();
                arrayList.add(new QName(string3, "NotUserLocalPart", string2));
            }
        }
        for (QName qName : arrayList) {
            if (set.contains(qName)) continue;
            set.add(qName);
            if (!JRLog.isTrace(6)) continue;
            JRLog.trace(6, "findPrefixNamespaces from node " + node.getLocalName() + " add namespaces=" + qName);
        }
        NodeList nodeList = node.getChildNodes();
        boolean bl = false;
        while (var5_10 < nodeList.getLength()) {
            SecurityUtil.NODESET(nodeList.item((int)var5_10), set);
            ++var5_10;
        }
    }

    private static List SEDU() {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        arrayList.add(new QName("http://www.w3.org/2001/04/xmlenc#", "NotUserLocalPart", "xenc"));
        arrayList.add(new QName("http://www.w3.org/2000/09/xmldsig#", "NotUserLocalPart", "ds"));
        arrayList.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "NotUserLocalPart", "wsse"));
        arrayList.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "NotUserLocalPart", "wsu"));
        return arrayList;
    }

    public static Vector getContentEncryptedElements(Vector vector, Node node, Vector vector2, HashMap hashMap) throws DSException {
        Set set = SecurityUtil.findAllPrefixNamespaces(node, hashMap);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(new NamespaceContextImpl(set));
        for (String string : vector2) {
            try {
                XPathExpression xPathExpression = xPath.compile(string);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(node, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    if (!(node2 instanceof Element)) continue;
                    Element element = (Element)node2;
                    String string2 = element.getLocalName();
                    String string3 = element.getNamespaceURI() != null ? element.getNamespaceURI() : null;
                    WSEncryptionPart wSEncryptionPart = new WSEncryptionPart(string2, string3, "Content", 3);
                    wSEncryptionPart.setXpath(string);
                    Attr attr = element.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    if (attr != null) {
                        wSEncryptionPart.setEncId(attr.getValue());
                    }
                    vector.add(wSEncryptionPart);
                }
            }
            catch (Exception exception) {
                throw new DSException(4238, new String[]{string});
            }
        }
        return vector;
    }

    public static Vector getPartsAndElements(boolean bl, Document document, boolean bl2, Vector vector, Vector vector2, HashMap hashMap) throws DSException {
        Node node;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Element element;
        NodeList nodeList;
        Vector<Object> vector3 = new Vector<Object>();
        Vector<WSEncryptionPart> vector4 = new Vector<WSEncryptionPart>();
        Element element2 = document.getDocumentElement();
        if (bl2) {
            nodeList = element2.getElementsByTagNameNS(element2.getNamespaceURI(), "Body");
            element = null;
            if (nodeList.getLength() <= 0) {
                throw new DSException(4206);
            }
            element = (Element)nodeList.item(0);
            if (bl) {
                vector4.add(new WSEncryptionPart(SecurityUtil.addWsuIdToElement(element), null, 2));
            } else {
                vector4.add(new WSEncryptionPart(SecurityUtil.addWsuIdToElement(element), "Content", 2));
            }
            vector3.add(element);
        }
        nodeList = element2.getElementsByTagNameNS(element2.getNamespaceURI(), "Header");
        element = null;
        if (nodeList.getLength() > 0) {
            element = (Element)nodeList.item(0);
        }
        for (int i = 0; i < vector.size(); ++i) {
            object5 = (WSEncryptionPart)vector.get(i);
            if (object5.getName() == null) {
                int n;
                object4 = new ArrayList();
                object3 = element.getChildNodes();
                for (n = 0; n < object3.getLength(); ++n) {
                    if (!object3.item(n).getNamespaceURI().equals(object5.getNamespace())) continue;
                    ((ArrayList)object4).add(object3.item(n));
                }
                for (n = 0; n < ((ArrayList)object4).size(); ++n) {
                    Object object6 = (Node)((ArrayList)object4).get(n);
                    object2 = element.getElementsByTagNameNS(object6.getNamespaceURI(), object6.getLocalName());
                    object = null;
                    if (object2.getLength() > 0) {
                        object = (Element)object2.item(0);
                    }
                    if (vector3.contains(object)) continue;
                    vector3.add(object);
                    if (bl) {
                        vector4.add(new WSEncryptionPart(object.getLocalName(), object5.getNamespace(), "Content", 1));
                        continue;
                    }
                    WSEncryptionPart wSEncryptionPart = new WSEncryptionPart(object.getLocalName(), object5.getNamespace(), "Element", 1);
                    node = object.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    if (node != null) {
                        wSEncryptionPart.setEncId(node.getValue());
                    }
                    vector4.add(wSEncryptionPart);
                }
                continue;
            }
            object4 = element.getElementsByTagNameNS(object5.getNamespace(), object5.getName());
            object3 = null;
            if (object4.getLength() > 0) {
                object3 = (Element)object4.item(0);
            }
            if (object3 == null || vector3.contains(object3)) continue;
            vector3.add(object3);
            object5.setType(1);
            Attr attr = object3.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            if (attr != null) {
                object5.setEncId(attr.getValue());
            }
            vector4.add((WSEncryptionPart)object5);
        }
        Set set = SecurityUtil.findAllPrefixNamespaces(document, hashMap);
        object5 = new NamespaceContextImpl(set);
        object4 = XPathFactory.newInstance();
        object3 = ((XPathFactory)object4).newXPath();
        object3.setNamespaceContext((NamespaceContext)object5);
        for (Object object6 : vector2) {
            try {
                object2 = object3.compile((String)object6);
                object = (NodeList)object2.evaluate(document, XPathConstants.NODESET);
                for (int i = 0; i < object.getLength(); ++i) {
                    WSEncryptionPart wSEncryptionPart;
                    String string;
                    node = (Element)object.item(i);
                    String string2 = node.getLocalName();
                    String string3 = string = node.getNamespaceURI() != null ? node.getNamespaceURI() : null;
                    if (bl) {
                        wSEncryptionPart = new WSEncryptionPart(string2, string, "Content", 3);
                        wSEncryptionPart.setXpath((String)object6);
                        vector4.add(wSEncryptionPart);
                        continue;
                    }
                    wSEncryptionPart = new WSEncryptionPart(string2, string, "Element", 3);
                    wSEncryptionPart.setXpath((String)object6);
                    Attr attr = node.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    if (attr != null) {
                        wSEncryptionPart.setEncId(attr.getValue());
                    }
                    vector4.add(wSEncryptionPart);
                }
            }
            catch (Exception exception) {
                throw new DSException(4238, new String[]{object6});
            }
        }
        return vector4;
    }

    public static boolean checkRequiredElements(Element element, HashMap hashMap, String string) throws DSException {
        Set set = SecurityUtil.findAllPrefixNamespaces(element, hashMap);
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            xPath.setNamespaceContext(new NamespaceContextImpl(set));
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList.getLength() == 0) {
                return false;
            }
        }
        catch (Exception exception) {
            throw new DSException(4238, new String[]{string});
        }
        return true;
    }

    public static KeyGenerator getEncryptionKeyGenerator(String string) throws DSException {
        KeyGenerator keyGenerator;
        block6: {
            try {
                keyGenerator = KeyGenerator.getInstance("AES");
                if (string.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    keyGenerator = KeyGenerator.getInstance("DESede");
                    break block6;
                }
                if (string.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    keyGenerator.init(128);
                    break block6;
                }
                if (string.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    keyGenerator.init(192);
                    break block6;
                }
                if (string.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    keyGenerator.init(256);
                    break block6;
                }
                return null;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new DSException(4239, new String[]{string});
            }
        }
        return keyGenerator;
    }

    public static void setEncryptionUser(SecurityDataContext securityDataContext, WSSecEncryptedKey wSSecEncryptedKey) throws DSException {
        String string = securityDataContext.getEncryUser();
        SecurityUtil.setEncryptionUser(securityDataContext, wSSecEncryptedKey, string);
    }

    public static void setEncryptionUser(SecurityDataContext securityDataContext, WSSecEncryptedKey wSSecEncryptedKey, String string) throws DSException {
        if (string == null) {
            string = securityDataContext.getEncryUser();
        }
        if (string == null || "".equals(string)) {
            throw new DSException(4240);
        }
        wSSecEncryptedKey.setUserInfo(string);
    }

    public static void setKeyIdentifierType(SecurityData securityData, WSSecBase wSSecBase, Token token) {
        if (token.getInclusion() == 1) {
            AbstractSecurityAssertion abstractSecurityAssertion;
            boolean bl = false;
            if (token instanceof X509Token) {
                abstractSecurityAssertion = (X509Token)token;
                if (((X509Token)abstractSecurityAssertion).isRequireIssuerSerialReference()) {
                    wSSecBase.setKeyIdentifierType(2);
                    bl = true;
                } else if (((X509Token)abstractSecurityAssertion).isRequireKeyIdentifierReference()) {
                    wSSecBase.setKeyIdentifierType(4);
                    bl = true;
                } else if (((X509Token)abstractSecurityAssertion).isRequireThumbprintReference()) {
                    wSSecBase.setKeyIdentifierType(8);
                    bl = true;
                }
            }
            if (!bl) {
                abstractSecurityAssertion = securityData.getWss11();
                if (abstractSecurityAssertion == null) {
                    abstractSecurityAssertion = securityData.getWss10();
                }
                if (((Wss10)abstractSecurityAssertion).isMustSupportRefKeyIdentifier()) {
                    wSSecBase.setKeyIdentifierType(4);
                } else if (((Wss10)abstractSecurityAssertion).isMustSupportRefIssuerSerial()) {
                    wSSecBase.setKeyIdentifierType(2);
                } else if (abstractSecurityAssertion instanceof Wss11 && ((Wss11)abstractSecurityAssertion).isMustSupportRefThumbprint()) {
                    wSSecBase.setKeyIdentifierType(8);
                }
            }
        } else {
            wSSecBase.setKeyIdentifierType(1);
        }
    }

    private static X509Certificate add(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            WSHandlerResult wSHandlerResult = (WSHandlerResult)vector.get(i);
            Vector vector2 = wSHandlerResult.getResults();
            for (int j = 0; j < vector2.size(); ++j) {
                WSSecurityEngineResult wSSecurityEngineResult = (WSSecurityEngineResult)vector2.get(j);
                Integer n = (Integer)wSSecurityEngineResult.get((Object)"action");
                if (n != 2) continue;
                return (X509Certificate)wSSecurityEngineResult.get((Object)"x509-certificate");
            }
        }
        return null;
    }

    public static String getUsername(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            WSHandlerResult wSHandlerResult = (WSHandlerResult)vector.get(i);
            Vector vector2 = wSHandlerResult.getResults();
            for (int j = 0; j < vector2.size(); ++j) {
                WSSecurityEngineResult wSSecurityEngineResult = (WSSecurityEngineResult)vector2.get(j);
                Integer n = (Integer)wSSecurityEngineResult.get((Object)"action");
                if (n != 1) continue;
                WSUsernameTokenPrincipal wSUsernameTokenPrincipal = (WSUsernameTokenPrincipal)wSSecurityEngineResult.get((Object)"principal");
                return wSUsernameTokenPrincipal.getName();
            }
        }
        return null;
    }

    public static String getRequestEncryptedKeyId(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            WSHandlerResult wSHandlerResult = (WSHandlerResult)vector.get(i);
            Vector vector2 = wSHandlerResult.getResults();
            for (int j = 0; j < vector2.size(); ++j) {
                WSSecurityEngineResult wSSecurityEngineResult = (WSSecurityEngineResult)vector2.get(j);
                Integer n = (Integer)wSSecurityEngineResult.get((Object)"action");
                String string = (String)wSSecurityEngineResult.get((Object)"encrypted-key-id");
                if (n != 4 || string == null) continue;
                return string;
            }
        }
        return null;
    }

    public static byte[] getRequestEncryptedKeyValue(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            WSHandlerResult wSHandlerResult = (WSHandlerResult)vector.get(i);
            Vector vector2 = wSHandlerResult.getResults();
            for (int j = 0; j < vector2.size(); ++j) {
                WSSecurityEngineResult wSSecurityEngineResult = (WSSecurityEngineResult)vector2.get(j);
                Integer n = (Integer)wSSecurityEngineResult.get((Object)"action");
                byte[] byArray = (byte[])wSSecurityEngineResult.get((Object)"decrypted-key");
                if (n != 4 || byArray == null) continue;
                return byArray;
            }
        }
        return null;
    }

    public static Element insertSiblingAfter(SecurityDataContext securityDataContext, Element element, Element element2) {
        if (element == null) {
            return SecurityUtil.appendChildToSecHeader(securityDataContext, element2);
        }
        if (element.getOwnerDocument().equals(element2.getOwnerDocument())) {
            if (element.getParentNode() == null && !element.getLocalName().equals("UsernameToken")) {
                securityDataContext.getSecHeader().getSecurityHeader().appendChild(element);
            }
            element.getParentNode().insertBefore(element2, element.getNextSibling());
            return element2;
        }
        Element element3 = (Element)element.getOwnerDocument().importNode(element2, true);
        element.getParentNode().insertBefore(element3, element.getNextSibling());
        return element3;
    }

    public static Element insertSiblingAfterOrPrepend(SecurityDataContext securityDataContext, Element element, Element element2) {
        Element element3 = null;
        element3 = element != null ? SecurityUtil.insertSiblingAfter(securityDataContext, element, element2) : SecurityUtil.addWsuIdToElement(securityDataContext, element2);
        return element3;
    }

    public static Element insertSiblingBefore(SecurityDataContext securityDataContext, Element element, Element element2) {
        if (element == null) {
            return SecurityUtil.appendChildToSecHeader(securityDataContext, element2);
        }
        if (element.getOwnerDocument().equals(element2.getOwnerDocument())) {
            element.getParentNode().insertBefore(element2, element);
            return element2;
        }
        Element element3 = (Element)element.getOwnerDocument().importNode(element2, true);
        element.getParentNode().insertBefore(element3, element);
        return element3;
    }

    public static Element insertSiblingBeforeOrPrepend(SecurityDataContext securityDataContext, Element element, Element element2) {
        Element element3 = null;
        element3 = element != null && element.getPreviousSibling() != null ? SecurityUtil.insertSiblingBefore(securityDataContext, element, element2) : SecurityUtil.addWsuIdToElement(securityDataContext, element2);
        return element3;
    }

    private static Element addWsuIdToElement(SecurityDataContext securityDataContext, Element element) {
        Element element2 = null;
        Element element3 = securityDataContext.getSecHeader().getSecurityHeader();
        Node node = element3.getOwnerDocument().importNode(element, true);
        Element element4 = (Element)element3.getFirstChild();
        if (element4 == null) {
            element2 = (Element)element3.appendChild(node);
        } else if (element4.getOwnerDocument().equals(element.getOwnerDocument())) {
            element4.getParentNode().insertBefore(element, element4);
            element2 = element;
        } else {
            Element element5 = (Element)element4.getOwnerDocument().importNode(element, true);
            element4.getParentNode().insertBefore(element5, element4);
            element2 = element5;
        }
        return element2;
    }

    public static void handleEncryptedSignedHeaders(Vector vector, Vector vector2, Document document) {
        for (int i = 0; i < vector2.size(); ++i) {
            WSEncryptionPart wSEncryptionPart = (WSEncryptionPart)vector2.get(i);
            if (wSEncryptionPart.getNamespace() == null || wSEncryptionPart.getName() == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                Element element;
                String string;
                WSEncryptionPart wSEncryptionPart2 = (WSEncryptionPart)vector.get(j);
                if (wSEncryptionPart2.getNamespace() == null || wSEncryptionPart2.getName() == null || !wSEncryptionPart.getName().equals(wSEncryptionPart2.getName()) || !wSEncryptionPart.getNamespace().equals(wSEncryptionPart2.getNamespace())) continue;
                String string2 = wSEncryptionPart2.getEncId();
                Element element2 = WSSecurityUtil.findElementById((Node)document.getDocumentElement(), (String)string2, null);
                if (element2 == null || (string = (element = (Element)element2.getParentNode()).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) == null || "".equals(string.trim())) continue;
                vector2.remove(wSEncryptionPart);
                WSEncryptionPart wSEncryptionPart3 = new WSEncryptionPart(string);
                vector2.add(wSEncryptionPart3);
            }
        }
    }

    public static String getSigElementId(SecurityDataContext securityDataContext) throws DSException {
        Node node;
        Object object;
        Element element = securityDataContext.getDocument().getDocumentElement();
        NodeList nodeList = element.getElementsByTagNameNS(element.getNamespaceURI(), "Header");
        Element element2 = null;
        Element element3 = null;
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!(node2 instanceof Element) || !node2.getNamespaceURI().equals(element.getNamespaceURI()) || !node2.getLocalName().equals("Header")) continue;
                element2 = (Element)node2;
                break;
            }
        } else {
            throw new DSException(4231);
        }
        if (element2 != null) {
            object = element2.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
            for (int i = 0; i < object.getLength(); ++i) {
                node = object.item(i);
                if (!(node instanceof Element) || !node.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") || !node.getLocalName().equals("Security")) continue;
                element3 = (Element)node;
                break;
            }
        } else {
            throw new DSException(4231);
        }
        if (element3 == null) {
            throw new DSException(4232);
        }
        object = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
        QName qName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        node = null;
        NodeList nodeList2 = element3.getElementsByTagNameNS(((QName)object).getNamespaceURI(), ((QName)object).getLocalPart());
        if (nodeList2 != null && nodeList2.getLength() > 0) {
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                if (!(nodeList2.item(i) instanceof Element)) continue;
                node = (Element)nodeList2.item(i);
                break;
            }
        } else {
            throw new DSException(4241, new String[]{"{" + ((QName)object).getNamespaceURI() + "}" + ((QName)object).getLocalPart()});
        }
        Attr attr = node.getAttributeNodeNS(qName.getNamespaceURI(), qName.getLocalPart());
        if (attr != null) {
            return attr.getValue();
        }
        attr = node.getAttributeNode("Id");
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public static WSSConfig getWSSConfigInstance() {
        WSSConfig wSSConfig = WSSConfig.getDefaultWSConfig();
        WSSConfig wSSConfig2 = WSSConfig.getNewInstance();
        wSSConfig2.setEnableSignatureConfirmation(wSSConfig.isEnableSignatureConfirmation());
        wSSConfig2.setTimeStampStrict(wSSConfig.isTimeStampStrict());
        wSSConfig2.setWsiBSPCompliant(wSSConfig.isWsiBSPCompliant());
        wSSConfig2.setPrecisionInMilliSeconds(wSSConfig.isPrecisionInMilliSeconds());
        return wSSConfig2;
    }

    private static class CachedCrypto {
        private Crypto SEDU;
        private long I;

        public CachedCrypto(Crypto crypto, long l) {
            this.SEDU = crypto;
            this.I = l;
        }
    }
}

