/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.impl.processor;

import com.jinfonet.webservice.security.impl.SToken;
import com.jinfonet.webservice.security.impl.SecurityData;
import com.jinfonet.webservice.security.impl.SecurityDataContext;
import com.jinfonet.webservice.security.impl.SecurityUtil;
import com.jinfonet.webservice.security.impl.SupportingSecurityData;
import com.jinfonet.webservice.security.impl.processor.BindingProcessor;
import com.jinfonet.webservice.security.model.AbstractSecurityAssertion;
import com.jinfonet.webservice.security.model.AlgorithmSuite;
import com.jinfonet.webservice.security.model.SupportingToken;
import com.jinfonet.webservice.security.model.Token;
import com.jinfonet.webservice.security.model.X509Token;
import java.util.HashMap;
import java.util.Vector;
import jet.dataengine.api.DSException;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AsymmetricBindingProcessor
extends BindingProcessor {
    private boolean SEDU = false;
    private Token add;
    private WSSecSignature addReferencesToSign;
    private WSSecEncryptedKey addSignatureParts;
    private String addTimestamp;
    private byte[] addWsuIdToElement;
    private Element appendChild;
    private Element appendChildToSecHeader;
    private Element computeSignature;
    private Vector currentTimeMillis = new Vector();
    private Element doEndorsedSignatures;

    public void build(SecurityDataContext securityDataContext) throws DSException {
        if (securityDataContext.getSecData().isIncludeTimestamp()) {
            this.addTimestamp(securityDataContext);
        }
        if ("EncryptBeforeSigning".equals(securityDataContext.getSecData().getProtectionOrder())) {
            this.SEDU(securityDataContext);
        } else {
            this.add(securityDataContext);
        }
    }

    private void SEDU(SecurityDataContext securityDataContext) throws DSException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        if (this.SEDU) {
            l = System.currentTimeMillis();
        }
        SecurityData securityData = securityDataContext.getSecData();
        Document document = securityDataContext.getDocument();
        Element element = null;
        WSSecEncrypt wSSecEncrypt = null;
        Element element2 = null;
        WSSecDKEncrypt wSSecDKEncrypt = null;
        Token token = null;
        token = securityDataContext.isInitiator() ? securityData.getRecipientToken() : securityData.getInitiatorToken();
        Vector vector = SecurityUtil.getEncryptedParts(securityDataContext);
        this.currentTimeMillis = SecurityUtil.getSignedParts(securityDataContext);
        if (token == null && vector.size() > 0) {
            throw new DSException(4191);
        }
        if (token != null && vector.size() > 0) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            if (token.isDerivedKeys()) {
                try {
                    this.addWsuIdToElement(securityDataContext, token);
                    wSSecDKEncrypt = new WSSecDKEncrypt();
                    wSSecDKEncrypt.setParts(vector);
                    wSSecDKEncrypt.setExternalKey(this.addWsuIdToElement, this.addTimestamp);
                    wSSecDKEncrypt.setSymmetricEncAlgorithm(securityData.getAlgorithmSuite().getEncryption());
                    wSSecDKEncrypt.setDerivedKeyLength(securityData.getAlgorithmSuite().getEncryptionDerivedKeyLength() / 8);
                    wSSecDKEncrypt.prepare(document);
                    this.computeSignature = wSSecDKEncrypt.getdktElement();
                    element = SecurityUtil.appendChildToSecHeader(securityDataContext, this.computeSignature);
                    element2 = wSSecDKEncrypt.encryptForExternalRef(null, vector);
                }
                catch (Exception exception) {
                    throw new DSException(4192, (Throwable)exception);
                }
            }
            try {
                wSSecEncrypt = new WSSecEncrypt();
                wSSecEncrypt.setParts(vector);
                wSSecEncrypt.setDocument(document);
                SecurityUtil.setEncryptionUser(securityDataContext, (WSSecEncryptedKey)wSSecEncrypt);
                wSSecEncrypt.setSymmetricEncAlgorithm(securityData.getAlgorithmSuite().getEncryption());
                SecurityUtil.setKeyIdentifierType(securityData, (WSSecBase)wSSecEncrypt, token);
                wSSecEncrypt.setKeyEncAlgo(securityData.getAlgorithmSuite().getAsymmetricKeyWrap());
                wSSecEncrypt.prepare(document, securityDataContext.getEncrypto());
                object6 = wSSecEncrypt.getBinarySecurityTokenElement();
                if (object6 != null) {
                    SecurityUtil.appendChildToSecHeader(securityDataContext, (Element)object6);
                }
                this.appendChild = wSSecEncrypt.getEncryptedKeyElement();
                this.appendChild = SecurityUtil.appendChildToSecHeader(securityDataContext, this.appendChild);
                element2 = wSSecEncrypt.encryptForExternalRef(null, vector);
            }
            catch (WSSecurityException wSSecurityException) {
                throw new DSException(4192, (Throwable)wSSecurityException);
            }
            SecurityUtil.appendChildToSecHeader(securityDataContext, element2);
            if (this.SEDU) {
                l2 = System.currentTimeMillis();
            }
            this.setInsertionLocation(this.appendChild);
            SecurityUtil.handleEncryptedSignedHeaders(vector, this.currentTimeMillis, document);
            object6 = null;
            HashMap hashMap = null;
            HashMap hashMap2 = null;
            HashMap hashMap3 = null;
            HashMap hashMap4 = null;
            HashMap hashMap5 = null;
            if (this.timestampElement != null) {
                this.currentTimeMillis.add(new WSEncryptionPart(SecurityUtil.addWsuIdToElement(this.timestampElement)));
            }
            if (securityDataContext.isInitiator()) {
                object5 = securityData.getSignedSupportingTokens();
                object6 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object5);
                object4 = securityData.getEndorsingSupportingTokens();
                hashMap = this.handleSupportingTokens(securityDataContext, (SupportingToken)object4);
                object3 = securityData.getSignedEndorsingSupportingTokens();
                hashMap2 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object3);
                SupportingToken supportingToken = securityData.getSignedEncryptedSupportingTokens();
                hashMap3 = this.handleSupportingTokens(securityDataContext, supportingToken);
                object2 = securityData.getEndorsingEncryptedSupportingTokens();
                hashMap4 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object2);
                object = securityData.getSignedEndorsingEncryptedSupportingTokens();
                hashMap5 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object);
                Vector vector2 = securityData.getSupportingTokensList();
                for (int i = 0; i < vector2.size(); ++i) {
                    this.handleSupportingTokens(securityDataContext, (SupportingToken)vector2.get(i));
                }
                SupportingToken supportingToken2 = securityData.getEncryptedSupportingTokens();
                this.handleSupportingTokens(securityDataContext, supportingToken2);
                this.currentTimeMillis = this.addSignatureParts((HashMap)object6, this.currentTimeMillis);
                this.currentTimeMillis = this.addSignatureParts(hashMap3, this.currentTimeMillis);
                this.currentTimeMillis = this.addSignatureParts(hashMap2, this.currentTimeMillis);
                this.currentTimeMillis = this.addSignatureParts(hashMap5, this.currentTimeMillis);
            }
            if (this.currentTimeMillis.size() > 0 && securityDataContext.isInitiator() && securityData.getInitiatorToken() != null || !securityDataContext.isInitiator() && securityData.getRecipientToken() != null) {
                this.addSignatureParts(securityDataContext);
            }
            if (securityDataContext.isInitiator()) {
                hashMap.putAll(hashMap4);
                object5 = this.doEndorsedSignatures(securityDataContext, hashMap);
                object4 = ((Vector)object5).iterator();
                while (object4.hasNext()) {
                    securityDataContext.getSignatureValues().add(object4.next());
                }
                hashMap2.putAll(hashMap5);
                object4 = this.doEndorsedSignatures(securityDataContext, hashMap2);
                object3 = ((Vector)object4).iterator();
                while (object3.hasNext()) {
                    securityDataContext.getSignatureValues().add(object3.next());
                }
            }
            if (securityData.isSignatureProtection() && this.mainSigId != null) {
                long l4 = 0L;
                long l5 = 0L;
                if (this.SEDU) {
                    l4 = System.currentTimeMillis();
                }
                object2 = new Vector<WSEncryptionPart>();
                ((Vector)object2).add(new WSEncryptionPart(this.mainSigId, "Element"));
                if (securityDataContext.isInitiator()) {
                    for (int i = 0; i < this.encryptedTokensIdList.size(); ++i) {
                        ((Vector)object2).add(new WSEncryptionPart((String)this.encryptedTokensIdList.get(i), "Element"));
                    }
                }
                object = null;
                if (token.isDerivedKeys()) {
                    try {
                        object = wSSecDKEncrypt.encryptForExternalRef(null, (Vector)object2);
                        SecurityUtil.insertSiblingAfter(securityDataContext, element, (Element)object);
                    }
                    catch (WSSecurityException wSSecurityException) {
                        throw new DSException(4192, (Throwable)wSSecurityException);
                    }
                }
                try {
                    object = wSSecEncrypt.encryptForExternalRef(null, (Vector)object2);
                    this.setInsertionLocation(SecurityUtil.insertSiblingAfter(securityDataContext, this.appendChild, (Element)object));
                }
                catch (WSSecurityException wSSecurityException) {
                    throw new DSException(4192, (Throwable)wSSecurityException);
                }
            }
        }
    }

    private void add(SecurityDataContext securityDataContext) throws DSException {
        Token token;
        Object object;
        Object object2;
        Object object3;
        AbstractSecurityAssertion abstractSecurityAssertion;
        Object object4;
        Object object5;
        Object object6;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        SecurityData securityData = securityDataContext.getSecData();
        Document document = securityDataContext.getDocument();
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        HashMap hashMap3 = null;
        HashMap hashMap4 = null;
        HashMap hashMap5 = null;
        HashMap hashMap6 = null;
        this.currentTimeMillis = SecurityUtil.getSignedParts(securityDataContext);
        if (this.timestampElement != null) {
            this.currentTimeMillis.add(new WSEncryptionPart(SecurityUtil.addWsuIdToElement(this.timestampElement)));
        } else {
            this.setInsertionLocation(null);
        }
        if (securityDataContext.isInitiator()) {
            object6 = securityData.getSignedSupportingTokens();
            hashMap = this.handleSupportingTokens(securityDataContext, (SupportingToken)object6);
            SupportingToken supportingToken = securityData.getEndorsingSupportingTokens();
            hashMap2 = this.handleSupportingTokens(securityDataContext, supportingToken);
            object5 = securityData.getSignedEndorsingSupportingTokens();
            hashMap3 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object5);
            object4 = securityData.getSignedEncryptedSupportingTokens();
            hashMap4 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object4);
            abstractSecurityAssertion = securityData.getEndorsingEncryptedSupportingTokens();
            hashMap5 = this.handleSupportingTokens(securityDataContext, (SupportingToken)abstractSecurityAssertion);
            object3 = securityData.getSignedEndorsingEncryptedSupportingTokens();
            hashMap6 = this.handleSupportingTokens(securityDataContext, (SupportingToken)object3);
            object2 = securityData.getSupportingTokensList();
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                this.handleSupportingTokens(securityDataContext, (SupportingToken)((Vector)object2).get(i));
            }
            object = securityData.getEncryptedSupportingTokens();
            this.handleSupportingTokens(securityDataContext, (SupportingToken)object);
            this.currentTimeMillis = this.addSignatureParts(hashMap, this.currentTimeMillis);
            this.currentTimeMillis = this.addSignatureParts(hashMap4, this.currentTimeMillis);
            this.currentTimeMillis = this.addSignatureParts(hashMap3, this.currentTimeMillis);
            this.currentTimeMillis = this.addSignatureParts(hashMap6, this.currentTimeMillis);
        }
        if (this.currentTimeMillis.size() > 0 && (securityDataContext.isInitiator() && securityData.getInitiatorToken() != null || !securityDataContext.isInitiator() && securityData.getRecipientToken() != null)) {
            this.addSignatureParts(securityDataContext);
        }
        object6 = securityData.getSupportingPolicyData();
        for (int i = 0; i < ((Vector)object6).size(); ++i) {
            object5 = null;
            if (((Vector)object6).get(i) == null || ((Vector)(object4 = SecurityUtil.getSupportingSignedParts(securityDataContext, (SupportingSecurityData)(object5 = (SupportingSecurityData)((Vector)object6).get(i))))).size() <= 0 || (!securityDataContext.isInitiator() || securityData.getInitiatorToken() == null) && (securityDataContext.isInitiator() || securityData.getRecipientToken() == null)) continue;
            this.addReferencesToSign(securityDataContext, (Vector)object4, (SupportingSecurityData)object5);
        }
        if (securityDataContext.isInitiator()) {
            hashMap2.putAll(hashMap5);
            Vector vector = this.doEndorsedSignatures(securityDataContext, hashMap2);
            object5 = vector.iterator();
            while (object5.hasNext()) {
                securityDataContext.getSignatureValues().add(object5.next());
            }
            hashMap3.putAll(hashMap6);
            object5 = this.doEndorsedSignatures(securityDataContext, hashMap3);
            object4 = ((Vector)object5).iterator();
            while (object4.hasNext()) {
                securityDataContext.getSignatureValues().add(object4.next());
            }
        }
        Vector vector = SecurityUtil.getEncryptedParts(securityDataContext);
        if (securityData.isSignatureProtection() && this.mainSigId != null) {
            vector.add(new WSEncryptionPart(SecurityUtil.addWsuIdToElement(this.doEndorsedSignatures), "Element"));
        }
        if (securityDataContext.isInitiator()) {
            for (int i = 0; i < this.encryptedTokensIdList.size(); ++i) {
                vector.add(new WSEncryptionPart((String)this.encryptedTokensIdList.get(i), "Element"));
            }
        }
        if ((token = securityDataContext.isInitiator() ? securityData.getRecipientToken() : securityData.getInitiatorToken()) != null && vector.size() > 0) {
            object4 = null;
            abstractSecurityAssertion = securityData.getAlgorithmSuite();
            if (token.isDerivedKeys()) {
                try {
                    object3 = new WSSecDKEncrypt();
                    if (this.addSignatureParts == null) {
                        this.addWsuIdToElement(securityDataContext, token);
                    }
                    object3.setExternalKey(this.addWsuIdToElement, this.addTimestamp);
                    object3.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    object3.setSymmetricEncAlgorithm(((AlgorithmSuite)abstractSecurityAssertion).getEncryption());
                    object3.setDerivedKeyLength(((AlgorithmSuite)abstractSecurityAssertion).getEncryptionDerivedKeyLength() / 8);
                    object3.prepare(document);
                    this.computeSignature = this.appendChild != null ? SecurityUtil.insertSiblingAfter(securityDataContext, this.appendChild, object3.getdktElement()) : SecurityUtil.insertSiblingBefore(securityDataContext, this.appendChildToSecHeader, object3.getdktElement());
                    object4 = object3.encryptForExternalRef(null, vector);
                    SecurityUtil.insertSiblingAfter(securityDataContext, this.computeSignature, (Element)object4);
                }
                catch (Exception exception) {
                    throw new DSException(4192, (Throwable)exception);
                }
            }
            try {
                object3 = new WSSecEncrypt();
                SecurityUtil.setKeyIdentifierType(securityData, (WSSecBase)object3, token);
                object3.setDocument(document);
                SecurityUtil.setEncryptionUser(securityDataContext, (WSSecEncryptedKey)object3);
                object3.setSymmetricEncAlgorithm(((AlgorithmSuite)abstractSecurityAssertion).getEncryption());
                object3.setKeyEncAlgo(((AlgorithmSuite)abstractSecurityAssertion).getAsymmetricKeyWrap());
                object3.prepare(document, securityDataContext.getEncrypto());
                if (this.timestampElement != null) {
                    this.setInsertionLocation(this.timestampElement);
                } else {
                    this.setInsertionLocation(null);
                }
                if (object3.getBSTTokenId() != null) {
                    this.setInsertionLocation(SecurityUtil.insertSiblingAfterOrPrepend(securityDataContext, this.getInsertionLocation(), object3.getBinarySecurityTokenElement()));
                }
                object2 = object3.getEncryptedKeyElement();
                object4 = object3.encryptForInternalRef(null, vector);
                object2.appendChild((Node)object4);
                this.setInsertionLocation(SecurityUtil.insertSiblingAfterOrPrepend(securityDataContext, this.getInsertionLocation(), (Element)object2));
            }
            catch (WSSecurityException wSSecurityException) {
                throw new DSException(4192, (Throwable)wSSecurityException);
            }
        }
        object4 = securityData.getSupportingPolicyData();
        for (int i = 0; i < ((Vector)object4).size(); ++i) {
            object3 = null;
            if (((Vector)object4).get(i) == null) continue;
            object3 = (SupportingSecurityData)((Vector)object4).get(i);
            object2 = ((SecurityData)object3).getEncryptionToken();
            object = SecurityUtil.getSupportingEncryptedParts(securityDataContext, (SupportingSecurityData)object3);
            if (object2 == null || ((Vector)object).size() <= 0) continue;
            this.addTimestamp(securityData, securityDataContext, (Token)object2, document, (Vector)object);
        }
    }

    private void addReferencesToSign(SecurityDataContext securityDataContext, Vector vector, SupportingSecurityData supportingSecurityData) throws DSException {
        Token token = supportingSecurityData.getSignatureToken();
        if (!(token instanceof X509Token)) {
            return;
        }
        WSSecSignature wSSecSignature = this.getSignatureBuider(securityDataContext, token, ((X509Token)token).getUserCertAlias());
        Element element = wSSecSignature.getBinarySecurityTokenElement();
        if (element != null) {
            element = SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), element);
            this.setInsertionLocation(element);
        }
        if (securityDataContext.getSecData().isTokenProtection() && wSSecSignature.getBSTTokenId() != null) {
            vector.add(new WSEncryptionPart(wSSecSignature.getBSTTokenId()));
        }
        try {
            wSSecSignature.addReferencesToSign(vector, securityDataContext.getSecHeader());
            wSSecSignature.computeSignature();
            Element element2 = wSSecSignature.getSignatureElement();
            this.setInsertionLocation(SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), element2));
        }
        catch (WSSecurityException wSSecurityException) {
            throw new DSException(4193, (Throwable)wSSecurityException);
        }
        securityDataContext.getSignatureValues().add(wSSecSignature.getSignatureValue());
    }

    private void addSignatureParts(SecurityDataContext securityDataContext) throws DSException {
        SecurityData securityData = securityDataContext.getSecData();
        Document document = securityDataContext.getDocument();
        long l = 0L;
        long l2 = 0L;
        if (this.SEDU) {
            l = System.currentTimeMillis();
        }
        this.add = securityDataContext.isInitiator() ? securityData.getInitiatorToken() : securityData.getRecipientToken();
        if (this.add.isDerivedKeys()) {
            if (this.addSignatureParts == null) {
                this.addWsuIdToElement(securityDataContext, this.add);
            }
            WSSecDKSign wSSecDKSign = new WSSecDKSign();
            wSSecDKSign.setExternalKey(this.addWsuIdToElement, this.addTimestamp);
            wSSecDKSign.setSignatureAlgorithm(securityData.getAlgorithmSuite().getSymmetricSignature());
            wSSecDKSign.setDerivedKeyLength(securityData.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
            wSSecDKSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            try {
                wSSecDKSign.prepare(document, securityDataContext.getSecHeader());
                if (securityData.isTokenProtection()) {
                    this.currentTimeMillis.add(new WSEncryptionPart(this.addSignatureParts.getId()));
                }
                wSSecDKSign.setParts(this.currentTimeMillis);
                wSSecDKSign.addReferencesToSign(this.currentTimeMillis, securityDataContext.getSecHeader());
                wSSecDKSign.computeSignature();
                this.appendChildToSecHeader = SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), wSSecDKSign.getdktElement());
                this.setInsertionLocation(this.appendChildToSecHeader);
                this.setInsertionLocation(SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), wSSecDKSign.getSignatureElement()));
                this.mainSigId = SecurityUtil.addWsuIdToElement(wSSecDKSign.getSignatureElement());
                securityDataContext.getSignatureValues().add(wSSecDKSign.getSignatureValue());
                this.doEndorsedSignatures = wSSecDKSign.getSignatureElement();
            }
            catch (Exception exception) {
                throw new DSException(4194, (Throwable)exception);
            }
        }
        this.addReferencesToSign = this.getSignatureBuider(securityDataContext, this.add);
        Element element = this.addReferencesToSign.getBinarySecurityTokenElement();
        if (element != null) {
            element = SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), element);
            this.setInsertionLocation(element);
        }
        if (securityData.isTokenProtection() && this.addReferencesToSign.getBSTTokenId() != null) {
            this.currentTimeMillis.add(new WSEncryptionPart(this.addReferencesToSign.getBSTTokenId()));
        }
        try {
            this.addReferencesToSign.addReferencesToSign(this.currentTimeMillis, securityDataContext.getSecHeader());
            this.addReferencesToSign.computeSignature();
            this.doEndorsedSignatures = this.addReferencesToSign.getSignatureElement();
            this.setInsertionLocation(SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), this.doEndorsedSignatures));
            this.mainSigId = SecurityUtil.addWsuIdToElement(this.doEndorsedSignatures);
        }
        catch (WSSecurityException wSSecurityException) {
            throw new DSException(4194, (Throwable)wSSecurityException);
        }
        securityDataContext.getSignatureValues().add(this.addReferencesToSign.getSignatureValue());
    }

    private void addTimestamp(SecurityData securityData, SecurityDataContext securityDataContext, Token token, Document document, Vector vector) throws DSException {
        Element element = null;
        try {
            if (!(token instanceof X509Token)) {
                return;
            }
            WSSecEncrypt wSSecEncrypt = new WSSecEncrypt();
            SecurityUtil.setKeyIdentifierType(securityData, (WSSecBase)wSSecEncrypt, token);
            wSSecEncrypt.setDocument(document);
            SecurityUtil.setEncryptionUser(securityDataContext, (WSSecEncryptedKey)wSSecEncrypt, ((X509Token)token).getEncryptionUser());
            wSSecEncrypt.setSymmetricEncAlgorithm(securityData.getAlgorithmSuite().getEncryption());
            wSSecEncrypt.setKeyEncAlgo(securityData.getAlgorithmSuite().getAsymmetricKeyWrap());
            wSSecEncrypt.prepare(document, securityDataContext.getEncrypto());
            if (this.timestampElement != null) {
                this.setInsertionLocation(this.timestampElement);
            } else {
                this.setInsertionLocation(null);
            }
            if (wSSecEncrypt.getBSTTokenId() != null) {
                this.setInsertionLocation(SecurityUtil.insertSiblingAfterOrPrepend(securityDataContext, this.getInsertionLocation(), wSSecEncrypt.getBinarySecurityTokenElement()));
            }
            Element element2 = wSSecEncrypt.getEncryptedKeyElement();
            element = wSSecEncrypt.encryptForInternalRef(null, vector);
            element2.appendChild(element);
            this.setInsertionLocation(SecurityUtil.insertSiblingAfterOrPrepend(securityDataContext, this.getInsertionLocation(), element2));
        }
        catch (WSSecurityException wSSecurityException) {
            throw new DSException(4195, (Throwable)wSSecurityException);
        }
    }

    private void addWsuIdToElement(SecurityDataContext securityDataContext, Token token) throws DSException {
        this.addSignatureParts = this.getEncryptedKeyBuilder(securityDataContext, token);
        Element element = this.addSignatureParts.getBinarySecurityTokenElement();
        if (element != null) {
            SecurityUtil.appendChildToSecHeader(securityDataContext, element);
        }
        this.appendChild = this.addSignatureParts.getEncryptedKeyElement();
        this.appendChild = SecurityUtil.appendChildToSecHeader(securityDataContext, this.appendChild);
        this.addWsuIdToElement = this.addSignatureParts.getEphemeralKey();
        this.addTimestamp = this.addSignatureParts.getId();
        try {
            SToken sToken = new SToken(this.addTimestamp, this.appendChild, null, null);
            sToken.setSecret(this.addWsuIdToElement);
            securityDataContext.getTokenStorage().add(sToken);
        }
        catch (Exception exception) {
            throw new DSException(4196, (Throwable)exception);
        }
    }
}

