/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.webservice.security.impl.processor;

import com.jinfonet.webservice.security.impl.SToken;
import com.jinfonet.webservice.security.impl.SecurityData;
import com.jinfonet.webservice.security.impl.SecurityDataContext;
import com.jinfonet.webservice.security.impl.SecurityUtil;
import com.jinfonet.webservice.security.impl.SupportingSecurityData;
import com.jinfonet.webservice.security.model.SupportingToken;
import com.jinfonet.webservice.security.model.Token;
import com.jinfonet.webservice.security.model.UsernameToken;
import com.jinfonet.webservice.security.model.X509Token;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import jet.dataengine.api.DSException;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BindingProcessor {
    private Element addSupportingPolicyData;
    protected String mainSigId = null;
    protected ArrayList encryptedTokensIdList = new ArrayList();
    protected Element timestampElement;
    protected Element mainRefListElement;
    public static final int DEFAULT_TIMESTAMP_TTL = 300;

    protected void addTimestamp(SecurityDataContext securityDataContext) {
        WSSecTimestamp wSSecTimestamp = new WSSecTimestamp();
        wSSecTimestamp.setTimeToLive(300);
        wSSecTimestamp.build(securityDataContext.getDocument(), securityDataContext.getSecHeader());
        securityDataContext.setTimestampId(wSSecTimestamp.getId());
        this.timestampElement = wSSecTimestamp.getElement();
    }

    protected WSSecUsernameToken addUsernameToken(SecurityDataContext securityDataContext, UsernameToken usernameToken) throws DSException {
        String string = securityDataContext.getAuthUser();
        if (string != null && !"".equals(string)) {
            if (usernameToken.isNoPassword()) {
                WSSecUsernameToken wSSecUsernameToken = new WSSecUsernameToken();
                wSSecUsernameToken.setUserInfo(string, null);
                wSSecUsernameToken.setPasswordType(null);
                return wSSecUsernameToken;
            }
            String string2 = securityDataContext.getAuthPwd();
            if (string2 != null && !"".equals(string2)) {
                WSSecUsernameToken wSSecUsernameToken = new WSSecUsernameToken();
                if (usernameToken.isHashPassword()) {
                    wSSecUsernameToken.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                } else {
                    wSSecUsernameToken.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                }
                wSSecUsernameToken.setUserInfo(string, string2);
                return wSSecUsernameToken;
            }
            throw new DSException(4197, new String[]{string});
        }
        throw new DSException(4198);
    }

    protected WSSecEncryptedKey getEncryptedKeyBuilder(SecurityDataContext securityDataContext, Token token) throws DSException {
        SecurityData securityData = securityDataContext.getSecData();
        Document document = securityDataContext.getDocument();
        WSSecEncryptedKey wSSecEncryptedKey = new WSSecEncryptedKey();
        try {
            SecurityUtil.setKeyIdentifierType(securityData, (WSSecBase)wSSecEncryptedKey, token);
            SecurityUtil.setEncryptionUser(securityDataContext, wSSecEncryptedKey);
            wSSecEncryptedKey.setKeySize(securityData.getAlgorithmSuite().getMaximumSymmetricKeyLength());
            wSSecEncryptedKey.setKeyEncAlgo(securityData.getAlgorithmSuite().getAsymmetricKeyWrap());
            wSSecEncryptedKey.prepare(document, securityDataContext.getEncrypto());
            return wSSecEncryptedKey;
        }
        catch (WSSecurityException wSSecurityException) {
            throw new DSException(4199, (Throwable)wSSecurityException);
        }
    }

    protected WSSecSignature getSignatureBuider(SecurityDataContext securityDataContext, Token token) throws DSException {
        return this.getSignatureBuider(securityDataContext, token, null);
    }

    protected WSSecSignature getSignatureBuider(SecurityDataContext securityDataContext, Token token, String string) throws DSException {
        SecurityData securityData = securityDataContext.getSecData();
        WSSecSignature wSSecSignature = new WSSecSignature();
        this.SEDU(wSSecSignature, token);
        SecurityUtil.setKeyIdentifierType(securityData, (WSSecBase)wSSecSignature, token);
        String string2 = null;
        if (string != null) {
            string2 = string;
        }
        if (string2 == null) {
            string2 = securityDataContext.getSignUser();
        }
        String string3 = null;
        if (string2 == null || "".equals(string2)) {
            throw new DSException(4200);
        }
        string3 = securityDataContext.getSignPwd();
        wSSecSignature.setUserInfo(string2, string3);
        wSSecSignature.setSignatureAlgorithm(securityData.getAlgorithmSuite().getAsymmetricSignature());
        wSSecSignature.setSigCanonicalization(securityData.getAlgorithmSuite().getInclusiveC14n());
        try {
            wSSecSignature.prepare(securityDataContext.getDocument(), securityDataContext.getSignto(), securityDataContext.getSecHeader());
        }
        catch (WSSecurityException wSSecurityException) {
            throw new DSException(4194, (Throwable)wSSecurityException);
        }
        return wSSecSignature;
    }

    protected HashMap handleSupportingTokens(SecurityDataContext securityDataContext, SupportingToken supportingToken) throws DSException {
        HashMap<Token, Object> hashMap = new HashMap<Token, Object>();
        if (supportingToken != null && supportingToken.getTokens() != null && supportingToken.getTokens().size() > 0) {
            ArrayList arrayList = supportingToken.getTokens();
            for (Token token : arrayList) {
                Object object;
                Element element;
                WSSecSignature wSSecSignature;
                Object var7_7 = null;
                if (token instanceof X509Token) {
                    wSSecSignature = this.getSignatureBuider(securityDataContext, token);
                    element = wSSecSignature.getBinarySecurityTokenElement();
                    if (element != null) {
                        element = SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), element);
                        object = new SupportingSecurityData();
                        ((SupportingSecurityData)object).build(supportingToken);
                        ((SecurityData)object).setSignatureToken(token);
                        ((SecurityData)object).setEncryptionToken(token);
                        securityDataContext.getSecData().addSupportingPolicyData((SupportingSecurityData)object);
                        if (supportingToken.isEncryptedToken()) {
                            this.encryptedTokensIdList.add(wSSecSignature.getBSTTokenId());
                        }
                    }
                    hashMap.put(token, wSSecSignature);
                    continue;
                }
                if (!(token instanceof UsernameToken)) continue;
                wSSecSignature = this.addUsernameToken(securityDataContext, (UsernameToken)token);
                wSSecSignature.prepare(securityDataContext.getDocument());
                element = wSSecSignature.getUsernameTokenElement();
                element = SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), element);
                this.encryptedTokensIdList.add(wSSecSignature.getId());
                this.setInsertionLocation(element);
                object = new Date();
                SToken sToken = new SToken(wSSecSignature.getId(), element, (Date)object, new Date(((Date)object).getTime() + 300000L));
                hashMap.put(token, sToken);
            }
        }
        return hashMap;
    }

    protected Vector addSignatureParts(HashMap hashMap, Vector vector) throws DSException {
        Set set = hashMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next().getValue();
            WSEncryptionPart wSEncryptionPart = null;
            if (v instanceof SToken) {
                wSEncryptionPart = new WSEncryptionPart(((SToken)v).getId());
            } else if (v instanceof WSSecSignature) {
                WSSecSignature wSSecSignature = (WSSecSignature)v;
                if (wSSecSignature.getBSTTokenId() != null) {
                    wSEncryptionPart = new WSEncryptionPart(wSSecSignature.getBSTTokenId());
                }
            } else {
                throw new DSException(4201, new String[]{v.getClass().getName()});
            }
            vector.add(wSEncryptionPart);
        }
        return vector;
    }

    public Element getInsertionLocation() {
        return this.addSupportingPolicyData;
    }

    public void setInsertionLocation(Element element) {
        this.addSupportingPolicyData = element;
    }

    protected Vector doEndorsedSignatures(SecurityDataContext securityDataContext, HashMap hashMap) throws DSException {
        Set set = hashMap.keySet();
        Vector<byte[]> vector = new Vector<byte[]>();
        for (Token token : set) {
            SToken sToken;
            Object v = hashMap.get(token);
            Vector<WSEncryptionPart> vector2 = new Vector<WSEncryptionPart>();
            vector2.add(new WSEncryptionPart(this.mainSigId));
            if (v instanceof SToken) {
                sToken = (SToken)v;
                if (securityDataContext.getSecData().isTokenProtection()) {
                    vector2.add(new WSEncryptionPart(sToken.getId()));
                }
                this.doSymmSignature(securityDataContext, token, (SToken)v, vector2);
                continue;
            }
            if (!(v instanceof WSSecSignature)) continue;
            sToken = (WSSecSignature)v;
            if (securityDataContext.getSecData().isTokenProtection() && sToken.getBSTTokenId() != null) {
                vector2.add(new WSEncryptionPart(sToken.getBSTTokenId()));
            }
            try {
                sToken.addReferencesToSign(vector2, securityDataContext.getSecHeader());
                sToken.computeSignature();
                this.setInsertionLocation(SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), sToken.getSignatureElement()));
            }
            catch (WSSecurityException wSSecurityException) {
                throw new DSException(4194, (Throwable)wSSecurityException);
            }
            vector.add(sToken.getSignatureValue());
        }
        return vector;
    }

    protected byte[] doSymmSignature(SecurityDataContext securityDataContext, Token token, SToken sToken, Vector vector) throws DSException {
        Document document = securityDataContext.getDocument();
        SecurityData securityData = securityDataContext.getSecData();
        if (token.isDerivedKeys()) {
            try {
                WSSecDKSign wSSecDKSign = new WSSecDKSign();
                wSSecDKSign.setWscVersion(2);
                boolean bl = false;
                if (5 == token.getInclusion() || 2 == token.getInclusion() || securityDataContext.isInitiator() && 3 == token.getInclusion()) {
                    bl = true;
                }
                wSSecDKSign.setExternalKey(sToken.getSecret(), sToken.getId());
                wSSecDKSign.setSignatureAlgorithm(securityData.getAlgorithmSuite().getSymmetricSignature());
                wSSecDKSign.setDerivedKeyLength(securityData.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
                wSSecDKSign.prepare(document, securityDataContext.getSecHeader());
                if (securityData.isTokenProtection()) {
                    String string = sToken.getId();
                    if (string.startsWith("#")) {
                        string = string.substring(1);
                    }
                    vector.add(new WSEncryptionPart(string));
                }
                wSSecDKSign.setParts(vector);
                wSSecDKSign.addReferencesToSign(vector, securityDataContext.getSecHeader());
                wSSecDKSign.computeSignature();
                if (securityData.getProtectionOrder().equals("EncryptBeforeSigning") && this.getInsertionLocation() == null) {
                    this.setInsertionLocation(SecurityUtil.insertSiblingBefore(securityDataContext, this.mainRefListElement, wSSecDKSign.getdktElement()));
                    this.setInsertionLocation(SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), wSSecDKSign.getSignatureElement()));
                } else {
                    this.setInsertionLocation(SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), wSSecDKSign.getdktElement()));
                    this.setInsertionLocation(SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), wSSecDKSign.getSignatureElement()));
                }
                return wSSecDKSign.getSignatureValue();
            }
            catch (Exception exception) {
                throw new DSException(4194, (Throwable)exception);
            }
        }
        try {
            String string;
            WSSecSignature wSSecSignature = new WSSecSignature();
            if (token instanceof X509Token) {
                if (securityDataContext.isInitiator()) {
                    wSSecSignature.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    wSSecSignature.setKeyIdentifierType(9);
                } else {
                    wSSecSignature.setKeyIdentifierType(10);
                }
            }
            if ((string = sToken.getId()).startsWith("#")) {
                string = string.substring(1);
            }
            if (securityData.isTokenProtection()) {
                vector.add(new WSEncryptionPart(string));
            }
            wSSecSignature.setCustomTokenId(string);
            wSSecSignature.setSecretKey(sToken.getSecret());
            wSSecSignature.setSignatureAlgorithm(securityData.getAlgorithmSuite().getAsymmetricSignature());
            wSSecSignature.setSignatureAlgorithm(securityData.getAlgorithmSuite().getSymmetricSignature());
            wSSecSignature.prepare(securityDataContext.getDocument(), securityDataContext.getSignto(), securityDataContext.getSecHeader());
            wSSecSignature.setParts(vector);
            wSSecSignature.addReferencesToSign(vector, securityDataContext.getSecHeader());
            wSSecSignature.computeSignature();
            if (securityData.getProtectionOrder().equals("EncryptBeforeSigning") && this.getInsertionLocation() == null) {
                this.setInsertionLocation(SecurityUtil.insertSiblingBefore(securityDataContext, this.mainRefListElement, wSSecSignature.getSignatureElement()));
            } else {
                this.setInsertionLocation(SecurityUtil.insertSiblingAfter(securityDataContext, this.getInsertionLocation(), wSSecSignature.getSignatureElement()));
            }
            return wSSecSignature.getSignatureValue();
        }
        catch (WSSecurityException wSSecurityException) {
            throw new DSException(4194, (Throwable)wSSecurityException);
        }
    }

    protected SToken getToken(SecurityDataContext securityDataContext, String string) throws DSException {
        SToken sToken = null;
        sToken = securityDataContext.getTokenStorage().getToken(string);
        if (sToken == null) {
            throw new DSException(4202, new String[]{String.valueOf(string)});
        }
        return sToken;
    }

    private void SEDU(WSSecSignature wSSecSignature, Token token) {
        X509Token x509Token;
        if (token instanceof X509Token && ((x509Token = (X509Token)token).getTokenVersionAndType().equals("WssX509PkiPathV1Token10") || x509Token.getTokenVersionAndType().equals("WssX509PkiPathV1Token11"))) {
            wSSecSignature.setUseSingleCertificate(false);
        }
    }
}

